/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.url.impl;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.pluto.driver.config.DriverConfiguration;
import org.apache.pluto.driver.services.portal.PortletWindowConfig;
import org.apache.pluto.driver.services.portal.PublicRenderParameterMapper;
import org.apache.pluto.driver.url.PortalURL;
import org.apache.pluto.driver.url.PortalURLParameter;
import org.apache.pluto.driver.url.PortalURLParser;
import org.apache.pluto.driver.url.PortalURLPublicParameter;
import org.apache.pluto.driver.url.impl.RelativePortalURLImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalURLParserImpl
implements PortalURLParser {
    private static final Logger LOG = LoggerFactory.getLogger(PortalURLParserImpl.class);
    private static final boolean isDebug = LOG.isDebugEnabled();
    private static final boolean isTrace = LOG.isTraceEnabled();
    private static final PortalURLParser PARSER = new PortalURLParserImpl();
    private static final String PREFIX = "__";
    private static final String PORTLET_ID = "pd";
    private static final String RESOURCE_ID = "ri";
    private static final String CACHE_LEVEL = "cl";
    private static final String RENDER_PARAM = "rp";
    private static final String PUBLIC_RENDER_PARAM = "sp";
    private static final String WINDOW_STATE = "ws";
    private static final String PORTLET_MODE = "pm";
    private static final String[][] ENCODINGS = new String[][]{{"/", "0x3"}};
    private static final String VALUE_DELIM = ":";
    private static final String VALUE_NULL = ",";
    private static final String VALUE_ARRAY_EMPTY = "@";
    private static final String DELIM = ";";
    private static final String TOKEN_DELIM = "/";
    private static final String ACTION = "ac";
    private static final String RESOURCE = "rs";
    private static final String AJAX_ACTION = "aa";
    private static final String PARTIAL_ACTION = "pa";
    private static final String RENDER = "re";
    private static final String AUTHENTICATE = "au";
    private static final String ACTION_PARAM = "av";
    private static final String RESOURCE_PARAM = "rv";

    private PortalURLParserImpl() {
    }

    public static PortalURLParser getParser() {
        return PARSER;
    }

    public PortalURL parse(HttpServletRequest request) {
        int ind;
        String reqURI = request.getRequestURI();
        String contextPath = request.getContextPath();
        String servletName = request.getServletPath();
        if (isDebug) {
            LOG.debug("Parsing. Context Path: " + contextPath + ", Servlet Name: " + servletName + ", Request URI: " + reqURI);
        }
        String urlBase = request.getScheme() + "://" + request.getServerName() + VALUE_DELIM + request.getServerPort();
        RelativePortalURLImpl portalURL = new RelativePortalURLImpl(urlBase, contextPath, servletName, this, request);
        String pathInfo = request.getPathInfo();
        if (pathInfo == null && servletName.contains(".jsp") && !servletName.endsWith(".jsp")) {
            int idx = servletName.indexOf(".jsp") + ".jsp".length();
            pathInfo = servletName.substring(idx);
            servletName = servletName.substring(0, idx);
            portalURL = new RelativePortalURLImpl(urlBase, contextPath, servletName, this, request);
            if (isDebug) {
                LOG.debug("Constructed new URL due to JSP processing. pathInfo: " + pathInfo);
            }
        }
        String prefix = contextPath + servletName;
        int qi = reqURI.indexOf("?");
        qi = qi < 0 ? reqURI.length() : qi;
        pathInfo = reqURI.substring(prefix.length(), qi);
        if (isTrace) {
            LOG.debug("Parsing request pathInfo: " + pathInfo);
        }
        StringBuilder renderPath = new StringBuilder();
        if (pathInfo.length() > 0 && pathInfo.charAt(0) != '/') {
            renderPath.append('/');
        }
        if ((ind = pathInfo.indexOf("/__")) < 0) {
            renderPath.append(this.urlDecode(pathInfo));
            pathInfo = "";
        } else {
            renderPath.append(this.urlDecode(pathInfo.substring(0, ind)));
            pathInfo = pathInfo.substring(ind);
        }
        portalURL.setRenderPath(renderPath.toString());
        if (isTrace) {
            LOG.debug("Parse: renderPath: " + renderPath.toString() + ",  pathInfo: " + pathInfo);
        }
        ServletContext sc = request.getServletContext();
        DriverConfiguration dc = (DriverConfiguration)sc.getAttribute("driverConfig");
        String rp = renderPath.length() > 0 ? renderPath.toString() : null;
        PublicRenderParameterMapper prpm = dc.getPublicRenderParameterService().getPRPMapper(rp);
        portalURL.setPublicRenderParameterMapper(prpm);
        Collection pids = dc.getPageConfig(rp).getPortletIds();
        portalURL.setPortletIds(pids);
        StringBuilder vstr = new StringBuilder();
        if (isTrace) {
            vstr.append("Portlet Versions: ");
        }
        for (String pid : pids) {
            String appName = PortletWindowConfig.fromId((String)pid).getContextPath();
            try {
                String pv = dc.getPortletRegistryService().getPortletApplication(appName).getVersion();
                portalURL.setVersion(pid, pv);
                if (!isTrace) continue;
                vstr.append(pid).append(" = ").append(pv).append(", ");
            }
            catch (Exception e) {
                LOG.error("Portlet application definition could not be retrieved for " + appName);
            }
        }
        if (isTrace) {
            LOG.debug(vstr.toString());
        }
        ArrayList<String> portletIds = new ArrayList<String>();
        if (pathInfo.length() > 2) {
            String[] tokens;
            for (String t : tokens = pathInfo.split("/__")) {
                if (t.length() < 3) continue;
                String type = t.substring(0, 2);
                String val = t.substring(2);
                String[] vals = val.split(DELIM);
                int index = -1;
                String pid = null;
                if (vals[0].length() > 0 && vals[0].matches("\\d+")) {
                    try {
                        index = Integer.parseInt(vals[0]);
                        if (index >= 0 && index < portletIds.size()) {
                            pid = (String)portletIds.get(index);
                        }
                    }
                    catch (Exception e) {
                        LOG.error("error parsing URL pid reference token. Token: " + vals[0] + ", exception: " + e.toString());
                    }
                }
                if (type.equals(PORTLET_ID)) {
                    portletIds.add(Integer.parseInt(vals[1]), this.urlDecode(vals[0]));
                    continue;
                }
                if (type.equals(CACHE_LEVEL)) {
                    portalURL.setCacheability(this.urlDecode(vals[0]));
                    continue;
                }
                if (type.equals(RESOURCE_ID)) {
                    portalURL.setResourceID(this.urlDecode(vals[0]));
                    continue;
                }
                if (type.equals(AUTHENTICATE)) {
                    portalURL.setAuthenticated(Boolean.valueOf(this.urlDecode(vals[0])));
                    continue;
                }
                if (type.equals(RESOURCE)) {
                    portalURL.setTargetWindow(pid);
                    portalURL.setType(PortalURL.URLType.Resource);
                    continue;
                }
                if (type.equals(RENDER)) {
                    portalURL.setTargetWindow(pid);
                    portalURL.setType(PortalURL.URLType.Render);
                    continue;
                }
                if (type.equals(ACTION)) {
                    portalURL.setTargetWindow(pid);
                    portalURL.setType(PortalURL.URLType.Action);
                    continue;
                }
                if (type.equals(AJAX_ACTION)) {
                    portalURL.setTargetWindow(pid);
                    portalURL.setType(PortalURL.URLType.AjaxAction);
                    continue;
                }
                if (type.equals(PARTIAL_ACTION)) {
                    portalURL.setTargetWindow(pid);
                    portalURL.setType(PortalURL.URLType.PartialAction);
                    continue;
                }
                if (type.equals(WINDOW_STATE)) {
                    portalURL.setWindowState(pid, new WindowState(this.urlDecode(vals[1])));
                    continue;
                }
                if (type.equals(PORTLET_MODE)) {
                    portalURL.setPortletMode(pid, new PortletMode(this.urlDecode(vals[1])));
                    continue;
                }
                StringBuilder dbgstr = new StringBuilder();
                if (isTrace) {
                    dbgstr.append("Decoding parameter: window ID=").append(pid).append(", name/value=").append(vals[1]);
                }
                String values = vals[1];
                if (type.equals(PUBLIC_RENDER_PARAM)) {
                    if (vals.length != 3) {
                        LOG.warn("Bad PRP Token: " + val);
                    } else {
                        values = vals[2];
                    }
                }
                String[] pVals = values.split(VALUE_DELIM, -1);
                Object[] paramValues = new String[]{};
                String paramName = "";
                boolean isEmptyArray = false;
                if (pVals.length > 1) {
                    if (pVals.length == 2 && pVals[1].equals(VALUE_ARRAY_EMPTY)) {
                        isEmptyArray = true;
                    }
                    for (int i = 0; i < pVals.length; ++i) {
                        pVals[i] = pVals[i].equals(VALUE_NULL) ? null : this.urlDecode(pVals[i]);
                    }
                }
                if (pVals.length == 0 || pVals[0] == null) {
                    LOG.warn("Bad parameter token: " + values);
                } else {
                    paramName = pVals[0];
                    paramValues = isEmptyArray ? new String[]{} : Arrays.copyOfRange(pVals, 1, pVals.length);
                }
                if (isTrace) {
                    dbgstr.append(", paramName=").append(paramName);
                    dbgstr.append(", Values length=").append(paramValues.length);
                    dbgstr.append(", paramValues=").append(Arrays.toString(paramValues));
                    LOG.debug(dbgstr.toString());
                }
                if (type.equals(RENDER_PARAM)) {
                    portalURL.addParameter(new PortalURLParameter(pid, paramName, (String[])paramValues));
                    continue;
                }
                if (type.equals(ACTION_PARAM)) {
                    portalURL.addParameter(new PortalURLParameter(pid, paramName, (String[])paramValues, "ap"));
                    continue;
                }
                if (type.equals(RESOURCE_PARAM)) {
                    portalURL.addParameter(new PortalURLParameter(pid, paramName, (String[])paramValues, RENDER));
                    continue;
                }
                if (!type.equals(PUBLIC_RENDER_PARAM)) continue;
                PublicRenderParameterMapper mapper = portalURL.getPublicRenderParameterMapper();
                int prpGroup = mapper.getIndex(pid, paramName);
                if (prpGroup >= 0) {
                    mapper.setValues(prpGroup, (String[])paramValues);
                    continue;
                }
                StringBuilder sb = new StringBuilder("Could not find public render parameter group for portlet ID=");
                sb.append(pid).append(", parameter name=").append(paramName);
                LOG.warn(sb.toString());
            }
        }
        if (portalURL.getType() == PortalURL.URLType.Render || portalURL.getType() == PortalURL.URLType.Portal) {
            portalURL.handleServletRequestParams();
        }
        if (isTrace) {
            LOG.debug("Found " + portletIds.size() + " IDs: " + Arrays.toString(portletIds.toArray()));
        }
        return portalURL;
    }

    public String toString(RelativePortalURLImpl portalURL) {
        String frag;
        StringBuilder txt;
        int index;
        StringBuilder txt2;
        StringBuilder buffer = new StringBuilder();
        String targetWindow = portalURL.getTargetWindow();
        portalURL.handleServletRequestParams();
        buffer.append(portalURL.getServletPath().startsWith(TOKEN_DELIM) ? "" : TOKEN_DELIM).append(portalURL.getServletPath());
        if (portalURL.getRenderPath() != null) {
            String p = portalURL.getRenderPath().replaceAll(" ", "%20");
            buffer.append(p);
        }
        ArrayList<String> pids = new ArrayList<String>();
        for (String pid : portalURL.getPortletIds()) {
            pids.add(pid);
            buffer.append(TOKEN_DELIM).append(PREFIX).append(PORTLET_ID);
            try {
                buffer.append(URLEncoder.encode(pid, "UTF-8"));
            }
            catch (Exception e) {
                LOG.warn("Could not encode pid=" + pid);
            }
            buffer.append(DELIM).append(String.valueOf(pids.indexOf(pid)));
        }
        if (portalURL.getType() == PortalURL.URLType.Resource) {
            int index2 = pids.indexOf(targetWindow);
            if (index2 < 0) {
                txt2 = new StringBuilder();
                txt2.append("Resource Window not found in portlet ID list. PID = ").append(targetWindow).append(", Portlet IDs in map: ").append(Arrays.toString(pids.toArray()));
                LOG.warn(txt2.toString());
            } else {
                buffer.append(TOKEN_DELIM);
                buffer.append(PREFIX).append(RESOURCE).append(String.valueOf(index2));
            }
        }
        if (portalURL.getType() == PortalURL.URLType.Render) {
            int index3 = pids.indexOf(targetWindow);
            if (index3 < 0) {
                txt2 = new StringBuilder();
                txt2.append("Render Window not found in portlet ID list. PID = ").append(targetWindow).append(", Portlet IDs in map: ").append(Arrays.toString(pids.toArray()));
                LOG.warn(txt2.toString());
            } else {
                buffer.append(TOKEN_DELIM);
                buffer.append(PREFIX).append(RENDER).append(String.valueOf(index3));
            }
        }
        if (portalURL.getType() == PortalURL.URLType.Action) {
            int index4 = pids.indexOf(targetWindow);
            if (index4 < 0) {
                txt2 = new StringBuilder();
                txt2.append("Action Window not found in portlet ID list. PID = ").append(targetWindow).append(", Portlet IDs in map: ").append(Arrays.toString(pids.toArray()));
                LOG.warn(txt2.toString());
            } else {
                buffer.append(TOKEN_DELIM);
                buffer.append(PREFIX).append(ACTION).append(String.valueOf(index4));
            }
        }
        if (portalURL.getAuthenticated()) {
            buffer.append(TOKEN_DELIM);
            buffer.append(PREFIX).append(AUTHENTICATE).append(this.urlEncode(String.valueOf(portalURL.getAuthenticated())));
        }
        String reswin = null;
        boolean isCacheabilityFull = false;
        if (portalURL.getType() == PortalURL.URLType.Resource) {
            if (portalURL.getCacheability() != null) {
                buffer.append(TOKEN_DELIM);
                buffer.append(PREFIX).append(CACHE_LEVEL).append(this.urlEncode(portalURL.getCacheability()));
            }
            if (portalURL.getResourceID() != null) {
                buffer.append(TOKEN_DELIM);
                buffer.append(PREFIX).append(RESOURCE_ID).append(this.urlEncode(portalURL.getResourceID()));
            }
            if (portalURL.getCacheability().equals("cacheLevelFull")) {
                isCacheabilityFull = true;
                reswin = portalURL.getTargetWindow();
            } else if (portalURL.getCacheability().equals("cacheLevelPortlet")) {
                reswin = portalURL.getTargetWindow();
            }
        }
        for (String pid : portalURL.getPortletModes().keySet()) {
            if (isCacheabilityFull || reswin != null && !reswin.equals(pid)) continue;
            index = pids.indexOf(pid);
            PortletMode pm = portalURL.getPortletMode(pid);
            if (index < 0) {
                txt = new StringBuilder("Window not found in portlet ID list. PID = ");
                txt.append(pid).append(", PM = ").append(pm.toString()).append(", Portlet IDs in map: ").append(Arrays.toString(pids.toArray()));
                LOG.warn(txt.toString());
                continue;
            }
            buffer.append(TOKEN_DELIM).append(PREFIX).append(PORTLET_MODE).append(String.valueOf(index)).append(DELIM).append(this.urlEncode(pm.toString()));
        }
        for (String pid : portalURL.getWindowStates().keySet()) {
            if (isCacheabilityFull || reswin != null && !reswin.equals(pid)) continue;
            index = pids.indexOf(pid);
            WindowState ws = portalURL.getWindowState(pid);
            if (index < 0) {
                txt = new StringBuilder("Window not found in portlet ID list. PID = ");
                txt.append(pid).append(", WS = ").append(ws.toString()).append(", Portlet IDs in map: ").append(Arrays.toString(pids.toArray()));
                LOG.warn(txt.toString());
                continue;
            }
            buffer.append(TOKEN_DELIM).append(PREFIX).append(WINDOW_STATE).append(String.valueOf(index)).append(DELIM).append(this.urlEncode(ws.toString()));
        }
        for (PortalURLParameter param : portalURL.getParameters()) {
            if (reswin != null && !reswin.equals(param.getWindowId())) continue;
            index = pids.indexOf(param.getWindowId());
            if (index < 0) {
                LOG.warn("Window not found in portlet ID list. PID = " + param.getWindowId() + ", Param name = " + param.getName());
                continue;
            }
            if (param.getName() == null || param.getValues() == null) continue;
            String valueString = this.encodeMultiValues(param.getValues());
            String ptype = RENDER_PARAM;
            if (param.getType().equals("ap")) {
                ptype = ACTION_PARAM;
            } else if (param.getType().equals(RENDER)) {
                ptype = RESOURCE_PARAM;
            }
            if (isCacheabilityFull && !ptype.equals(RESOURCE_PARAM)) continue;
            buffer.append(TOKEN_DELIM).append(PREFIX).append(ptype).append(String.valueOf(index)).append(DELIM).append(this.urlEncode(param.getName())).append(VALUE_DELIM).append(valueString);
        }
        if (!isCacheabilityFull) {
            PublicRenderParameterMapper mapper = portalURL.getPublicRenderParameterMapper();
            ArrayList<Integer> activeIndexes = mapper.getActiveIndexes();
            if (reswin != null) {
                List pups = mapper.getPRPsForWindow(reswin, true);
                activeIndexes = new ArrayList<Integer>();
                for (PortalURLPublicParameter pup : pups) {
                    activeIndexes.add(mapper.getIndex(pup));
                }
            }
            Iterator i$ = activeIndexes.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                String[] values = mapper.getValues(i);
                String valstr = this.encodeMultiValues(values);
                List prplist = mapper.getPublicParameterGroup(i);
                if (prplist.size() <= 0) continue;
                PortalURLPublicParameter prp = (PortalURLPublicParameter)prplist.get(0);
                int index5 = pids.indexOf(prp.getWindowId());
                if (index5 >= 0) {
                    buffer.append(TOKEN_DELIM).append(PREFIX).append(PUBLIC_RENDER_PARAM).append(String.valueOf(index5)).append(DELIM).append(String.valueOf(i)).append(DELIM).append(this.urlEncode(prp.getName())).append(VALUE_DELIM).append(valstr);
                    continue;
                }
                LOG.warn("window ID not on page for public render parameter: " + prp.toString());
            }
        }
        if (portalURL.getType() == PortalURL.URLType.Render && (frag = portalURL.getFragmentIdentifier()) != null) {
            if (isTrace) {
                LOG.debug("Adding fragment identifier: " + frag);
            }
            buffer.append('#').append(frag);
        }
        return buffer.toString();
    }

    private String urlEncode(String str) {
        String out = str;
        if (str != null) {
            try {
                for (int i = 0; i < ENCODINGS.length; ++i) {
                    out = out.replace(ENCODINGS[i][0], ENCODINGS[i][1]);
                }
                out = URLEncoder.encode(out, "UTF-8");
            }
            catch (Exception e) {
                LOG.warn("Error URL encoding string: " + str);
            }
        }
        return out;
    }

    private String urlDecode(String str) {
        String out = str;
        if (str != null) {
            try {
                for (int i = 0; i < ENCODINGS.length; ++i) {
                    out = out.replace(ENCODINGS[i][1], ENCODINGS[i][0]);
                }
                out = URLDecoder.decode(out, "UTF-8");
            }
            catch (Exception e) {
                LOG.warn("Error URL decoding string: " + str);
            }
        }
        return out;
    }

    private String encodeMultiValues(String[] values) {
        StringBuilder buffer = new StringBuilder();
        if (values.length == 0) {
            buffer.append(VALUE_ARRAY_EMPTY);
        } else {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null) {
                    buffer.append(VALUE_NULL);
                } else {
                    buffer.append(this.urlEncode(values[i]));
                }
                if (i + 1 >= values.length) continue;
                buffer.append(VALUE_DELIM);
            }
        }
        return buffer.toString();
    }

    public String toString(PortalURL portalURL) {
        return this.toString((RelativePortalURLImpl)portalURL);
    }
}

