/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.url.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.pluto.container.PortletRequestContext;
import org.apache.pluto.driver.config.DriverConfiguration;
import org.apache.pluto.driver.services.portal.PageConfig;
import org.apache.pluto.driver.services.portal.PublicRenderParameterMapper;
import org.apache.pluto.driver.url.PortalURL;
import org.apache.pluto.driver.url.PortalURLParameter;
import org.apache.pluto.driver.url.PortalURLParser;
import org.apache.pluto.driver.url.PortalURLPublicParameter;
import org.apache.pluto.driver.url.PortletParameterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelativePortalURLImpl
implements PortalURL {
    private static final Logger LOG = LoggerFactory.getLogger(RelativePortalURLImpl.class);
    private static final boolean isDebug = LOG.isDebugEnabled();
    private static final boolean isTrace = LOG.isTraceEnabled();
    private String urlBase;
    private String servletPath;
    private String renderPath;
    private String cacheLevel;
    private String resourceID;
    private String fragmentId = null;
    private boolean isAuthenticated = false;
    private int cloneId = 0;
    private static int cloneCtr = 0;
    private PublicRenderParameterMapper prpMapper = null;
    private HashSet<String> portletIds = new HashSet();
    private HashMap<String, String> versionMap = new HashMap();
    private HashMap<String, Boolean> v3Map = new HashMap();
    private PortalURLParser urlParser;
    HttpServletRequest servletRequest;
    boolean reqParamsProcessed = false;
    private Map<String, WindowState> windowStates = new HashMap<String, WindowState>();
    private Map<String, PortletMode> portletModes = new HashMap<String, PortletMode>();
    private HashSet<PortalURLParameter> parameters = new HashSet();
    PortalURL.URLType type = PortalURL.URLType.Portal;
    String targetWindow = null;

    public RelativePortalURLImpl(String urlBase, String contextPath, String servletName, PortalURLParser urlParser, HttpServletRequest req) {
        this.urlBase = urlBase;
        StringBuffer buffer = new StringBuffer();
        buffer.append(contextPath);
        buffer.append(servletName);
        this.servletPath = buffer.toString();
        this.urlParser = urlParser;
        this.servletRequest = req;
        this.cloneId = ++cloneCtr + 10000;
        if (isDebug) {
            LOG.debug("Constructed URL, clone ID: " + this.cloneId);
        }
    }

    private RelativePortalURLImpl() {
    }

    protected void handleServletRequestParams() {
        if (!this.reqParamsProcessed && this.servletRequest != null && this.targetWindow != null && this.type != PortalURL.URLType.Portal) {
            this.reqParamsProcessed = true;
            if (isTrace) {
                LOG.debug("Processing servlet request parameters.");
            }
            try {
                this.servletRequest.setCharacterEncoding("UTF-8");
            }
            catch (Exception e) {
                // empty catch block
            }
            Map parms = this.servletRequest.getParameterMap();
            if (!parms.isEmpty()) {
                String ptype = "rp";
                if (this.type == PortalURL.URLType.Action || this.type == PortalURL.URLType.AjaxAction || this.type == PortalURL.URLType.PartialAction) {
                    ptype = "ap";
                } else if (this.type == PortalURL.URLType.Resource) {
                    ptype = "re";
                }
                for (String parm : parms.keySet()) {
                    StringBuilder txt;
                    int index;
                    if (this.type == PortalURL.URLType.Render && this.targetWindow != null && (index = this.prpMapper.getIndex(this.targetWindow, parm)) >= 0) {
                        this.prpMapper.setValues(index, (String[])parms.get(parm));
                        if (!isTrace) continue;
                        txt = new StringBuilder("Added public parameter: ");
                        txt.append(parm).append(", Values: ").append(Arrays.toString((Object[])parms.get(parm)));
                        txt.append(", Clone ID: " + this.cloneId);
                        LOG.debug(txt.toString());
                        continue;
                    }
                    PortalURLParameter pup = new PortalURLParameter(this.targetWindow, parm, (String[])parms.get(parm), ptype);
                    if (this.parameters.contains(pup)) {
                        this.parameters.remove(pup);
                    }
                    this.parameters.add(pup);
                    if (!isTrace) continue;
                    txt = new StringBuilder("Added private parameter: ");
                    txt.append(parm).append(", Values: ").append(Arrays.toString((Object[])parms.get(parm)));
                    txt.append(", Type: ").append(ptype);
                    txt.append(", Clone ID: " + this.cloneId);
                    LOG.debug(txt.toString());
                }
            }
        }
    }

    public void setRenderPath(String renderPath) {
        this.renderPath = renderPath;
    }

    public String getRenderPath() {
        return this.renderPath;
    }

    public Collection<PortalURLParameter> getParameters() {
        this.handleServletRequestParams();
        return this.parameters;
    }

    public Map<String, PortletMode> getPortletModes() {
        return Collections.unmodifiableMap(this.portletModes);
    }

    public PortletMode getPortletMode(String windowId) {
        PortletMode mode = this.portletModes.get(windowId);
        if (mode == null) {
            mode = PortletMode.VIEW;
        }
        return mode;
    }

    public void setPortletMode(String windowId, PortletMode portletMode) {
        this.portletModes.put(windowId, portletMode);
    }

    public Map<String, WindowState> getWindowStates() {
        return Collections.unmodifiableMap(this.windowStates);
    }

    public WindowState getWindowState(String windowId) {
        WindowState state = this.windowStates.get(windowId);
        if (state == null) {
            state = WindowState.NORMAL;
        }
        return state;
    }

    public void setWindowState(String windowId, WindowState windowState) {
        this.windowStates.put(windowId, windowState);
    }

    public void setCacheability(String cacheLevel) {
        this.cacheLevel = cacheLevel;
    }

    public String getCacheability() {
        return this.cacheLevel;
    }

    public void setResourceID(String resourceID) {
        this.resourceID = resourceID;
    }

    public String getResourceID() {
        return this.resourceID;
    }

    public String toString() {
        return this.toURL(false);
    }

    public String toURL(boolean absolute) {
        String result = this.urlParser.toString((PortalURL)this);
        if (absolute) {
            return this.urlBase + result;
        }
        if (isTrace) {
            StringBuilder txt = new StringBuilder();
            txt.append("Clone ID: ").append(this.cloneId).append(", absolute: ").append(absolute).append(", URL: ").append(result);
            LOG.debug(txt.toString());
        }
        return result;
    }

    @Deprecated
    public String getServerURI() {
        return null;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public synchronized PortalURL clone() {
        RelativePortalURLImpl portalURL = new RelativePortalURLImpl();
        portalURL.urlBase = this.urlBase;
        portalURL.servletPath = this.servletPath;
        portalURL.renderPath = this.renderPath;
        portalURL.cacheLevel = this.cacheLevel;
        portalURL.resourceID = this.resourceID;
        portalURL.prpMapper = this.prpMapper == null ? null : this.prpMapper.clone();
        portalURL.portletIds = new HashSet<String>(this.portletIds);
        portalURL.versionMap = new HashMap<String, String>(this.versionMap);
        portalURL.v3Map = new HashMap<String, Boolean>(this.v3Map);
        portalURL.urlParser = this.urlParser;
        portalURL.servletRequest = this.servletRequest;
        portalURL.reqParamsProcessed = this.reqParamsProcessed;
        portalURL.windowStates = new HashMap<String, WindowState>(this.windowStates);
        portalURL.portletModes = new HashMap<String, PortletMode>(this.portletModes);
        for (PortalURLParameter p : this.parameters) {
            portalURL.parameters.add(p.clone());
        }
        portalURL.type = this.type;
        portalURL.targetWindow = this.targetWindow;
        portalURL.cloneId = ++cloneCtr;
        if (isTrace) {
            long tid = Thread.currentThread().getId();
            StringBuilder txt = new StringBuilder();
            txt.append("Created clone ID= ").append(portalURL.cloneId);
            txt.append(" from URL with clone ID= ").append(this.cloneId);
            txt.append(". ThreadId=").append(tid);
            LOG.debug(txt.toString());
        }
        return portalURL;
    }

    public PageConfig getPageConfig(ServletContext servletContext) {
        String requestedPageId = this.getRenderPath();
        if (isTrace) {
            LOG.debug("Requested Page: " + requestedPageId);
        }
        DriverConfiguration dc = (DriverConfiguration)servletContext.getAttribute("driverConfig");
        PageConfig paco = dc.getPageConfig(requestedPageId);
        if (this.prpMapper == null && requestedPageId == null && paco != null) {
            this.prpMapper = dc.getPublicRenderParameterService().getPRPMapper(paco.getName());
        }
        return paco;
    }

    public void setPortletIds(Collection<String> portletIds) {
        this.portletIds.addAll(portletIds);
        if (isTrace) {
            LOG.debug("Stored " + this.portletIds.size() + " IDs: " + Arrays.toString(this.portletIds.toArray()));
        }
    }

    public Collection<String> getPortletIds() {
        return this.portletIds;
    }

    public void setVersion(String portletId, String version) {
        this.versionMap.put(portletId, version);
        this.v3Map.put(portletId, version.equals("3.0"));
    }

    public String getVersion(String portletId) {
        return this.versionMap.get(portletId);
    }

    public boolean isVersion3(String portletId) {
        return this.v3Map.get(portletId);
    }

    public void setType(PortalURL.URLType type) {
        ArrayList<PortalURLParameter> promotes = new ArrayList<PortalURLParameter>();
        if (type.equals((Object)PortalURL.URLType.Resource)) {
            for (PortalURLParameter pup : this.parameters) {
                if (!pup.isPersistent()) continue;
                promotes.add(pup);
            }
        }
        for (PortalURLParameter pup : promotes) {
            this.parameters.remove(pup);
            pup.setType("re");
            this.parameters.add(pup);
        }
        if (isTrace) {
            long tid = Thread.currentThread().getId();
            StringBuilder txt = new StringBuilder();
            txt.append("old type= ").append(this.type);
            txt.append(", new type= ").append(type);
            txt.append(", clone ID= ").append(this.cloneId);
            txt.append(", ThreadId=").append(tid);
            txt.append(", promoted params:");
            for (PortalURLParameter pup : promotes) {
                txt.append("\n   ").append(pup.toString());
            }
            LOG.debug(txt.toString());
        }
        this.type = type;
    }

    public PortalURL.URLType getType() {
        if (isTrace) {
            long tid = Thread.currentThread().getId();
            StringBuilder txt = new StringBuilder();
            txt.append("type= ").append(this.type);
            txt.append(", clone ID= ").append(this.cloneId);
            txt.append(". ThreadId=").append(tid);
            LOG.debug(txt.toString());
        }
        return this.type;
    }

    public void setTargetWindow(String windowId) {
        this.targetWindow = windowId;
    }

    public String getTargetWindow() {
        return this.targetWindow;
    }

    public void clearParameters(String window, String paramType) {
        int removed = 0;
        if (paramType.equals("sp")) {
            for (PortalURLPublicParameter prp : this.prpMapper.getPRPsForWindow(window, true)) {
                this.prpMapper.setRemoved(this.prpMapper.getIndex(prp), true);
                ++removed;
            }
        } else {
            HashSet<PortalURLParameter> rem = new HashSet<PortalURLParameter>();
            for (PortalURLParameter pup : this.parameters) {
                if (!pup.getType().equals(paramType) || !pup.getWindowId().equals(window) || pup.isPersistent()) continue;
                rem.add(pup);
            }
            removed = rem.size();
            this.parameters.removeAll(rem);
            if (isTrace) {
                StringBuilder txt = new StringBuilder(128);
                txt.append("Cleared private parameters:");
                for (PortalURLParameter pup : rem) {
                    txt.append("\n   ").append(pup.toString());
                }
                LOG.debug(txt.toString());
            }
        }
        if (isTrace) {
            StringBuilder txt = new StringBuilder("Removing ");
            txt.append(removed).append(" elements. Window ID: ").append(window);
            txt.append(", Parameter type: ").append(paramType);
            LOG.debug(txt.toString());
        }
    }

    protected void addParameter(PortalURLParameter param) {
        if (isTrace) {
            StringBuilder txt = new StringBuilder("Adding private parameter: ");
            txt.append(" window ID: " + param.getWindowId());
            txt.append(", Name: " + param.getName());
            String vals = param.getValues() == null ? "null" : Arrays.toString(param.getValues());
            txt.append(", Values: " + vals);
            txt.append(", Type: " + param.getType());
            txt.append(", Clone ID: " + this.cloneId);
            LOG.debug(txt.toString());
        }
        if (this.parameters.contains(param)) {
            this.parameters.remove(param);
        }
        this.parameters.add(param);
    }

    public void setParameter(PortalURLParameter param) {
        this.handleServletRequestParams();
        if (isTrace) {
            StringBuilder txt = new StringBuilder("Setting private parameter: ");
            txt.append(" window ID: " + param.getWindowId());
            txt.append(", Name: " + param.getName());
            String vals = param.getValues() == null ? "null" : Arrays.toString(param.getValues());
            txt.append(", Values: " + vals);
            txt.append(", Type: " + param.getType());
            txt.append(", Clone ID: " + this.cloneId);
            LOG.debug(txt.toString());
        }
        if (this.parameters.contains(param)) {
            this.parameters.remove(param);
        }
        this.parameters.add(param);
    }

    public PortletParameterFactory getPortletParameterFactory(PortletRequestContext reqctx) {
        this.handleServletRequestParams();
        return new PortletParameterFactory((PortalURL)this, reqctx);
    }

    public void setPublicRenderParameterMapper(PublicRenderParameterMapper prpm) {
        this.prpMapper = prpm;
    }

    public PublicRenderParameterMapper getPublicRenderParameterMapper() {
        this.handleServletRequestParams();
        return this.prpMapper;
    }

    public void removeParameter(PortalURLParameter param) {
        this.handleServletRequestParams();
        if (isTrace) {
            StringBuilder txt = new StringBuilder();
            txt.append("Removing private render parameter: ");
            txt.append(param.toString());
            if (!this.parameters.contains(param)) {
                txt.append(", Not in parameter set!");
            }
            LOG.debug(txt.toString());
        }
        this.parameters.remove(param);
    }

    public String getFragmentIdentifier() {
        return this.fragmentId;
    }

    public void setFragmentIdentifier(String fragment) {
        this.fragmentId = fragment;
    }

    public boolean getAuthenticated() {
        return this.isAuthenticated;
    }

    public void setAuthenticated(boolean authenticated) {
        this.isAuthenticated = authenticated;
    }
}

