/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.container;

import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final Logger LOG = LoggerFactory.getLogger(Configuration.class);
    public static final ResourceBundle BUNDLE = ResourceBundle.getBundle("org.apache.pluto.driver.container.pluto-configuration");
    private static final String DESCRIPTOR_SERVICE = "org.apache.pluto.descriptors.services.PortletAppDescriptorService";
    private static final String CONTAINER_RUNTIME_OPTIONS = "org.apache.pluto.container.supportedContainerRuntimeOptions";
    private static final String PREVENT_UNECESSARY_CROSS_CONTEXT = "org.apache.pluto.PREVENT_UNECESSARY_CROSS_CONTEXT";
    private static final String BUFFER_SUPPORT = "org.apache.pluto.ALLOW_BUFFER";
    private static Boolean prevent;
    private static Boolean buffering;

    public static String getPortletAppDescriptorServiceImpl() {
        String impl = BUNDLE.getString(DESCRIPTOR_SERVICE);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using Descriptor Service Impl: " + impl);
        }
        return impl;
    }

    public static boolean isBufferingSupported() {
        if (buffering == null) {
            try {
                String buffer = BUNDLE.getString(BUFFER_SUPPORT);
                buffering = new Boolean(buffer);
            }
            catch (MissingResourceException mre) {
                buffering = Boolean.FALSE;
            }
        }
        return buffering;
    }

    public static List<String> getSupportedContainerRuntimeOptions() {
        String[] s;
        String options = BUNDLE.getString(CONTAINER_RUNTIME_OPTIONS);
        ArrayList<String> result = new ArrayList<String>();
        for (String string : s = options.split(",")) {
            result.add(string);
        }
        return result;
    }

    public static boolean preventUnecessaryCrossContext() {
        if (prevent == null) {
            try {
                String test = BUNDLE.getString(PREVENT_UNECESSARY_CROSS_CONTEXT);
                prevent = new Boolean(test);
            }
            catch (MissingResourceException mre) {
                LOG.warn(mre.getMessage());
                prevent = Boolean.FALSE;
            }
        }
        return prevent;
    }

    public static final String getPortletContainerName() {
        return BUNDLE.getString("pluto.container.name");
    }

    public static final String getPortletContainerVersion() {
        return BUNDLE.getString("pluto.container.version");
    }

    public static final int getMajorSpecificationVersion() {
        return Integer.parseInt(BUNDLE.getString("javax.portlet.version.major"));
    }

    public static final int getMinorSpecificationVersion() {
        return Integer.parseInt(BUNDLE.getString("javax.portlet.version.minor"));
    }

    public static final String getServerInfo() {
        StringBuffer sb = new StringBuffer(Configuration.getPortletContainerName()).append("/").append(Configuration.getPortletContainerVersion());
        return sb.toString();
    }
}

