/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.container;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.pluto.container.PortletAppDescriptorService;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.RequestDispatcherService;
import org.apache.pluto.container.driver.DriverPortletConfig;
import org.apache.pluto.container.driver.DriverPortletContext;
import org.apache.pluto.container.driver.PortletContextService;
import org.apache.pluto.container.driver.PortletRegistryEvent;
import org.apache.pluto.container.driver.PortletRegistryListener;
import org.apache.pluto.container.driver.PortletRegistryService;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.apache.pluto.container.util.ClasspathScanner;
import org.apache.pluto.driver.container.ApplicationIdResolver;
import org.apache.pluto.driver.container.Configuration;
import org.apache.pluto.driver.container.DriverPortletConfigImpl;
import org.apache.pluto.driver.container.DriverPortletContextImpl;
import org.apache.pluto.driver.container.PortletDescriptorRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletContextManager
implements PortletRegistryService,
PortletContextService {
    private static final Logger LOG = LoggerFactory.getLogger(PortletContextManager.class);
    private static final boolean isDebug = LOG.isDebugEnabled();
    private Map<String, DriverPortletContext> portletContexts = new HashMap<String, DriverPortletContext>();
    private static final List<ApplicationIdResolver> APP_ID_RESOLVERS = new ArrayList<ApplicationIdResolver>();
    private final Map<String, DriverPortletConfig> portletConfigs = new HashMap<String, DriverPortletConfig>();
    private final List<PortletRegistryListener> registryListeners = new ArrayList<PortletRegistryListener>();
    private final Map<String, ClassLoader> classLoaders = new HashMap<String, ClassLoader>();
    private final RequestDispatcherService rdService;
    private final PortletDescriptorRegistry portletRegistry;
    private static Method contextPathGetter;

    public PortletContextManager(RequestDispatcherService rdService, PortletAppDescriptorService portletAppDescriptorService) {
        this.rdService = rdService;
        this.portletRegistry = new PortletDescriptorRegistry(portletAppDescriptorService);
    }

    public String register(ServletConfig config) throws PortletContainerException {
        ServletContext servletContext = config.getServletContext();
        String contextPath = PortletContextManager.getContextPath(servletContext);
        if (!this.portletContexts.containsKey(contextPath)) {
            PortletApplicationDefinition portletApp = this.portletRegistry.getPortletAppDD(servletContext, contextPath, contextPath);
            if (isDebug) {
                StringBuilder txt = new StringBuilder(128);
                txt.append("Parsed DD for Portlet app: ").append(portletApp.getName());
                txt.append(", context path: ").append(portletApp.getContextPath());
                txt.append(", # portlets: ").append(portletApp.getPortlets().size());
                txt.append(", names: ");
                String sep = "";
                for (PortletDefinition pd : portletApp.getPortlets()) {
                    txt.append(sep).append(pd.getPortletName());
                    sep = ", ";
                }
                LOG.debug(txt.toString());
            }
            DriverPortletContextImpl portletContext = new DriverPortletContextImpl(servletContext, portletApp, this.rdService);
            this.portletContexts.put(contextPath, portletContext);
            this.fireRegistered(portletContext);
            if (LOG.isInfoEnabled()) {
                LOG.info("Registered portlet application for context '" + contextPath + "'");
                LOG.info("Registering " + portletApp.getPortlets().size() + " portlets for context /" + portletContext.getApplicationName());
            }
            this.classLoaders.put(portletApp.getName(), Thread.currentThread().getContextClassLoader());
            for (PortletDefinition portlet : portletApp.getPortlets()) {
                String appName = portletContext.getApplicationName();
                if (appName == null) {
                    throw new PortletContainerException("Portlet application name should not be null.");
                }
                this.portletConfigs.put(portletContext.getApplicationName() + "/" + portlet.getPortletName(), new DriverPortletConfigImpl((PortletContext)portletContext, portlet));
            }
        } else if (LOG.isInfoEnabled()) {
            LOG.info("Portlet application for context '" + contextPath + "' already registered.");
        }
        return contextPath;
    }

    public void unregister(DriverPortletContext context) {
        this.portletContexts.remove(context.getApplicationName());
        this.classLoaders.remove(context.getApplicationName());
        Iterator<String> configs = this.portletConfigs.keySet().iterator();
        while (configs.hasNext()) {
            String key = configs.next();
            if (!key.startsWith(context.getApplicationName() + "/")) continue;
            configs.remove();
        }
        this.fireRemoved(context);
    }

    public Iterator<String> getRegisteredPortletApplicationNames() {
        return new HashSet<String>(this.portletContexts.keySet()).iterator();
    }

    public Iterator<DriverPortletContext> getPortletContexts() {
        return new HashSet<DriverPortletContext>(this.portletContexts.values()).iterator();
    }

    public DriverPortletContext getPortletContext(String applicationName) {
        return this.portletContexts.get(applicationName);
    }

    public DriverPortletContext getPortletContext(PortletWindow portletWindow) throws PortletContainerException {
        return this.portletContexts.get(portletWindow.getPortletDefinition().getApplication().getName());
    }

    public DriverPortletConfig getPortletConfig(String applicationName, String portletName) throws PortletContainerException {
        DriverPortletConfig ipc = this.portletConfigs.get(applicationName + "/" + portletName);
        if (ipc != null) {
            return ipc;
        }
        String msg = "Unable to locate portlet config [applicationName=" + applicationName + "]/[" + portletName + "].";
        LOG.warn(msg);
        throw new PortletContainerException(msg);
    }

    public PortletDefinition getPortlet(String applicationName, String portletName) throws PortletContainerException {
        DriverPortletConfig ipc = this.portletConfigs.get(applicationName + "/" + portletName);
        if (ipc != null) {
            return ipc.getPortletDefinition();
        }
        String msg = "Unable to retrieve portlet: '" + applicationName + "/" + portletName + "'";
        LOG.warn(msg);
        throw new PortletContainerException(msg);
    }

    public PortletApplicationDefinition getPortletApplication(String applicationName) throws PortletContainerException {
        DriverPortletContext ipc = this.portletContexts.get(applicationName);
        if (ipc != null) {
            return ipc.getPortletApplicationDefinition();
        }
        String msg = "Unable to retrieve portlet application: '" + applicationName + "'";
        LOG.warn(msg);
        throw new PortletContainerException(msg);
    }

    public ClassLoader getClassLoader(String applicationName) {
        return this.classLoaders.get(applicationName);
    }

    public void addPortletRegistryListener(PortletRegistryListener listener) {
        this.registryListeners.add(listener);
    }

    public void removePortletRegistryListener(PortletRegistryListener listener) {
        this.registryListeners.remove(listener);
    }

    private void fireRegistered(DriverPortletContext context) {
        PortletRegistryEvent event = new PortletRegistryEvent();
        event.setPortletApplication(context.getPortletApplicationDefinition());
        for (PortletRegistryListener l : this.registryListeners) {
            l.portletApplicationRegistered(event);
        }
        LOG.info("Portlet Context '" + context.getApplicationName() + "' registered.");
    }

    private void fireRemoved(DriverPortletContext context) {
        PortletRegistryEvent event = new PortletRegistryEvent();
        event.setPortletApplication(context.getPortletApplicationDefinition());
        for (PortletRegistryListener l : this.registryListeners) {
            l.portletApplicationRemoved(event);
        }
        LOG.info("Portlet Context '" + context.getApplicationName() + "' removed.");
    }

    public static ServletContext getPortletContext(ServletContext portalContext, String portletContextPath) throws PortletContainerException {
        ServletContext portletAppCtx;
        String portalPath;
        if (Configuration.preventUnecessaryCrossContext() && (portalPath = PortletContextManager.getContextPath(portalContext)).equals(portletContextPath)) {
            return portalContext;
        }
        if ("".equals(portletContextPath)) {
            portletContextPath = "/";
        }
        if ((portletAppCtx = portalContext.getContext(portletContextPath)) == null) {
            String msg = "Unable to obtain the servlet context for the portlet app context path [" + portletContextPath + "]. Make " + "sure that the portlet app has been deployed and that cross " + "context support is enabled for the portal app.";
            throw new PortletContainerException(msg);
        }
        return portletAppCtx;
    }

    protected static String getContextPath(ServletContext context) {
        String contextPath = null;
        if (contextPathGetter != null) {
            try {
                contextPath = (String)contextPathGetter.invoke((Object)context, (Object[])null);
            }
            catch (Exception e) {
                LOG.warn("Unable to directly retrieve context path from ServletContext. Computing. . . ");
            }
        }
        if (contextPath == null) {
            contextPath = PortletContextManager.computeContextPath(context);
        }
        return contextPath;
    }

    protected static String computeContextPath(ServletContext context) {
        if (APP_ID_RESOLVERS.size() < 1) {
            List classes = null;
            try {
                classes = ClasspathScanner.findConfiguredImplementations(ApplicationIdResolver.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to find any ApplicationIdResolvers");
            }
            for (Class c : classes) {
                try {
                    APP_ID_RESOLVERS.add((ApplicationIdResolver)c.newInstance());
                }
                catch (Exception e) {
                    LOG.warn("Unable to instantiate ApplicationIdResolver for class " + c.getName());
                }
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("Found " + APP_ID_RESOLVERS.size() + " application id resolvers.");
            }
        }
        String path = null;
        int authority = Integer.MAX_VALUE;
        for (ApplicationIdResolver resolver : APP_ID_RESOLVERS) {
            if (resolver.getAuthority() >= authority && path != null) continue;
            authority = resolver.getAuthority();
            String temp = resolver.resolveApplicationId(context);
            if (temp == null) continue;
            path = temp;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resolved application id '" + path + "' with authority " + authority);
        }
        return path;
    }

    static {
        try {
            contextPathGetter = ServletContext.class.getMethod("getContextPath", null);
        }
        catch (NoSuchMethodException e) {
            LOG.warn("Servlet 2.4 or below detected.  Unable to find getContextPath on ServletContext.");
        }
    }
}

