/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.container;

import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.ServletContext;
import org.apache.pluto.container.PortletAppDescriptorService;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.container.om.portlet.impl.ConfigurationHolder;
import org.apache.pluto.container.util.StringManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletDescriptorRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(PortletDescriptorRegistry.class);
    private static final boolean isDebug = LOG.isDebugEnabled();
    private static final StringManager EXCEPTIONS = StringManager.getManager((String)PortletDescriptorRegistry.class.getPackage().getName());
    private final PortletAppDescriptorService portletDDService;
    private final Map<ServletContext, PortletApplicationDefinition> cache = new WeakHashMap<ServletContext, PortletApplicationDefinition>();

    PortletDescriptorRegistry(PortletAppDescriptorService portletDDService) {
        this.portletDDService = portletDDService;
    }

    public PortletApplicationDefinition getPortletAppDD(ServletContext servletContext, String name, String contextPath) throws PortletContainerException {
        PortletApplicationDefinition portletApp = this.cache.get(servletContext);
        if (portletApp == null) {
            portletApp = this.createDefinition(servletContext, name, contextPath);
            this.cache.put(servletContext, portletApp);
        }
        return portletApp;
    }

    private PortletApplicationDefinition createDefinition(ServletContext servletContext, String name, String contextPath) throws PortletContainerException {
        PortletApplicationDefinition portletApp = null;
        ConfigurationHolder holder = (ConfigurationHolder)servletContext.getAttribute("PortletAppConfig");
        if (holder != null) {
            if (isDebug) {
                LOG.debug("Registering config initializer. ctx path: " + contextPath);
            }
        } else {
            throw new PortletContainerException(EXCEPTIONS.getString("error.context.descriptor.load", (Object[])new String[]{servletContext.getServletContextName(), "No config data stored in context."}));
        }
        portletApp = holder.getPad();
        portletApp.setContextPath(contextPath);
        portletApp.setName(name);
        return portletApp;
    }
}

