/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.container;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.apache.pluto.container.om.portlet.PortletInfo;
import org.apache.pluto.container.util.StringManager;
import org.apache.pluto.driver.container.CombinedPortletResourceBundle;
import org.apache.pluto.driver.container.InlinePortletResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResourceBundleFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceBundleFactory.class);
    private static final StringManager EXCEPTIONS = StringManager.getManager((String)ResourceBundleFactory.class.getPackage().getName());
    private InlinePortletResourceBundle defaultBundle;
    private Map<Locale, ResourceBundle> bundles = new HashMap<Locale, ResourceBundle>();
    private String bundleName;

    public ResourceBundleFactory(PortletDefinition dd, PortletInfo windowInfo) {
        this.bundleName = dd.getResourceBundle();
        PortletInfo info = dd.getPortletInfo();
        String defaultTitle = "[ " + dd.getPortletName() + " ]";
        if (info != null) {
            String keywords;
            String title = windowInfo == null ? info.getTitle() : windowInfo.getTitle();
            String shortTitle = windowInfo == null ? info.getShortTitle() : windowInfo.getShortTitle();
            String string = keywords = windowInfo == null ? info.getKeywords() : windowInfo.getKeywords();
            if (title == null) {
                title = defaultTitle;
            }
            if (shortTitle == null) {
                shortTitle = defaultTitle;
            }
            this.defaultBundle = new InlinePortletResourceBundle(title, shortTitle, keywords);
        } else {
            this.defaultBundle = new InlinePortletResourceBundle(defaultTitle, defaultTitle, "");
        }
        if (LOG.isDebugEnabled()) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("Bundle name: ").append(this.bundleName);
            txt.append(", default ").append(this.defaultBundle.toString());
            LOG.debug(txt.toString());
        }
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resource Bundle: " + this.bundleName + " : " + locale + " requested. ");
        }
        if (this.bundles.containsKey(locale)) {
            return this.bundles.get(locale);
        }
        try {
            ResourceBundle bundle = null;
            if (this.bundleName != null && this.bundleName.length() > 0) {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                bundle = ResourceBundle.getBundle(this.bundleName, locale, loader);
                this.bundles.put(locale, new CombinedPortletResourceBundle(this.defaultBundle, bundle));
            } else {
                this.bundles.put(locale, this.defaultBundle);
            }
        }
        catch (MissingResourceException mre) {
            if (this.bundleName != null && LOG.isWarnEnabled()) {
                LOG.warn(EXCEPTIONS.getString("warning.resourcebundle.notfound", (Object)this.bundleName, (Object)mre.getMessage()));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using default bundle for locale (" + locale + ").");
            }
            this.bundles.put(locale, this.defaultBundle);
        }
        return this.bundles.get(locale);
    }
}

