/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.core;

import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.PortletWindowID;
import org.apache.pluto.container.driver.PlutoServices;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.apache.pluto.driver.core.PortletWindowIDImpl;
import org.apache.pluto.driver.services.portal.PortletWindowConfig;
import org.apache.pluto.driver.url.PortalURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletWindowImpl
implements PortletWindow {
    private static final Logger LOG = LoggerFactory.getLogger(PortletWindowImpl.class);
    private PortletWindowConfig config;
    private PortalURL portalURL;
    private PortletWindowIDImpl objectIdImpl;
    private PortletDefinition portlet;

    public PortletWindowImpl(PortletContainer container, PortletWindowConfig config, PortalURL portalURL) {
        this.config = config;
        this.portalURL = portalURL;
        try {
            String applicationName = config.getContextPath();
            this.portlet = PlutoServices.getServices().getPortletRegistryService().getPortlet(applicationName, config.getPortletName());
        }
        catch (PortletContainerException ex) {
            String message = "Unable to load Portlet App Deployment Descriptor:" + ex.getMessage();
            LOG.warn(message);
            throw new RuntimeException(message);
        }
    }

    public String getContextPath() {
        return this.config.getContextPath();
    }

    public String getPortletName() {
        return this.config.getPortletName();
    }

    public WindowState getWindowState() {
        return this.portalURL.getWindowState(this.getId().getStringId());
    }

    public PortletMode getPortletMode() {
        return this.portalURL.getPortletMode(this.getId().getStringId());
    }

    public PortletWindowID getId() {
        if (this.objectIdImpl == null) {
            this.objectIdImpl = PortletWindowIDImpl.createFromString(this.config.getId());
        }
        return this.objectIdImpl;
    }

    public PortletDefinition getPortletDefinition() {
        return this.portlet;
    }
}

