/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.core;

import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.ResourceURLProvider;
import org.apache.pluto.driver.core.PortalRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceURLProviderImpl
implements ResourceURLProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceURLProviderImpl.class);
    private String stringUrl = "";
    private String base = "";

    public ResourceURLProviderImpl(HttpServletRequest req, PortletWindow portletWindow) {
        PortalRequestContext ctx = PortalRequestContext.getContext(req);
        this.base = ctx.createPortalURL().getServerURI();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resource URL Created with base: " + this.base);
        }
    }

    public void setAbsoluteURL(String path) {
        this.stringUrl = path;
    }

    public void setFullPath(String path) {
        this.stringUrl = this.base + path;
    }

    public String toString() {
        URL url = null;
        if (!"".equals(this.stringUrl)) {
            try {
                url = new URL(this.stringUrl);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("A malformed URL has occured");
            }
        }
        return url == null ? "" : url.toString();
    }
}

