/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.portlets;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.io.FileUtils;
import org.apache.pluto.driver.config.DriverConfiguration;
import org.apache.pluto.driver.portlets.GenericPlutoPortlet;
import org.apache.pluto.driver.services.portal.PageConfig;
import org.apache.pluto.driver.services.portal.PortletWindowConfig;
import org.apache.pluto.driver.services.portal.RenderConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageAdminPortlet
extends GenericPlutoPortlet {
    private static final Logger LOG = LoggerFactory.getLogger(PageAdminPortlet.class);
    private static final String JSP_DIR = "/WEB-INF/fragments/admin/page/";
    private static final String VIEW_PAGE = "/WEB-INF/fragments/admin/page/view.jsp";
    private static final String EDIT_PAGE = "/WEB-INF/fragments/admin/page/edit.jsp";
    private static final String HELP_PAGE = "/WEB-INF/fragments/admin/page/help.jsp";
    private static final String CONFIG_FILE_PATH = "/WEB-INF/pluto-portal-driver-config.xml";
    private static final String RENDER_CONFIG_SEARCH_TOKEN = "<render-config default=\"";

    public void processAction(ActionRequest request, ActionResponse response) {
        String command = request.getParameter("command");
        try {
            if ("Add Portlet".equalsIgnoreCase(command)) {
                this.doAddPortlet(request);
            } else if ("Remove Portlet".equalsIgnoreCase(command)) {
                this.doRemovePortlet(request);
            } else if ("Add Page".equalsIgnoreCase(command)) {
                this.doAddPage(request);
            } else if ("Remove Page".equalsIgnoreCase(command)) {
                this.doRemovePage(request);
            }
            this.persistPages();
        }
        catch (IOException e) {
            String msg = "Problem persisting configuration changes. Changes will not be persisted.";
            LOG.error(msg, (Throwable)e);
        }
    }

    public void doAddPortlet(ActionRequest request) {
        String page = request.getParameter("page");
        String applicationName = request.getParameter("applications");
        String portletName = request.getParameter("availablePortlets");
        LOG.info("Request: Add [applicationName=" + applicationName + ":portletName=" + portletName + "] to page '" + page + "'");
        String contextPath = applicationName;
        if (contextPath.length() > 0) {
            contextPath = "/" + contextPath;
        }
        PageConfig config = this.getPageConfig(page);
        config.addPortlet(contextPath, portletName);
    }

    public void doAddPage(ActionRequest request) {
        String page = request.getParameter("newPage");
        if (page == null || page.equals("")) {
            LOG.warn("Page parameter is null or empty. Page addition will be ignored.");
            return;
        }
        String uri = request.getParameter("pageURI");
        if (uri == null) {
            uri = "/WEB-INF/themes/pluto-default-theme.jsp";
        }
        DriverConfiguration driverConfig = (DriverConfiguration)this.getPortletContext().getAttribute("driverConfig");
        PageConfig pageConfig = new PageConfig();
        pageConfig.setName(page);
        pageConfig.setUri(uri);
        RenderConfigService renderConfig = driverConfig.getRenderConfigService();
        renderConfig.addPage(pageConfig);
    }

    public void doRemovePage(ActionRequest request) throws IOException {
        String page = request.getParameter("page");
        DriverConfiguration driverConfig = (DriverConfiguration)this.getPortletContext().getAttribute("driverConfig");
        String defaultPage = this.getDefaultPage();
        if (page.equalsIgnoreCase(defaultPage)) {
            LOG.warn("Trying to delete the default page. Page deletion will be ignored.");
            return;
        }
        if (page.equalsIgnoreCase("Pluto Admin")) {
            LOG.warn("Trying to delete the Pluto Admin page. Page deletion will be ignored.");
            return;
        }
        PageConfig pageConfig = this.getPageConfig(page);
        RenderConfigService renderConfig = driverConfig.getRenderConfigService();
        renderConfig.removePage(pageConfig);
    }

    public void doRemovePortlet(ActionRequest request) {
        String page = request.getParameter("page");
        String portletId = request.getParameter("placedPortlets");
        LOG.info("Request: Remove [portletId=" + portletId + "] from page '" + page + "'");
        PageConfig config = this.getPageConfig(page);
        config.removePortlet(portletId);
    }

    private PageConfig getPageConfig(String page) {
        DriverConfiguration driverConfig = (DriverConfiguration)this.getPortletContext().getAttribute("driverConfig");
        PageConfig config = driverConfig.getPageConfig(page);
        return config;
    }

    @Override
    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        request.setAttribute("availablePages", (Object)this.getAvailablePages());
        super.doView(request, response);
    }

    @Override
    public String getViewPage() {
        return VIEW_PAGE;
    }

    @Override
    public String getEditPage() {
        return EDIT_PAGE;
    }

    @Override
    public String getHelpPage(RenderRequest request) {
        String incPage = HELP_PAGE;
        String page = request.getParameter("helpPage");
        if (page != null) {
            incPage = JSP_DIR + page;
        }
        return incPage;
    }

    public Collection getAvailablePages() {
        DriverConfiguration configuration = (DriverConfiguration)this.getPortletContext().getAttribute("driverConfig");
        ArrayList<Page> list = new ArrayList<Page>();
        for (PageConfig config : configuration.getPages()) {
            ArrayList<Placement> portlets = new ArrayList<Placement>();
            Iterator<String> pids = config.getPortletIds().iterator();
            while (pids.hasNext()) {
                String pid = pids.next().toString();
                String name = PortletWindowConfig.parsePortletName(pid);
                portlets.add(new Placement(pid, name));
            }
            list.add(new Page(config.getName(), config.getName(), portlets));
        }
        return list;
    }

    private void persistPages() throws IOException {
        String NL = System.getProperty("line.separator");
        DriverConfiguration driverConfig = (DriverConfiguration)this.getPortletContext().getAttribute("driverConfig");
        StringBuffer renderConfig = new StringBuffer();
        renderConfig.append(" ");
        renderConfig.append(RENDER_CONFIG_SEARCH_TOKEN);
        renderConfig.append(this.getDefaultPage());
        renderConfig.append("\">");
        renderConfig.append(NL);
        Collection pages = this.getAvailablePages();
        for (Page page : pages) {
            PageConfig config = driverConfig.getPageConfig(page.getName());
            renderConfig.append("    <page name=\"");
            String pageName = config.getName();
            renderConfig.append(pageName);
            renderConfig.append("\" uri=\"");
            String uri = config.getUri();
            renderConfig.append(uri);
            renderConfig.append("\">");
            renderConfig.append(NL);
            Collection<String> portletIds = config.getPortletIds();
            Iterator<String> iterator = portletIds.iterator();
            while (iterator.hasNext()) {
                renderConfig.append("      <portlet context=\"");
                String pid = iterator.next();
                String pletContext = PortletWindowConfig.parseContextPath(pid);
                renderConfig.append(pletContext);
                renderConfig.append("\" name=\"");
                String pletName = PortletWindowConfig.parsePortletName(pid);
                renderConfig.append(pletName);
                renderConfig.append("\"/>");
                renderConfig.append(NL);
            }
            renderConfig.append("    </page>");
            renderConfig.append(NL);
        }
        renderConfig.append("  </render-config>");
        renderConfig.append(NL);
        renderConfig.append(NL);
        renderConfig.append("</pluto-portal-driver>");
        renderConfig.append(NL);
        StringBuffer newFileContents = new StringBuffer();
        newFileContents.append(PageAdminPortlet.getContentBeforeRenderConfig(this.getConfigFileContents()));
        newFileContents.append(renderConfig);
        FileUtils.writeStringToFile((File)this.getConfigFile(), (String)newFileContents.toString());
    }

    private String getConfigFileContents() throws IOException {
        return FileUtils.readFileToString((File)this.getConfigFile());
    }

    private File getConfigFile() {
        String path = this.getPortletContext().getRealPath(CONFIG_FILE_PATH);
        return new File(path);
    }

    private String getDefaultPage() throws IOException {
        String configFileContents = this.getConfigFileContents();
        return PageAdminPortlet.parseDefaultPage(configFileContents);
    }

    protected static String getContentBeforeRenderConfig(String contents) {
        return contents.substring(0, contents.indexOf(RENDER_CONFIG_SEARCH_TOKEN));
    }

    protected static String parseDefaultPage(String configFileContents) {
        String defPage = null;
        int DEF_TOK_LEN = RENDER_CONFIG_SEARCH_TOKEN.length();
        int startInd = configFileContents.indexOf(RENDER_CONFIG_SEARCH_TOKEN) + DEF_TOK_LEN;
        String restOfConfigFile = configFileContents.substring(startInd);
        int endInd = restOfConfigFile.indexOf(34);
        defPage = configFileContents.substring(startInd, startInd + endInd);
        return defPage;
    }

    public class Placement {
        private String id;
        private String portletName;

        public Placement(String id, String portletName) {
            this.id = id;
            this.portletName = portletName;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getPortletName() {
            return this.portletName;
        }

        public void setPortletName(String portletName) {
            this.portletName = portletName;
        }
    }

    public class Page {
        private String id;
        private String name;
        private Collection portlets;

        public Page(String pageId, String pageName, Collection portlets) {
            this.id = pageId;
            this.name = pageName;
            this.portlets = portlets;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public Collection getPortlets() {
            return this.portlets;
        }

        public void setPortlets(Collection portlets) {
            this.portlets = portlets;
        }
    }
}

