/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.portal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.pluto.container.PageResourceId;
import org.apache.pluto.driver.services.portal.PortletWindowConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageConfig {
    private static final Logger LOG = LoggerFactory.getLogger(PageConfig.class);
    private String name;
    private String uri;
    private Collection<String> portletIds;
    private int orderNumber;
    private List<PageResourceId> pageResources = new ArrayList<PageResourceId>();

    public PageConfig() {
        this.portletIds = new ArrayList<String>();
        if (LOG.isTraceEnabled()) {
            LOG.debug("Constructor.");
        }
    }

    public List<PageResourceId> getPageResources() {
        return this.pageResources;
    }

    public void addPageDependency(String name, String scope, String version) {
        if (name != null) {
            PageResourceId resid = new PageResourceId(name, scope, version);
            this.pageResources.add(resid);
        } else {
            LOG.warn("Resource name cannot be null.");
        }
        if (LOG.isDebugEnabled()) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("Adding resource dependency. # deps: ").append(this.pageResources.size());
            txt.append(", name: ").append(name);
            txt.append(", scope: ").append(scope);
            txt.append(", version: ").append(version);
            LOG.debug(txt.toString());
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (LOG.isTraceEnabled()) {
            LOG.debug("Page Name = " + name);
        }
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public Collection<String> getPortletIds() {
        return this.portletIds;
    }

    public void setPortletIds(Collection<String> ids) {
        this.portletIds = ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPortlet(String contextPath, String portletName) {
        String pid = PortletWindowConfig.createPortletId(contextPath, portletName, this.createPlacementId());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Add Portlet ID = " + pid);
        }
        Collection<String> collection = this.portletIds;
        synchronized (collection) {
            this.portletIds.add(pid);
        }
    }

    public void removePortlet(String portletId) {
        this.portletIds.remove(portletId);
    }

    void setOrderNumber(int number) {
        this.orderNumber = number;
    }

    int getOrderNumber() {
        return this.orderNumber;
    }

    private String createPlacementId() {
        return this.getName().hashCode() + "|" + this.portletIds.size();
    }
}

