/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.tags;

import java.io.IOException;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.pluto.driver.core.PortalRequestContext;
import org.apache.pluto.driver.tags.PortletTag;
import org.apache.pluto.driver.url.PortalURL;

public class PortletPortalURLTag
extends BodyTagSupport {
    private String windowState;
    private String portletMode;

    public String getWindowState() {
        return this.windowState;
    }

    public void setWindowState(String windowState) {
        this.windowState = windowState;
    }

    public String getPortletMode() {
        return this.portletMode;
    }

    public void setPortletMode(String portletMode) {
        this.portletMode = portletMode;
    }

    public int doStartTag() throws JspException {
        PortletTag parentTag = (PortletTag)TagSupport.findAncestorWithClass((Tag)this, PortletTag.class);
        if (parentTag == null) {
            throw new JspException("Portlet window controls may only reside within a pluto:portlet tag.");
        }
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
        PortalRequestContext ctx = PortalRequestContext.getContext(request);
        PortalURL portalUrl = ctx.createPortalURL();
        String portletId = parentTag.getEvaluatedPortletId();
        if (this.windowState != null) {
            portalUrl.setWindowState(portletId, new WindowState(this.windowState));
        }
        if (this.portletMode != null) {
            portalUrl.setPortletMode(portletId, new PortletMode(this.portletMode));
        }
        try {
            this.pageContext.getOut().print(response.encodeURL(portalUrl.toString()));
        }
        catch (IOException ex) {
            throw new JspException((Throwable)ex);
        }
        return 0;
    }
}

