/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.tags;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.portlet.WindowState;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.om.portlet.ContainerRuntimeOption;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.apache.pluto.driver.config.DriverConfiguration;
import org.apache.pluto.driver.core.PortalRequestContext;
import org.apache.pluto.driver.core.PortalServletResponse;
import org.apache.pluto.driver.core.PortletWindowImpl;
import org.apache.pluto.driver.services.portal.PortletWindowConfig;
import org.apache.pluto.driver.url.PortalURL;
import org.apache.pluto.tags.el.ExpressionEvaluatorProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletTag
extends BodyTagSupport {
    private static final long serialVersionUID = 7369029503826395301L;
    private static final Logger LOG = LoggerFactory.getLogger(PortletTag.class);
    public static final int FAILED = 0;
    public static final int SUCCESS = 1;
    private String portletId;
    private String evaluatedPortletId;
    private PortletWindow window;
    private PortalServletResponse response;
    private int status;
    private List<String> messages;

    public String getPortletId() {
        return this.portletId;
    }

    public void setPortletId(String portletId) {
        this.portletId = portletId;
    }

    public int doStartTag() throws JspException {
        this.messages = new ArrayList<String>();
        this.evaluatePortletId();
        ServletContext servletContext = this.pageContext.getServletContext();
        PortletWindowConfig windowConfig = PortletWindowConfig.fromId(this.evaluatedPortletId);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Rendering Portlet Window: " + windowConfig);
        }
        PortalRequestContext portalEnv = PortalRequestContext.getContext((HttpServletRequest)this.pageContext.getRequest());
        PortalURL portalURL = portalEnv.getRequestedPortalURL();
        PortletContainer container = (PortletContainer)servletContext.getAttribute("portletContainer");
        this.window = null;
        try {
            this.window = new PortletWindowImpl(container, windowConfig, portalURL);
        }
        catch (Throwable e) {
            this.status = 0;
            StringBuilder txt = new StringBuilder(128);
            txt.append("The portlet '");
            txt.append(windowConfig.getPortletName());
            txt.append("' is not available.");
            txt.append(" Configuration could not be found.");
            this.messages.add(txt.toString());
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.flush();
            txt.append("\n");
            txt.append(sw.toString());
            LOG.warn(txt.toString());
        }
        PortalServletResponse portalResponse = new PortalServletResponse((HttpServletResponse)this.pageContext.getResponse());
        if (this.window != null) {
            Map<String, WindowState> windowStates = portalURL.getWindowStates();
            for (String windowId : windowStates.keySet()) {
                WindowState windowState = windowStates.get(windowId);
                if (!WindowState.MAXIMIZED.equals((Object)windowState) || this.window.getId().getStringId().equals(windowId)) continue;
                return 0;
            }
            DriverConfiguration driverConfig = (DriverConfiguration)servletContext.getAttribute("driverConfig");
            PortletDefinition pd = this.window.getPortletDefinition();
            String mode = this.window.getPortletMode().toString();
            boolean supported = driverConfig.isPortletModeSupported(this.evaluatedPortletId, mode);
            if (supported) {
                try {
                    List headers;
                    ContainerRuntimeOption crt;
                    String renderHeaders = null;
                    if (portalURL.getVersion(this.evaluatedPortletId).equalsIgnoreCase("2.0") && (crt = pd.getContainerRuntimeOption("javax.portlet.renderHeaders")) != null && (headers = crt.getValues()).size() == 1 && ((String)headers.get(0)).equalsIgnoreCase("true")) {
                        renderHeaders = "RENDER_MARKUP";
                    }
                    container.doRender(this.window, (HttpServletRequest)this.pageContext.getRequest(), (HttpServletResponse)portalResponse, renderHeaders);
                    this.response = portalResponse;
                    this.status = 1;
                }
                catch (Throwable th) {
                    this.status = 0;
                    this.messages.add("Portlet not available. Exception: " + th.getMessage());
                }
            } else {
                this.status = 0;
                this.messages.add("Portlet not available. Portlet mode not supported: " + mode);
            }
        }
        return 1;
    }

    int getStatus() {
        return this.status;
    }

    PortalServletResponse getPortalServletResponse() {
        return this.response;
    }

    List<String> getMessages() {
        return this.messages;
    }

    String getEvaluatedPortletId() {
        return this.evaluatedPortletId;
    }

    public PortletWindow getWindow() {
        return this.window;
    }

    private void evaluatePortletId() throws JspException {
        ExpressionEvaluatorProxy proxy = ExpressionEvaluatorProxy.getProxy();
        String obj = proxy.evaluate(this.portletId, this.pageContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Evaluated portletId to: " + obj);
        }
        this.evaluatedPortletId = obj;
    }
}

