/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.tags;

import java.util.ListResourceBundle;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ToolTips {
    private static final ResourceBundle BUNDLE;
    private static final Logger LOG;
    static final ToolTips MAXIMIZE;
    static final ToolTips MINIMIZE;
    static final ToolTips NORMAL;
    static final ToolTips VIEW;
    static final ToolTips EDIT;
    static final ToolTips HELP;
    static final String CSS_CLASS_NAME;
    private String tooltip;

    private ToolTips(String tooltip) {
        this.tooltip = tooltip;
    }

    static ToolTips forMode(PortletMode mode) {
        StringBuffer tip = new StringBuffer("");
        try {
            tip.append(BUNDLE.getString("tooltip.mode." + mode));
        }
        catch (MissingResourceException e) {
            LOG.warn("No tooltip found for portlet mode [" + mode + "]", (Throwable)e);
        }
        return new ToolTips(tip.toString());
    }

    static ToolTips forWindowState(WindowState state) {
        StringBuffer tip = new StringBuffer("");
        try {
            tip.append(BUNDLE.getString("tooltip.windowstate." + state));
        }
        catch (MissingResourceException e) {
            LOG.warn("No tooltip found for window state [" + state + "]", (Throwable)e);
        }
        return new ToolTips(tip.toString());
    }

    public String toString() {
        return this.tooltip;
    }

    static {
        ResourceBundle bundle;
        try {
            bundle = ResourceBundle.getBundle("ToolTips");
        }
        catch (MissingResourceException e) {
            bundle = new ListResourceBundle(){

                @Override
                protected Object[][] getContents() {
                    return new Object[][]{{"tooltip.windowstate.maximized", "Maximize"}, {"tooltip.windowstate.minimized", "Minimize"}, {"tooltip.windowstate.normal", "Restore"}, {"tooltip.mode.view", "View"}, {"tooltip.mode.help", "Help"}, {"tooltip.mode.edit", "Edit"}, {"tooltip.css.classname", "tooltip"}};
                }
            };
        }
        BUNDLE = bundle;
        LOG = LoggerFactory.getLogger(ToolTips.class);
        MAXIMIZE = new ToolTips(BUNDLE.getString("tooltip.windowstate.maximized"));
        MINIMIZE = new ToolTips(BUNDLE.getString("tooltip.windowstate.minimized"));
        NORMAL = new ToolTips(BUNDLE.getString("tooltip.windowstate.normal"));
        VIEW = new ToolTips(BUNDLE.getString("tooltip.mode.view"));
        EDIT = new ToolTips(BUNDLE.getString("tooltip.mode.edit"));
        HELP = new ToolTips(BUNDLE.getString("tooltip.mode.help"));
        CSS_CLASS_NAME = BUNDLE.getString("tooltip.css.classname");
    }
}

