/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.url;

import java.util.Arrays;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalURLParameter {
    private final Logger LOGGER = LoggerFactory.getLogger(PortalURLParameter.class);
    public static final String PARAM_TYPE_RENDER = "rp";
    public static final String PARAM_TYPE_ACTION = "ap";
    public static final String PARAM_TYPE_RESOURCE = "re";
    public static final String PARAM_TYPE_PUBLIC = "sp";
    private static final HashSet<String> allowedTypes = new HashSet();
    protected final String window;
    protected final String name;
    protected String[] values;
    protected String type;
    protected boolean persistent;

    public PortalURLParameter(PortalURLParameter pup) {
        allowedTypes.add(PARAM_TYPE_RENDER);
        allowedTypes.add(PARAM_TYPE_ACTION);
        allowedTypes.add(PARAM_TYPE_RESOURCE);
        this.persistent = false;
        this.window = pup.window;
        this.name = pup.name;
        this.values = pup.values == null ? null : (String[])pup.values.clone();
        this.type = pup.type;
        this.persistent = pup.persistent;
    }

    protected PortalURLParameter(String window, String name) {
        allowedTypes.add(PARAM_TYPE_RENDER);
        allowedTypes.add(PARAM_TYPE_ACTION);
        allowedTypes.add(PARAM_TYPE_RESOURCE);
        this.persistent = false;
        this.window = window;
        this.name = name;
        this.values = null;
    }

    public PortalURLParameter(String window, String name, String[] values) {
        allowedTypes.add(PARAM_TYPE_RENDER);
        allowedTypes.add(PARAM_TYPE_ACTION);
        allowedTypes.add(PARAM_TYPE_RESOURCE);
        this.persistent = false;
        this.window = window;
        this.name = name;
        this.values = values;
        this.type = PARAM_TYPE_RENDER;
    }

    public PortalURLParameter(String window, String name, String[] values, String type) {
        allowedTypes.add(PARAM_TYPE_RENDER);
        allowedTypes.add(PARAM_TYPE_ACTION);
        allowedTypes.add(PARAM_TYPE_RESOURCE);
        this.persistent = false;
        this.window = window;
        this.name = name;
        this.values = values;
        this.type = type;
        if (!allowedTypes.contains(type)) {
            this.LOGGER.warn("Parameter type: " + type + " is not in allowed set: " + allowedTypes.toString());
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (!allowedTypes.contains(type)) {
            this.LOGGER.warn("Parameter type: " + type + " is not in allowed set: " + allowedTypes.toString());
        }
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public String[] getValues() {
        return this.values;
    }

    public void setValues(String[] values) {
        this.values = values;
    }

    public String getWindowId() {
        return this.window;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public String toString() {
        StringBuilder txt = new StringBuilder(128);
        txt.append("Type: ").append(this.type);
        txt.append(", persistent: ").append(this.persistent);
        txt.append(", name: ").append(this.name);
        txt.append(", values: ").append(this.values == null ? "null" : Arrays.toString(this.values));
        txt.append(", window ID: ").append(this.window);
        return txt.toString();
    }

    public PortalURLParameter clone() {
        return new PortalURLParameter(this);
    }

    public boolean equals(Object o) {
        boolean eq = false;
        if (o instanceof PortalURLParameter) {
            if (o == this) {
                eq = true;
            } else {
                PortalURLParameter pup = (PortalURLParameter)o;
                if (this.equals(this.window, pup.window) && this.equals(this.name, pup.name) && this.equals(this.type, pup.type)) {
                    eq = true;
                }
            }
        }
        return eq;
    }

    public int hashCode() {
        int hc = 17;
        if (this.window != null) {
            hc += 37 * hc + this.window.hashCode();
        }
        if (this.name != null) {
            hc += 37 * hc + this.name.hashCode();
        }
        if (this.type != null) {
            hc += 37 * hc + this.type.hashCode();
        }
        return hc;
    }

    protected boolean equals(Object o1, Object o2) {
        boolean eq = false;
        if (o1 == o2) {
            eq = true;
        } else if (o1 != null && o2 != null) {
            eq = o1.equals(o2);
        }
        return eq;
    }
}

