/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.url;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pluto.container.PortletRequestContext;
import org.apache.pluto.driver.services.portal.PublicRenderParameterMapper;
import org.apache.pluto.driver.url.PortalURL;
import org.apache.pluto.driver.url.PortalURLParameter;
import org.apache.pluto.driver.url.PortalURLPublicParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletParameterFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PortletParameterFactory.class);
    private static final boolean isTrace = LOGGER.isTraceEnabled();
    private static final boolean isDebug = LOGGER.isDebugEnabled();
    private PortalURL url;
    static final HashSet<PortalURL.URLType> actionTypes = new HashSet();
    private static final HashMap<PortalURL.URLType, String> urlTypeMap;
    private final PortletRequestContext reqctx;

    public PortletParameterFactory(PortalURL url, PortletRequestContext reqctx) {
        this.url = url;
        this.reqctx = reqctx;
    }

    public Map<String, String[]> getParameterMap(String windowId) {
        ArrayList<Object> vals;
        HashMap<String, String[]> parameters = new HashMap<String, String[]>();
        boolean isV3 = this.url.isVersion3(windowId);
        Map queryParams = this.reqctx.getQueryParams();
        if (queryParams != null) {
            for (String name : queryParams.keySet()) {
                parameters.put(name, ((List)queryParams.get(name)).toArray(new String[0]));
            }
        }
        for (PortalURLParameter pup : this.url.getParameters()) {
            if (!pup.getWindowId().equals(windowId) || !pup.getType().equals("ap") && !pup.getType().equals("re")) continue;
            if (parameters.containsKey(pup.getName())) {
                vals = new ArrayList<Object>(Arrays.asList((Object[])parameters.get(pup.getName())));
                vals.addAll(Arrays.asList(pup.getValues()));
                parameters.put(pup.getName(), vals.toArray(new String[0]));
                continue;
            }
            parameters.put(pup.getName(), (String[])pup.getValues().clone());
        }
        if (isV3 || !actionTypes.contains((Object)this.url.getType())) {
            for (PortalURLParameter pup : this.url.getParameters()) {
                if (!pup.getWindowId().equals(windowId) || !pup.getType().equals("rp")) continue;
                if (parameters.containsKey(pup.getName())) {
                    vals = new ArrayList<Object>(Arrays.asList((Object[])parameters.get(pup.getName())));
                    vals.addAll(Arrays.asList(pup.getValues()));
                    parameters.put(pup.getName(), vals.toArray(new String[0]));
                    continue;
                }
                parameters.put(pup.getName(), (String[])pup.getValues().clone());
            }
        }
        PublicRenderParameterMapper mapper = this.url.getPublicRenderParameterMapper();
        List<PortalURLPublicParameter> prps = mapper.getPRPsForWindow(windowId, true);
        for (PortalURLPublicParameter prp : prps) {
            if (parameters.containsKey(prp.getName())) {
                ArrayList<Object> vals2 = new ArrayList<Object>(Arrays.asList((Object[])parameters.get(prp.getName())));
                vals2.addAll(Arrays.asList(prp.getValues()));
                parameters.put(prp.getName(), vals2.toArray(new String[0]));
                continue;
            }
            parameters.put(prp.getName(), (String[])prp.getValues().clone());
        }
        if (isTrace) {
            StringBuffer sb = new StringBuffer();
            sb.append("Dump Parameter Map:");
            for (String k : parameters.keySet()) {
                sb.append("\nName: " + k + ", Values: ");
                String sep = "";
                for (String v : parameters.get(k)) {
                    sb.append(sep + v);
                    sep = ", ";
                }
            }
            LOGGER.trace(sb.toString());
        }
        return parameters;
    }

    public Map<String, String[]> getPrivateParameterMap(String windowId) {
        ArrayList<Object> vals;
        HashMap<String, String[]> parameters = new HashMap<String, String[]>();
        boolean isV3 = this.url.isVersion3(windowId);
        Map queryParams = this.reqctx.getQueryParams();
        if (queryParams != null) {
            for (String name : queryParams.keySet()) {
                parameters.put(name, ((List)queryParams.get(name)).toArray(new String[0]));
            }
        }
        for (PortalURLParameter pup : this.url.getParameters()) {
            if (!pup.getWindowId().equals(windowId) || !pup.getType().equals("ap") && !pup.getType().equals("re")) continue;
            if (parameters.containsKey(pup.getName())) {
                vals = new ArrayList<Object>(Arrays.asList((Object[])parameters.get(pup.getName())));
                vals.addAll(Arrays.asList(pup.getValues()));
                parameters.put(pup.getName(), vals.toArray(new String[0]));
                continue;
            }
            parameters.put(pup.getName(), (String[])pup.getValues().clone());
        }
        if (isV3 || !actionTypes.contains((Object)this.url.getType())) {
            for (PortalURLParameter pup : this.url.getParameters()) {
                if (!pup.getWindowId().equals(windowId) || !pup.getType().equals("rp")) continue;
                if (parameters.containsKey(pup.getName())) {
                    vals = new ArrayList<Object>(Arrays.asList((Object[])parameters.get(pup.getName())));
                    vals.addAll(Arrays.asList(pup.getValues()));
                    parameters.put(pup.getName(), vals.toArray(new String[0]));
                    continue;
                }
                parameters.put(pup.getName(), (String[])pup.getValues().clone());
            }
        }
        if (isTrace) {
            StringBuffer sb = new StringBuffer();
            sb.append("Dump private Parameter Map:");
            for (String k : parameters.keySet()) {
                sb.append("\nName: " + k + ", Values: ");
                String sep = "";
                for (String v : parameters.get(k)) {
                    sb.append(sep + v);
                    sep = ", ";
                }
            }
            LOGGER.trace(sb.toString());
        }
        return parameters;
    }

    public Map<String, String[]> getPublicParameterMap(String windowId) {
        HashMap<String, String[]> parameters = new HashMap<String, String[]>();
        PublicRenderParameterMapper mapper = this.url.getPublicRenderParameterMapper();
        List<PortalURLPublicParameter> prps = mapper.getPRPsForWindow(windowId, true);
        for (PortalURLPublicParameter prp : prps) {
            parameters.put(prp.getName(), (String[])prp.getValues().clone());
        }
        if (isTrace) {
            LOGGER.debug("getPublicParameterMap returning " + parameters.size() + " parameters.");
        }
        return parameters;
    }

    public Map<String, String[]> getResourceRenderParameterMap(String windowId) {
        HashMap<String, String[]> parameters = new HashMap<String, String[]>();
        for (PortalURLParameter pup : this.url.getParameters()) {
            if (!pup.getWindowId().equals(windowId) || !pup.getType().equals("rp")) continue;
            parameters.put(pup.getName(), (String[])pup.getValues().clone());
        }
        return parameters;
    }

    public void addPublicRenderParameter(String windowId, String name, String[] values) {
        int index;
        PublicRenderParameterMapper prpMapper = this.url.getPublicRenderParameterMapper();
        if (isTrace) {
            StringBuilder txt = new StringBuilder("Add PRP. Window: ");
            txt.append(windowId).append(", name: ").append(name).append(", values = ").append(Arrays.toString(values));
            LOGGER.debug(txt.toString());
        }
        if ((index = prpMapper.getIndex(windowId, name)) >= 0) {
            prpMapper.setValues(index, values);
        } else {
            StringBuilder txt = new StringBuilder("Public render parameter for window: ");
            txt.append(windowId).append(", name: ").append(name).append(" not found in mapper");
            LOGGER.warn(txt.toString());
        }
    }

    public void removePublicRenderParameter(String windowId, String name) {
        int index;
        PublicRenderParameterMapper prpMapper = this.url.getPublicRenderParameterMapper();
        if (isTrace) {
            StringBuilder txt = new StringBuilder("Remove PRP. Window: ");
            txt.append(windowId).append(", name: ").append(name);
            LOGGER.debug(txt.toString());
        }
        if ((index = prpMapper.getIndex(windowId, name)) >= 0) {
            prpMapper.setRemoved(index, true);
        } else {
            StringBuilder txt = new StringBuilder("Public render parameter for window: ");
            txt.append(windowId).append(", name: ").append(name).append(" not found in mapper");
            LOGGER.warn(txt.toString());
        }
    }

    public boolean isPublicRenderParameter(String windowId, String name) {
        int index;
        PublicRenderParameterMapper prpMapper = this.url.getPublicRenderParameterMapper();
        if (isTrace) {
            StringBuilder txt = new StringBuilder("Window: ");
            txt.append(windowId).append(", name: ").append(name);
            LOGGER.debug(txt.toString());
        }
        return (index = prpMapper.getIndex(windowId, name)) >= 0;
    }

    public Set<String> getPrivateParameterNames(String windowId) {
        HashSet<String> names = new HashSet<String>();
        String type = urlTypeMap.get((Object)this.url.getType());
        Map queryParams = this.reqctx.getQueryParams();
        if (queryParams != null) {
            names.addAll(queryParams.keySet());
        }
        for (PortalURLParameter p : this.url.getParameters()) {
            if (!p.getWindowId().equals(windowId) || !p.getType().equals(type)) continue;
            names.add(p.getName());
        }
        if (isTrace) {
            StringBuilder txt = new StringBuilder();
            txt.append("Window ID: ").append(windowId);
            txt.append(", URL / Parameter type: ").append(type);
            txt.append(", names: ").append(names.toString());
            LOGGER.debug(txt.toString());
        }
        return names;
    }

    public String[] getParameterValues(String windowId, String name) {
        PublicRenderParameterMapper prpMapper = this.url.getPublicRenderParameterMapper();
        String type = urlTypeMap.get((Object)this.url.getType());
        String[] vals = null;
        if (isTrace) {
            StringBuilder txt = new StringBuilder("Setting ");
            txt.append("name: ").append(name);
            txt.append(", URL / Parameter type: ").append(type);
            txt.append(", window ID: ").append(windowId);
            LOGGER.debug(txt.toString());
        }
        if (this.url.getType() == PortalURL.URLType.Render && this.isPublicRenderParameter(windowId, name)) {
            int index = prpMapper.getIndex(windowId, name);
            if (index >= 0) {
                vals = prpMapper.getValues(index);
                if (vals != null) {
                    vals = (String[])vals.clone();
                }
            } else {
                LOGGER.debug("Public render parameter name not found in index.");
            }
        } else {
            for (PortalURLParameter p : this.url.getParameters()) {
                if (!p.getWindowId().equals(windowId) || !p.getName().equals(name) || !p.getType().equals(type)) continue;
                vals = (String[])p.getValues().clone();
            }
        }
        Map queryParams = this.reqctx.getQueryParams();
        if (queryParams != null && queryParams.containsKey(name)) {
            ArrayList<String> qpvals = new ArrayList<String>((Collection)queryParams.get(name));
            if (vals != null) {
                qpvals.addAll(Arrays.asList(vals));
            }
            vals = qpvals.toArray(new String[0]);
        }
        return vals;
    }

    public void setParameter(String windowId, String name, String[] values) {
        String type = urlTypeMap.get((Object)this.url.getType());
        if (isTrace) {
            StringBuilder txt = new StringBuilder("Setting ");
            txt.append("name: ").append(name);
            txt.append(", values: ").append(Arrays.toString(values));
            txt.append(", type: ").append(type);
            txt.append(", window ID: ").append(windowId);
            LOGGER.debug(txt.toString());
        }
        if (this.url.getType() == PortalURL.URLType.Render && this.isPublicRenderParameter(windowId, name)) {
            this.addPublicRenderParameter(windowId, name, values);
        } else if (urlTypeMap.containsKey((Object)this.url.getType())) {
            PortalURLParameter pup = new PortalURLParameter(windowId, name, values, type);
            this.url.setParameter(pup);
        } else {
            LOGGER.warn("Unsupported URL / Parameter type: " + (Object)((Object)this.url.getType()));
        }
    }

    public void removeParameter(String windowId, String name) {
        String type = urlTypeMap.get((Object)this.url.getType());
        if (isTrace) {
            StringBuilder txt = new StringBuilder("Removing ");
            txt.append("name: ").append(name);
            txt.append(", type: ").append(type);
            txt.append(", window ID: ").append(windowId);
            LOGGER.debug(txt.toString());
        }
        if (this.isPublicRenderParameter(windowId, name)) {
            throw new IllegalArgumentException("Cannot set a public render parameter to null. Parameter name: " + name);
        }
        PortalURLParameter pup = new PortalURLParameter(windowId, name, null, type);
        this.url.removeParameter(pup);
    }

    public Map<String, String[]> getParameterMap(String windowId, String type) {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        Map queryParams = this.reqctx.getQueryParams();
        String phase = this.reqctx.getPhase();
        if (queryParams != null) {
            HashMap<String, String[]> qp = new HashMap<String, String[]>();
            for (String name : queryParams.keySet()) {
                qp.put(name, ((List)queryParams.get(name)).toArray(new String[0]));
            }
            if (isTrace) {
                StringBuilder txt = new StringBuilder("Query params available.");
                txt.append(", phase: ").append(phase);
                for (String name : qp.keySet()) {
                    txt.append("\nName: ").append(name);
                    txt.append(", Values: ").append(Arrays.toString((Object[])qp.get(name)));
                }
                LOGGER.debug(txt.toString());
            }
            if (type.equals("rp")) {
                params.putAll(qp);
            }
        }
        for (PortalURLParameter pup : this.url.getParameters()) {
            if (!pup.getWindowId().equals(windowId) || !pup.getType().equals(type)) continue;
            if (params.containsKey(pup.getName())) {
                ArrayList<Object> vals = new ArrayList<Object>(Arrays.asList((Object[])params.get(pup.getName())));
                vals.addAll(Arrays.asList(pup.getValues()));
                params.put(pup.getName(), vals.toArray(new String[0]));
                continue;
            }
            params.put(pup.getName(), (String[])pup.getValues().clone());
        }
        if (type.equals("rp")) {
            PublicRenderParameterMapper mapper = this.url.getPublicRenderParameterMapper();
            for (PortalURLPublicParameter prp : mapper.getPRPsForWindow(windowId, true)) {
                if (params.containsKey(prp.getName())) {
                    ArrayList<Object> vals = new ArrayList<Object>(Arrays.asList((Object[])params.get(prp.getName())));
                    vals.addAll(Arrays.asList(prp.getValues()));
                    params.put(prp.getName(), vals.toArray(new String[0]));
                    continue;
                }
                params.put(prp.getName(), (String[])prp.getValues().clone());
            }
        }
        if (isTrace) {
            StringBuilder txt = new StringBuilder("Parameter map for ");
            txt.append("window ID: ").append(windowId);
            txt.append(", type: ").append(type);
            for (String name : params.keySet()) {
                txt.append("\nName: ").append(name);
                txt.append(", Values: ").append(Arrays.toString(params.get(name)));
            }
            LOGGER.debug(txt.toString());
        }
        return params;
    }

    public void setParameter(String windowId, String name, String type, String[] values) {
        PublicRenderParameterMapper mapper = this.url.getPublicRenderParameterMapper();
        int index = mapper.getIndex(windowId, name);
        if (type.equals("rp") && index >= 0) {
            mapper.setValues(index, values);
        } else {
            PortalURLParameter pup = new PortalURLParameter(windowId, name, values, type);
            this.url.setParameter(pup);
        }
        if (isTrace) {
            StringBuilder txt = new StringBuilder("Set ");
            txt.append("name: ").append(name);
            txt.append(", type: ").append(type);
            txt.append(", PRP index: ").append(index);
            txt.append(", window ID: ").append(windowId);
            txt.append(", Values: ").append(Arrays.toString(values));
            LOGGER.debug(txt.toString());
        }
    }

    public void removeParameter(String windowId, String name, String type) {
        PublicRenderParameterMapper mapper = this.url.getPublicRenderParameterMapper();
        int index = mapper.getIndex(windowId, name);
        if (type.equals("rp") && index >= 0) {
            mapper.setRemoved(index, true);
        } else {
            PortalURLParameter pup = new PortalURLParameter(windowId, name, null, type);
            this.url.removeParameter(pup);
        }
        if (isTrace) {
            StringBuilder txt = new StringBuilder("Removed ");
            txt.append("name: ").append(name);
            txt.append(", type: ").append(type);
            txt.append(", PRP index: ").append(index);
            txt.append(", window ID: ").append(windowId);
            LOGGER.debug(txt.toString());
        }
    }

    public Set<String> getPublicParameterNames(String windowId) {
        HashSet<String> names = new HashSet<String>();
        PublicRenderParameterMapper mapper = this.url.getPublicRenderParameterMapper();
        List<PortalURLPublicParameter> prps = mapper.getPRPsForWindow(windowId, false);
        for (PortalURLPublicParameter prp : prps) {
            names.add(prp.getName());
        }
        if (isTrace) {
            LOGGER.debug("Public render parameter names: " + names.toString());
        }
        return names;
    }

    static {
        actionTypes.add(PortalURL.URLType.Action);
        actionTypes.add(PortalURL.URLType.AjaxAction);
        actionTypes.add(PortalURL.URLType.PartialAction);
        urlTypeMap = new HashMap();
        urlTypeMap.put(PortalURL.URLType.Action, "ap");
        urlTypeMap.put(PortalURL.URLType.Render, "rp");
        urlTypeMap.put(PortalURL.URLType.Resource, "re");
    }
}

