/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.portlet.servlet.adapter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import javax.portlet.ClientDataRequest;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import org.apache.pluto.portlet.servlet.adapter.HttpSessionAdapter;

public class HttpServletRequestAdapter
implements HttpServletRequest {
    private PortletRequest portletRequest;
    private ServletContext servletContext;

    public HttpServletRequestAdapter(PortletRequest portletRequest) {
        this.portletRequest = portletRequest;
    }

    public HttpServletRequestAdapter(PortletRequest portletRequest, ServletContext servletContext) {
        this.portletRequest = portletRequest;
        this.servletContext = servletContext;
    }

    public String getAuthType() {
        return this.portletRequest.getAuthType();
    }

    public Cookie[] getCookies() {
        return this.portletRequest.getCookies();
    }

    public long getDateHeader(String name) {
        return Long.valueOf(this.portletRequest.getProperty(name));
    }

    public String getHeader(String name) {
        return this.portletRequest.getProperty(name);
    }

    public Enumeration<String> getHeaders(String name) {
        return this.portletRequest.getProperties(name);
    }

    public Enumeration<String> getHeaderNames() {
        return this.portletRequest.getPropertyNames();
    }

    public int getIntHeader(String name) {
        return Integer.valueOf(this.getHeader(name));
    }

    public String getMethod() {
        if (this.portletRequest instanceof ClientDataRequest) {
            return ((ClientDataRequest)this.portletRequest).getMethod();
        }
        return "";
    }

    public String getPathInfo() {
        return "";
    }

    public String getPathTranslated() {
        return "";
    }

    public String getContextPath() {
        return this.portletRequest.getContextPath();
    }

    public String getQueryString() {
        return "";
    }

    public String getRemoteUser() {
        return this.portletRequest.getRemoteUser();
    }

    public boolean isUserInRole(String role) {
        return this.portletRequest.isUserInRole(role);
    }

    public Principal getUserPrincipal() {
        return this.portletRequest.getUserPrincipal();
    }

    public String getRequestedSessionId() {
        return this.portletRequest.getRequestedSessionId();
    }

    public String getRequestURI() {
        return "";
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer();
    }

    public String getServletPath() {
        return "";
    }

    public HttpSession getSession(boolean create) {
        PortletSession portletSession = this.portletRequest.getPortletSession(create);
        if (portletSession == null) {
            return null;
        }
        return new HttpSessionAdapter(portletSession);
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public String changeSessionId() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdValid() {
        return this.portletRequest.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public boolean authenticate(HttpServletResponse httpServletResponse) throws IOException, ServletException {
        return false;
    }

    public void login(String username, String password) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public void logout() throws ServletException {
        throw new UnsupportedOperationException();
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        if (this.portletRequest instanceof ClientDataRequest) {
            try {
                return ((ClientDataRequest)this.portletRequest).getParts();
            }
            catch (PortletException e) {
                throw new ServletException((Throwable)e);
            }
        }
        return null;
    }

    public Part getPart(String name) throws IOException, ServletException {
        if (this.portletRequest instanceof ClientDataRequest) {
            try {
                return ((ClientDataRequest)this.portletRequest).getPart(name);
            }
            catch (PortletException e) {
                throw new ServletException((Throwable)e);
            }
        }
        return null;
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> aClass) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public Object getAttribute(String name) {
        return this.portletRequest.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.portletRequest.getAttributeNames();
    }

    public String getCharacterEncoding() {
        if (this.portletRequest instanceof ClientDataRequest) {
            return ((ClientDataRequest)this.portletRequest).getCharacterEncoding();
        }
        return "";
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        if (this.portletRequest instanceof ClientDataRequest) {
            ((ClientDataRequest)this.portletRequest).setCharacterEncoding(encoding);
        }
    }

    public int getContentLength() {
        if (this.portletRequest instanceof ClientDataRequest) {
            return ((ClientDataRequest)this.portletRequest).getContentLength();
        }
        return 0;
    }

    public long getContentLengthLong() {
        if (this.portletRequest instanceof ClientDataRequest) {
            return ((ClientDataRequest)this.portletRequest).getContentLengthLong();
        }
        return 0L;
    }

    public String getContentType() {
        if (this.portletRequest instanceof ClientDataRequest) {
            return ((ClientDataRequest)this.portletRequest).getContentType();
        }
        return "";
    }

    public ServletInputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getParameter(String name) {
        return this.portletRequest.getParameter(name);
    }

    public Enumeration<String> getParameterNames() {
        return this.portletRequest.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        return this.portletRequest.getParameterValues(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.portletRequest.getParameterMap();
    }

    public String getProtocol() {
        return "";
    }

    public String getScheme() {
        return this.portletRequest.getScheme();
    }

    public String getServerName() {
        return this.portletRequest.getServerName();
    }

    public int getServerPort() {
        return this.portletRequest.getServerPort();
    }

    public BufferedReader getReader() throws IOException {
        if (this.portletRequest instanceof ClientDataRequest) {
            return ((ClientDataRequest)this.portletRequest).getReader();
        }
        throw new UnsupportedOperationException();
    }

    public String getRemoteAddr() {
        return "";
    }

    public String getRemoteHost() {
        return "";
    }

    public void setAttribute(String name, Object value) {
        this.portletRequest.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.portletRequest.removeAttribute(name);
    }

    public Locale getLocale() {
        return this.portletRequest.getLocale();
    }

    public Enumeration<Locale> getLocales() {
        return this.portletRequest.getLocales();
    }

    public boolean isSecure() {
        return this.portletRequest.isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw new UnsupportedOperationException();
    }

    public String getRealPath(String path) {
        return "";
    }

    public int getRemotePort() {
        throw new UnsupportedOperationException();
    }

    public String getLocalName() {
        return "";
    }

    public String getLocalAddr() {
        return "";
    }

    public int getLocalPort() {
        throw new UnsupportedOperationException();
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public boolean isAsyncStarted() {
        throw new UnsupportedOperationException();
    }

    public boolean isAsyncSupported() {
        throw new UnsupportedOperationException();
    }

    public AsyncContext getAsyncContext() {
        throw new UnsupportedOperationException();
    }

    public DispatcherType getDispatcherType() {
        throw new UnsupportedOperationException();
    }
}

