/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.portlet.servlet.adapter;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Locale;
import javax.portlet.ActionResponse;
import javax.portlet.MimeResponse;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceResponse;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class HttpServletResponseAdapter
implements HttpServletResponse {
    private PortletResponse portletResponse;

    public HttpServletResponseAdapter(PortletResponse portletResponse) {
        this.portletResponse = portletResponse;
    }

    public void addCookie(Cookie cookie) {
        this.portletResponse.addProperty(cookie);
    }

    public boolean containsHeader(String name) {
        return false;
    }

    public String encodeURL(String url) {
        return this.portletResponse.encodeURL(url);
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    public String encodeUrl(String url) {
        return this.portletResponse.encodeURL(url);
    }

    public String encodeRedirectUrl(String url) {
        return url;
    }

    public void sendError(int statusCode, String message) throws IOException {
        this.setStatus(statusCode, message);
    }

    public void sendError(int statusCode) throws IOException {
        this.setStatus(statusCode);
    }

    public void sendRedirect(String location) throws IOException {
        if (!(this.portletResponse instanceof ActionResponse)) {
            throw new UnsupportedOperationException();
        }
        ((ActionResponse)this.portletResponse).sendRedirect(location);
    }

    public void setDateHeader(String name, long date) {
        this.setHeader(name, Long.toString(date));
    }

    public void addDateHeader(String name, long date) {
        this.addHeader(name, Long.toString(date));
    }

    public void setHeader(String name, String value) {
        this.portletResponse.setProperty(name, value);
    }

    public void addHeader(String name, String value) {
        this.portletResponse.addProperty(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, Integer.toString(value));
    }

    public void addIntHeader(String name, int value) {
        this.addHeader(name, Integer.toString(value));
    }

    public void setStatus(int statusCode) {
        if (this.portletResponse instanceof ResourceResponse) {
            ((ResourceResponse)this.portletResponse).setStatus(statusCode);
        }
    }

    public void setStatus(int statusCode, String statusMessage) {
        if (this.portletResponse instanceof ResourceResponse) {
            ((ResourceResponse)this.portletResponse).setStatus(statusCode);
        }
    }

    public int getStatus() {
        if (this.portletResponse instanceof ResourceResponse) {
            return ((ResourceResponse)this.portletResponse).getStatus();
        }
        return 200;
    }

    public String getHeader(String name) {
        return this.portletResponse.getProperty(name);
    }

    public Collection<String> getHeaders(String name) {
        return this.portletResponse.getPropertyValues(name);
    }

    public Collection<String> getHeaderNames() {
        return this.portletResponse.getPropertyNames();
    }

    public String getCharacterEncoding() {
        if (this.portletResponse instanceof MimeResponse) {
            return ((MimeResponse)this.portletResponse).getCharacterEncoding();
        }
        return "UTF-8";
    }

    public String getContentType() {
        if (this.portletResponse instanceof MimeResponse) {
            return ((MimeResponse)this.portletResponse).getContentType();
        }
        return "";
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.portletResponse instanceof MimeResponse) {
            return new ServletOutputStreamAdapter(((MimeResponse)this.portletResponse).getPortletOutputStream());
        }
        throw new UnsupportedOperationException();
    }

    public PrintWriter getWriter() throws IOException {
        if (this.portletResponse instanceof MimeResponse) {
            return ((MimeResponse)this.portletResponse).getWriter();
        }
        throw new UnsupportedOperationException();
    }

    public void setCharacterEncoding(String charset) {
        if (this.portletResponse instanceof ResourceResponse) {
            ((ResourceResponse)this.portletResponse).setCharacterEncoding(charset);
        }
    }

    public void setContentLength(int length) {
        if (this.portletResponse instanceof ResourceResponse) {
            ((ResourceResponse)this.portletResponse).setContentLength(length);
        }
    }

    public void setContentLengthLong(long length) {
        if (this.portletResponse instanceof ResourceResponse) {
            ((ResourceResponse)this.portletResponse).setContentLengthLong(length);
        }
    }

    public void setContentType(String contentType) {
        if (this.portletResponse instanceof MimeResponse) {
            ((MimeResponse)this.portletResponse).setContentType(contentType);
        }
    }

    public void setBufferSize(int size) {
        if (this.portletResponse instanceof MimeResponse) {
            ((MimeResponse)this.portletResponse).setBufferSize(size);
        }
    }

    public int getBufferSize() {
        if (this.portletResponse instanceof MimeResponse) {
            return ((MimeResponse)this.portletResponse).getBufferSize();
        }
        return 0;
    }

    public void flushBuffer() throws IOException {
        if (!(this.portletResponse instanceof MimeResponse)) {
            throw new UnsupportedOperationException();
        }
        ((MimeResponse)this.portletResponse).flushBuffer();
    }

    public void resetBuffer() {
        if (!(this.portletResponse instanceof MimeResponse)) {
            throw new UnsupportedOperationException();
        }
        ((MimeResponse)this.portletResponse).resetBuffer();
    }

    public boolean isCommitted() {
        if (this.portletResponse instanceof MimeResponse) {
            return ((MimeResponse)this.portletResponse).isCommitted();
        }
        return false;
    }

    public void reset() {
        if (this.portletResponse instanceof MimeResponse) {
            ((MimeResponse)this.portletResponse).reset();
        }
    }

    public void setLocale(Locale locale) {
        if (this.portletResponse instanceof ResourceResponse) {
            ((ResourceResponse)this.portletResponse).setLocale(locale);
        }
    }

    public Locale getLocale() {
        if (this.portletResponse instanceof MimeResponse) {
            return ((MimeResponse)this.portletResponse).getLocale();
        }
        return null;
    }

    private static class ServletOutputStreamAdapter
    extends ServletOutputStream {
        private OutputStream portletOutputStream;

        public ServletOutputStreamAdapter(OutputStream portletOutputStream) {
            this.portletOutputStream = portletOutputStream;
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
        }

        public void write(int b) throws IOException {
            this.portletOutputStream.write(b);
        }
    }
}

