/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.impl.ManagedCursorImpl;
import org.apache.pulsar.common.util.collections.LongPairRangeSet;
import org.apache.pulsar.common.util.collections.OpenLongPairRangeSet;
import org.roaringbitmap.RoaringBitSet;

public class RangeSetWrapper<T extends Comparable<T>>
implements LongPairRangeSet<T> {
    private final LongPairRangeSet<T> rangeSet;
    private final LongPairRangeSet.LongPairConsumer<T> rangeConverter;
    private final ManagedLedgerConfig config;
    private final boolean enableMultiEntry;
    private final LongPairRangeSet.DefaultRangeSet<Long> dirtyLedgers = new LongPairRangeSet.DefaultRangeSet((key, value) -> key, key -> new LongPairRangeSet.LongPair(key.longValue(), 0L));

    public RangeSetWrapper(LongPairRangeSet.LongPairConsumer<T> rangeConverter, LongPairRangeSet.RangeBoundConsumer<T> rangeBoundConsumer, ManagedCursorImpl managedCursor) {
        Objects.requireNonNull(managedCursor);
        this.config = managedCursor.getManagedLedger().getConfig();
        this.rangeConverter = rangeConverter;
        this.rangeSet = this.config.isUnackedRangesOpenCacheSetEnabled() ? new OpenLongPairRangeSet(rangeConverter, RoaringBitSet::new) : new LongPairRangeSet.DefaultRangeSet(rangeConverter, rangeBoundConsumer);
        this.enableMultiEntry = this.config.isPersistentUnackedRangesWithMultipleEntriesEnabled();
    }

    public void addOpenClosed(long lowerKey, long lowerValue, long upperKey, long upperValue) {
        if (this.enableMultiEntry) {
            this.dirtyLedgers.addOpenClosed(lowerKey, 0L, upperKey, 0L);
        }
        this.rangeSet.addOpenClosed(lowerKey, lowerValue, upperKey, upperValue);
    }

    public boolean contains(long key, long value) {
        return this.rangeSet.contains(key, value);
    }

    public Range<T> rangeContaining(long key, long value) {
        return this.rangeSet.rangeContaining(key, value);
    }

    public void removeAtMost(long key, long value) {
        if (this.enableMultiEntry) {
            this.dirtyLedgers.removeAtMost(key, 0L);
        }
        this.rangeSet.removeAtMost(key, value);
    }

    public boolean isEmpty() {
        return this.rangeSet.isEmpty();
    }

    public void clear() {
        this.rangeSet.clear();
        this.dirtyLedgers.clear();
    }

    public Range<T> span() {
        return this.rangeSet.span();
    }

    public Collection<Range<T>> asRanges() {
        Collection collection = this.rangeSet.asRanges();
        if (collection instanceof List) {
            return collection;
        }
        return new ArrayList<Range<T>>(collection);
    }

    public void forEach(LongPairRangeSet.RangeProcessor<T> action) {
        this.rangeSet.forEach(action);
    }

    public void forEach(LongPairRangeSet.RangeProcessor<T> action, LongPairRangeSet.LongPairConsumer<? extends T> consumer) {
        this.rangeSet.forEach(action, consumer);
    }

    public void forEachRawRange(LongPairRangeSet.RawRangeProcessor action) {
        this.rangeSet.forEachRawRange(action);
    }

    public int size() {
        return this.rangeSet.size();
    }

    public Range<T> firstRange() {
        return this.rangeSet.firstRange();
    }

    public Range<T> lastRange() {
        return this.rangeSet.lastRange();
    }

    public int cardinality(long lowerKey, long lowerValue, long upperKey, long upperValue) {
        return this.rangeSet.cardinality(lowerKey, lowerValue, upperKey, upperValue);
    }

    @VisibleForTesting
    void add(Range<LongPairRangeSet.LongPair> range) {
        if (!(this.rangeSet instanceof OpenLongPairRangeSet)) {
            throw new UnsupportedOperationException("Only ConcurrentOpenLongPairRangeSet support this method");
        }
        ((OpenLongPairRangeSet)this.rangeSet).add(range);
    }

    @VisibleForTesting
    void remove(Range<T> range) {
        if (this.rangeSet instanceof OpenLongPairRangeSet) {
            ((OpenLongPairRangeSet)this.rangeSet).remove(range);
        } else {
            ((LongPairRangeSet.DefaultRangeSet)this.rangeSet).remove(range);
        }
    }

    public void resetDirtyKeys() {
        this.dirtyLedgers.clear();
    }

    public boolean isDirtyLedgers(long ledgerId) {
        return this.dirtyLedgers.contains((Comparable)Long.valueOf(ledgerId));
    }

    public String toString() {
        return this.rangeSet.toString();
    }
}

