/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authentication;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.yahoo.athenz.auth.token.RoleToken;
import com.yahoo.athenz.zpe.AuthZpeClient;
import java.io.IOException;
import java.net.SocketAddress;
import java.security.PublicKey;
import java.util.List;
import javax.naming.AuthenticationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authentication.AuthenticationProvider;
import org.apache.pulsar.broker.authentication.metrics.AuthenticationMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationProviderAthenz
implements AuthenticationProvider {
    private static final String DOMAIN_NAME_LIST = "athenzDomainNames";
    private static final String SYS_PROP_DOMAIN_NAME_LIST = "pulsar.athenz.domain.names";
    private static final String SYS_PROP_ALLOWED_OFFSET = "pulsar.athenz.role.token_allowed_offset";
    private List<String> domainNameList = null;
    private int allowedOffset = 30;
    private static final Logger log = LoggerFactory.getLogger(AuthenticationProviderAthenz.class);

    public void initialize(ServiceConfiguration config) throws IOException {
        String domainNames;
        if (config.getProperty(DOMAIN_NAME_LIST) != null) {
            domainNames = (String)config.getProperty(DOMAIN_NAME_LIST);
        } else if (!StringUtils.isEmpty((CharSequence)System.getProperty(SYS_PROP_DOMAIN_NAME_LIST))) {
            domainNames = System.getProperty(SYS_PROP_DOMAIN_NAME_LIST);
        } else {
            throw new IOException("No athenz domain name specified");
        }
        this.domainNameList = Lists.newArrayList((Object[])domainNames.split(","));
        log.info("Supported domain names for athenz: {}", this.domainNameList);
        if (!StringUtils.isEmpty((CharSequence)System.getProperty(SYS_PROP_ALLOWED_OFFSET))) {
            try {
                this.allowedOffset = Integer.parseInt(System.getProperty(SYS_PROP_ALLOWED_OFFSET));
            }
            catch (NumberFormatException e) {
                throw new IOException("Invalid allowed offset for athenz role token verification specified", e);
            }
            if (this.allowedOffset < 0) {
                throw new IOException("Allowed offset for athenz role token verification must not be negative");
            }
        }
        log.info("Allowed offset for athenz role token verification: {} sec", (Object)this.allowedOffset);
    }

    public String getAuthMethodName() {
        return "athenz";
    }

    public String authenticate(AuthenticationDataSource authData) throws AuthenticationException {
        ErrorCode errorCode = ErrorCode.UNKNOWN;
        try {
            RoleToken token;
            String roleToken;
            if (!authData.hasDataFromPeer()) {
                errorCode = ErrorCode.NO_CLIENT;
                throw new AuthenticationException("Authentication data source does not have a client address");
            }
            SocketAddress clientAddress = authData.getPeerAddress();
            if (authData.hasDataFromCommand()) {
                roleToken = authData.getCommandData();
            } else if (authData.hasDataFromHttp()) {
                roleToken = authData.getHttpHeader(AuthZpeClient.ZPE_TOKEN_HDR);
            } else {
                errorCode = ErrorCode.NO_TOKEN;
                throw new AuthenticationException("Authentication data source does not have a role token");
            }
            if (roleToken == null) {
                errorCode = ErrorCode.NO_TOKEN;
                throw new AuthenticationException("Athenz token is null, can't authenticate");
            }
            if (roleToken.isEmpty()) {
                errorCode = ErrorCode.NO_TOKEN;
                throw new AuthenticationException("Athenz RoleToken is empty, Server is Using Athenz Authentication");
            }
            if (log.isDebugEnabled()) {
                log.debug("Athenz RoleToken : [{}] received from Client: {}", (Object)roleToken, (Object)clientAddress);
            }
            if (!this.domainNameList.contains((token = new RoleToken(roleToken)).getDomain())) {
                errorCode = ErrorCode.DOMAIN_MISMATCH;
                throw new AuthenticationException(String.format("Athenz RoleToken Domain mismatch, Expected: %s, Found: %s", this.domainNameList.toString(), token.getDomain()));
            }
            AuthenticationProviderAthenz authenticationProviderAthenz = this;
            synchronized (authenticationProviderAthenz) {
                PublicKey ztsPublicKey = AuthZpeClient.getZtsPublicKey((String)token.getKeyId());
                if (ztsPublicKey == null) {
                    errorCode = ErrorCode.NO_PUBLIC_KEY;
                    throw new AuthenticationException("Unable to retrieve ZTS Public Key");
                }
                if (token.validate(ztsPublicKey, this.allowedOffset, false, null)) {
                    log.debug("Athenz Role Token : {}, Authenticated for Client: {}", (Object)roleToken, (Object)clientAddress);
                    AuthenticationMetrics.authenticateSuccess((String)this.getClass().getSimpleName(), (String)this.getAuthMethodName());
                    return token.getPrincipal();
                }
                errorCode = ErrorCode.INVALID_TOKEN;
                throw new AuthenticationException(String.format("Athenz Role Token Not Authenticated from Client: %s", clientAddress));
            }
        }
        catch (AuthenticationException exception) {
            this.incrementFailureMetric(errorCode);
            throw exception;
        }
    }

    public void close() throws IOException {
    }

    @VisibleForTesting
    int getAllowedOffset() {
        return this.allowedOffset;
    }

    public static enum ErrorCode {
        UNKNOWN,
        NO_CLIENT,
        NO_TOKEN,
        NO_PUBLIC_KEY,
        DOMAIN_MISMATCH,
        INVALID_TOKEN;

    }
}

