/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.resources;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.pulsar.broker.resources.BaseResources;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.policies.data.ResourceQuota;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.policies.data.loadbalancer.BundleData;
import org.apache.pulsar.policies.data.loadbalancer.TimeAverageBrokerData;

public class LoadBalanceResources {
    public static final String BUNDLE_DATA_BASE_PATH = "/loadbalance/bundle-data";
    public static final String BROKER_TIME_AVERAGE_BASE_PATH = "/loadbalance/broker-time-average";
    public static final String RESOURCE_QUOTA_BASE_PATH = "/loadbalance/resource-quota";
    private final BundleDataResources bundleDataResources;
    private final BrokerTimeAverageDataResources brokerTimeAverageDataResources;
    private final QuotaResources quotaResources;

    public LoadBalanceResources(MetadataStore store, int operationTimeoutSec) {
        this.bundleDataResources = new BundleDataResources(store, operationTimeoutSec);
        this.brokerTimeAverageDataResources = new BrokerTimeAverageDataResources(store, operationTimeoutSec);
        this.quotaResources = new QuotaResources(store, operationTimeoutSec);
    }

    @Generated
    public BundleDataResources getBundleDataResources() {
        return this.bundleDataResources;
    }

    @Generated
    public BrokerTimeAverageDataResources getBrokerTimeAverageDataResources() {
        return this.brokerTimeAverageDataResources;
    }

    @Generated
    public QuotaResources getQuotaResources() {
        return this.quotaResources;
    }

    public static class BundleDataResources
    extends BaseResources<BundleData> {
        public BundleDataResources(MetadataStore store, int operationTimeoutSec) {
            super(store, BundleData.class, operationTimeoutSec);
        }

        public CompletableFuture<Optional<BundleData>> getBundleData(String bundle) {
            return this.getAsync(this.getBundleDataPath(bundle));
        }

        public CompletableFuture<Void> updateBundleData(String bundle, BundleData data) {
            return this.setWithCreateAsync(this.getBundleDataPath(bundle), __ -> data);
        }

        public CompletableFuture<Void> deleteBundleData(String bundle) {
            return this.deleteAsync(this.getBundleDataPath(bundle));
        }

        public CompletableFuture<Void> deleteBundleDataAsync(NamespaceName ns) {
            String namespaceBundlePath = BundleDataResources.joinPath(LoadBalanceResources.BUNDLE_DATA_BASE_PATH, ns.toString());
            return this.getStore().deleteRecursive(namespaceBundlePath);
        }

        public CompletableFuture<Void> deleteBundleDataTenantAsync(String tenant) {
            String tenantBundlePath = BundleDataResources.joinPath(LoadBalanceResources.BUNDLE_DATA_BASE_PATH, tenant);
            return this.getStore().deleteRecursive(tenantBundlePath);
        }

        private String getBundleDataPath(String bundle) {
            return "/loadbalance/bundle-data/" + bundle;
        }
    }

    public static class BrokerTimeAverageDataResources
    extends BaseResources<TimeAverageBrokerData> {
        public BrokerTimeAverageDataResources(MetadataStore store, int operationTimeoutSec) {
            super(store, TimeAverageBrokerData.class, operationTimeoutSec);
        }

        public CompletableFuture<Void> updateTimeAverageBrokerData(String brokerLookupAddress, TimeAverageBrokerData data) {
            return this.setWithCreateAsync(this.getTimeAverageBrokerDataPath(brokerLookupAddress), __ -> data);
        }

        public CompletableFuture<Void> deleteTimeAverageBrokerData(String brokerLookupAddress) {
            return this.deleteAsync(this.getTimeAverageBrokerDataPath(brokerLookupAddress));
        }

        private String getTimeAverageBrokerDataPath(String brokerLookupAddress) {
            return "/loadbalance/broker-time-average/" + brokerLookupAddress;
        }
    }

    public static class QuotaResources
    extends BaseResources<ResourceQuota> {
        public QuotaResources(MetadataStore store, int operationTimeoutSec) {
            super(store, ResourceQuota.class, operationTimeoutSec);
        }

        public CompletableFuture<Optional<ResourceQuota>> getQuota(String bundle) {
            return this.getAsync(this.getBundleQuotaPath(bundle));
        }

        public CompletableFuture<Optional<ResourceQuota>> getDefaultQuota() {
            return this.getAsync(this.getDefaultBundleQuotaPath());
        }

        public CompletableFuture<Void> setWithCreateQuotaAsync(String bundle, ResourceQuota quota) {
            return this.setWithCreateAsync(this.getBundleQuotaPath(bundle), __ -> quota);
        }

        public CompletableFuture<Void> setWithCreateDefaultQuotaAsync(ResourceQuota quota) {
            return this.setWithCreateAsync(this.getDefaultBundleQuotaPath(), __ -> quota);
        }

        public CompletableFuture<Void> deleteQuota(String bundle) {
            return this.deleteAsync(this.getBundleQuotaPath(bundle));
        }

        private String getBundleQuotaPath(String bundle) {
            return String.format("%s/%s", LoadBalanceResources.RESOURCE_QUOTA_BASE_PATH, bundle);
        }

        private String getDefaultBundleQuotaPath() {
            return this.getBundleQuotaPath("default");
        }
    }
}

