/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.qos;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.LongAdder;
import org.apache.pulsar.broker.qos.DynamicRateAsyncTokenBucketBuilder;
import org.apache.pulsar.broker.qos.FinalRateAsyncTokenBucketBuilder;
import org.apache.pulsar.broker.qos.MonotonicSnapshotClock;

public abstract class AsyncTokenBucket {
    public static final MonotonicSnapshotClock DEFAULT_SNAPSHOT_CLOCK = requestSnapshot -> System.nanoTime();
    static final long ONE_SECOND_NANOS = TimeUnit.SECONDS.toNanos(1L);
    private static final long DEFAULT_RESOLUTION_NANOS;
    static long defaultResolutionNanos;
    private static final AtomicLongFieldUpdater<AsyncTokenBucket> LAST_NANOS_UPDATER;
    private static final AtomicLongFieldUpdater<AsyncTokenBucket> LAST_INCREMENT_UPDATER;
    private static final AtomicLongFieldUpdater<AsyncTokenBucket> TOKENS_UPDATER;
    private static final AtomicLongFieldUpdater<AsyncTokenBucket> REMAINDER_NANOS_UPDATER;
    protected volatile long tokens;
    private volatile long lastNanos;
    private volatile long lastIncrement;
    private volatile long remainderNanos;
    protected final long resolutionNanos;
    private final MonotonicSnapshotClock clockSource;
    private final LongAdder pendingConsumedTokens = new LongAdder();

    public static void switchToConsistentTokensView() {
        defaultResolutionNanos = 0L;
    }

    public static void resetToDefaultEventualConsistentTokensView() {
        defaultResolutionNanos = DEFAULT_RESOLUTION_NANOS;
    }

    protected AsyncTokenBucket(MonotonicSnapshotClock clockSource, long resolutionNanos) {
        this.clockSource = clockSource;
        this.resolutionNanos = resolutionNanos;
    }

    public static FinalRateAsyncTokenBucketBuilder builder() {
        return new FinalRateAsyncTokenBucketBuilder();
    }

    public static DynamicRateAsyncTokenBucketBuilder builderForDynamicRate() {
        return new DynamicRateAsyncTokenBucketBuilder();
    }

    protected abstract long getRatePeriodNanos();

    protected abstract long getTargetAmountOfTokensAfterThrottling();

    private long consumeTokensAndMaybeUpdateTokensBalance(long consumeTokens, boolean forceUpdateTokens) {
        if (consumeTokens < 0L) {
            throw new IllegalArgumentException("consumeTokens must be >= 0");
        }
        long currentNanos = this.clockSource.getTickNanos(forceUpdateTokens);
        if (this.shouldUpdateTokensImmediately(currentNanos, forceUpdateTokens)) {
            long newTokens = this.calculateNewTokensSinceLastUpdate(currentNanos);
            long totalConsumedTokens = consumeTokens + this.pendingConsumedTokens.sumThenReset();
            return TOKENS_UPDATER.updateAndGet(this, currentTokens -> Math.min(currentTokens + newTokens, this.getCapacity()) - totalConsumedTokens);
        }
        if (consumeTokens > 0L) {
            this.pendingConsumedTokens.add(consumeTokens);
        }
        return Long.MIN_VALUE;
    }

    private boolean shouldUpdateTokensImmediately(long currentNanos, boolean forceUpdateTokens) {
        long currentIncrement = this.resolutionNanos != 0L ? currentNanos / this.resolutionNanos : 0L;
        long currentLastIncrement = this.lastIncrement;
        return currentIncrement == 0L || currentIncrement > currentLastIncrement && LAST_INCREMENT_UPDATER.compareAndSet(this, currentLastIncrement, currentIncrement) || forceUpdateTokens;
    }

    private long calculateNewTokensSinceLastUpdate(long currentNanos) {
        long newTokens;
        long previousLastNanos = LAST_NANOS_UPDATER.getAndSet(this, currentNanos);
        if (previousLastNanos == 0L) {
            newTokens = 0L;
        } else {
            long currentRatePeriodNanos;
            long currentRate;
            long durationNanos = currentNanos - previousLastNanos + REMAINDER_NANOS_UPDATER.getAndSet(this, 0L);
            long remainderNanos = durationNanos - (newTokens = durationNanos * (currentRate = this.getRate()) / (currentRatePeriodNanos = this.getRatePeriodNanos())) * currentRatePeriodNanos / currentRate;
            if (remainderNanos > 0L) {
                REMAINDER_NANOS_UPDATER.addAndGet(this, remainderNanos);
            }
        }
        return newTokens;
    }

    public void consumeTokens(long consumeTokens) {
        this.consumeTokensAndMaybeUpdateTokensBalance(consumeTokens, false);
    }

    public boolean consumeTokensAndCheckIfContainsTokens(long consumeTokens) {
        long currentTokens = this.consumeTokensAndMaybeUpdateTokensBalance(consumeTokens, false);
        if (currentTokens > 0L) {
            return true;
        }
        if (currentTokens == Long.MIN_VALUE) {
            return this.tokens - consumeTokens > 0L;
        }
        return false;
    }

    protected long tokens(boolean forceUpdateTokens) {
        long currentTokens = this.consumeTokensAndMaybeUpdateTokensBalance(0L, forceUpdateTokens);
        if (currentTokens != Long.MIN_VALUE) {
            return currentTokens;
        }
        return this.tokens;
    }

    public long calculateThrottlingDuration() {
        long currentTokens = this.consumeTokensAndMaybeUpdateTokensBalance(0L, true);
        if (currentTokens == Long.MIN_VALUE) {
            throw new IllegalArgumentException("Unexpected result from updateAndConsumeTokens with forceUpdateTokens set to true");
        }
        if (currentTokens > 0L) {
            return 0L;
        }
        long needTokens = this.getTargetAmountOfTokensAfterThrottling() - currentTokens;
        return needTokens * this.getRatePeriodNanos() / this.getRate();
    }

    public abstract long getCapacity();

    public final long getTokens() {
        return this.tokens(false);
    }

    public abstract long getRate();

    public boolean containsTokens() {
        return this.containsTokens(false);
    }

    public boolean containsTokens(boolean forceUpdateTokens) {
        return this.tokens(forceUpdateTokens) > 0L;
    }

    static {
        defaultResolutionNanos = DEFAULT_RESOLUTION_NANOS = TimeUnit.MILLISECONDS.toNanos(16L);
        LAST_NANOS_UPDATER = AtomicLongFieldUpdater.newUpdater(AsyncTokenBucket.class, "lastNanos");
        LAST_INCREMENT_UPDATER = AtomicLongFieldUpdater.newUpdater(AsyncTokenBucket.class, "lastIncrement");
        TOKENS_UPDATER = AtomicLongFieldUpdater.newUpdater(AsyncTokenBucket.class, "tokens");
        REMAINDER_NANOS_UPDATER = AtomicLongFieldUpdater.newUpdater(AsyncTokenBucket.class, "remainderNanos");
    }
}

