/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.api.proto;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pulsar.common.api.proto.KeyValue;
import org.apache.pulsar.common.api.proto.LightProtoCodec;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;

public final class SingleMessageMetadata {
    private List<KeyValue> properties = null;
    private int _propertiesCount = 0;
    private static final int _PROPERTIES_FIELD_NUMBER = 1;
    private static final int _PROPERTIES_TAG = 10;
    private static final int _PROPERTIES_TAG_SIZE = LightProtoCodec.computeVarIntSize(10);
    private String partitionKey;
    private int _partitionKeyBufferIdx = -1;
    private int _partitionKeyBufferLen = -1;
    private static final int _PARTITION_KEY_FIELD_NUMBER = 2;
    private static final int _PARTITION_KEY_TAG = 18;
    private static final int _PARTITION_KEY_TAG_SIZE = LightProtoCodec.computeVarIntSize(18);
    private static final int _PARTITION_KEY_MASK = 2;
    private int payloadSize;
    private static final int _PAYLOAD_SIZE_FIELD_NUMBER = 3;
    private static final int _PAYLOAD_SIZE_TAG = 24;
    private static final int _PAYLOAD_SIZE_TAG_SIZE = LightProtoCodec.computeVarIntSize(24);
    private static final int _PAYLOAD_SIZE_MASK = 4;
    private boolean compactedOut = false;
    private static final int _COMPACTED_OUT_FIELD_NUMBER = 4;
    private static final int _COMPACTED_OUT_TAG = 32;
    private static final int _COMPACTED_OUT_TAG_SIZE = LightProtoCodec.computeVarIntSize(32);
    private static final int _COMPACTED_OUT_MASK = 8;
    private long eventTime = 0L;
    private static final int _EVENT_TIME_FIELD_NUMBER = 5;
    private static final int _EVENT_TIME_TAG = 40;
    private static final int _EVENT_TIME_TAG_SIZE = LightProtoCodec.computeVarIntSize(40);
    private static final int _EVENT_TIME_MASK = 16;
    private boolean partitionKeyB64Encoded = false;
    private static final int _PARTITION_KEY_B64_ENCODED_FIELD_NUMBER = 6;
    private static final int _PARTITION_KEY_B64_ENCODED_TAG = 48;
    private static final int _PARTITION_KEY_B64_ENCODED_TAG_SIZE = LightProtoCodec.computeVarIntSize(48);
    private static final int _PARTITION_KEY_B64_ENCODED_MASK = 32;
    private ByteBuf orderingKey = null;
    private int _orderingKeyIdx = -1;
    private int _orderingKeyLen = -1;
    private static final int _ORDERING_KEY_FIELD_NUMBER = 7;
    private static final int _ORDERING_KEY_TAG = 58;
    private static final int _ORDERING_KEY_TAG_SIZE = LightProtoCodec.computeVarIntSize(58);
    private static final int _ORDERING_KEY_MASK = 64;
    private long sequenceId;
    private static final int _SEQUENCE_ID_FIELD_NUMBER = 8;
    private static final int _SEQUENCE_ID_TAG = 64;
    private static final int _SEQUENCE_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(64);
    private static final int _SEQUENCE_ID_MASK = 128;
    private boolean nullValue = false;
    private static final int _NULL_VALUE_FIELD_NUMBER = 9;
    private static final int _NULL_VALUE_TAG = 72;
    private static final int _NULL_VALUE_TAG_SIZE = LightProtoCodec.computeVarIntSize(72);
    private static final int _NULL_VALUE_MASK = 256;
    private boolean nullPartitionKey = false;
    private static final int _NULL_PARTITION_KEY_FIELD_NUMBER = 10;
    private static final int _NULL_PARTITION_KEY_TAG = 80;
    private static final int _NULL_PARTITION_KEY_TAG_SIZE = LightProtoCodec.computeVarIntSize(80);
    private static final int _NULL_PARTITION_KEY_MASK = 512;
    private int _bitField0;
    private static final int _REQUIRED_FIELDS_MASK0 = 4;
    private int _cachedSize;
    private ByteBuf _parsedBuffer;

    public int getPropertiesCount() {
        return this._propertiesCount;
    }

    public KeyValue getPropertyAt(int idx) {
        if (idx < 0 || idx >= this._propertiesCount) {
            throw new IndexOutOfBoundsException("Index " + idx + " is out of the list size (" + this._propertiesCount + ") for field 'properties'");
        }
        return this.properties.get(idx);
    }

    public List<KeyValue> getPropertiesList() {
        if (this._propertiesCount == 0) {
            return Collections.emptyList();
        }
        return this.properties.subList(0, this._propertiesCount);
    }

    public KeyValue addProperty() {
        if (this.properties == null) {
            this.properties = new ArrayList<KeyValue>();
        }
        if (this.properties.size() == this._propertiesCount) {
            this.properties.add(new KeyValue());
        }
        this._cachedSize = -1;
        return this.properties.get(this._propertiesCount++);
    }

    public SingleMessageMetadata addAllProperties(Iterable<KeyValue> properties) {
        for (KeyValue _o : properties) {
            this.addProperty().copyFrom(_o);
        }
        return this;
    }

    public SingleMessageMetadata clearProperties() {
        for (int i = 0; i < this._propertiesCount; ++i) {
            this.properties.get(i).clear();
        }
        this._propertiesCount = 0;
        return this;
    }

    public boolean hasPartitionKey() {
        return (this._bitField0 & 2) != 0;
    }

    public String getPartitionKey() {
        if (!this.hasPartitionKey()) {
            throw new IllegalStateException("Field 'partition_key' is not set");
        }
        if (this.partitionKey == null) {
            this.partitionKey = LightProtoCodec.readString(this._parsedBuffer, this._partitionKeyBufferIdx, this._partitionKeyBufferLen);
        }
        return this.partitionKey;
    }

    public SingleMessageMetadata setPartitionKey(String partitionKey) {
        this.partitionKey = partitionKey;
        this._bitField0 |= 2;
        this._partitionKeyBufferIdx = -1;
        this._partitionKeyBufferLen = LightProtoCodec.computeStringUTF8Size(partitionKey);
        this._cachedSize = -1;
        return this;
    }

    public SingleMessageMetadata clearPartitionKey() {
        this._bitField0 &= 0xFFFFFFFD;
        this.partitionKey = null;
        this._partitionKeyBufferIdx = -1;
        this._partitionKeyBufferLen = -1;
        return this;
    }

    public boolean hasPayloadSize() {
        return (this._bitField0 & 4) != 0;
    }

    public int getPayloadSize() {
        if (!this.hasPayloadSize()) {
            throw new IllegalStateException("Field 'payload_size' is not set");
        }
        return this.payloadSize;
    }

    public SingleMessageMetadata setPayloadSize(int payloadSize) {
        this.payloadSize = payloadSize;
        this._bitField0 |= 4;
        this._cachedSize = -1;
        return this;
    }

    public SingleMessageMetadata clearPayloadSize() {
        this._bitField0 &= 0xFFFFFFFB;
        return this;
    }

    public boolean hasCompactedOut() {
        return (this._bitField0 & 8) != 0;
    }

    public boolean isCompactedOut() {
        return this.compactedOut;
    }

    public SingleMessageMetadata setCompactedOut(boolean compactedOut) {
        this.compactedOut = compactedOut;
        this._bitField0 |= 8;
        this._cachedSize = -1;
        return this;
    }

    public SingleMessageMetadata clearCompactedOut() {
        this._bitField0 &= 0xFFFFFFF7;
        this.compactedOut = false;
        return this;
    }

    public boolean hasEventTime() {
        return (this._bitField0 & 0x10) != 0;
    }

    public long getEventTime() {
        return this.eventTime;
    }

    public SingleMessageMetadata setEventTime(long eventTime) {
        this.eventTime = eventTime;
        this._bitField0 |= 0x10;
        this._cachedSize = -1;
        return this;
    }

    public SingleMessageMetadata clearEventTime() {
        this._bitField0 &= 0xFFFFFFEF;
        this.eventTime = 0L;
        return this;
    }

    public boolean hasPartitionKeyB64Encoded() {
        return (this._bitField0 & 0x20) != 0;
    }

    public boolean isPartitionKeyB64Encoded() {
        return this.partitionKeyB64Encoded;
    }

    public SingleMessageMetadata setPartitionKeyB64Encoded(boolean partitionKeyB64Encoded) {
        this.partitionKeyB64Encoded = partitionKeyB64Encoded;
        this._bitField0 |= 0x20;
        this._cachedSize = -1;
        return this;
    }

    public SingleMessageMetadata clearPartitionKeyB64Encoded() {
        this._bitField0 &= 0xFFFFFFDF;
        this.partitionKeyB64Encoded = false;
        return this;
    }

    public boolean hasOrderingKey() {
        return (this._bitField0 & 0x40) != 0;
    }

    public int getOrderingKeySize() {
        if (!this.hasOrderingKey()) {
            throw new IllegalStateException("Field 'ordering_key' is not set");
        }
        return this._orderingKeyLen;
    }

    public byte[] getOrderingKey() {
        ByteBuf _b = this.getOrderingKeySlice();
        byte[] res = new byte[_b.readableBytes()];
        _b.getBytes(0, res);
        return res;
    }

    public ByteBuf getOrderingKeySlice() {
        if (!this.hasOrderingKey()) {
            throw new IllegalStateException("Field 'ordering_key' is not set");
        }
        if (this.orderingKey == null) {
            return this._parsedBuffer.slice(this._orderingKeyIdx, this._orderingKeyLen);
        }
        return this.orderingKey.slice(0, this._orderingKeyLen);
    }

    public SingleMessageMetadata setOrderingKey(byte[] orderingKey) {
        this.setOrderingKey(Unpooled.wrappedBuffer(orderingKey));
        return this;
    }

    public SingleMessageMetadata setOrderingKey(ByteBuf orderingKey) {
        this.orderingKey = orderingKey;
        this._bitField0 |= 0x40;
        this._orderingKeyIdx = -1;
        this._orderingKeyLen = orderingKey.readableBytes();
        this._cachedSize = -1;
        return this;
    }

    public SingleMessageMetadata clearOrderingKey() {
        this._bitField0 &= 0xFFFFFFBF;
        this.orderingKey = null;
        this._orderingKeyIdx = -1;
        this._orderingKeyLen = -1;
        return this;
    }

    public boolean hasSequenceId() {
        return (this._bitField0 & 0x80) != 0;
    }

    public long getSequenceId() {
        if (!this.hasSequenceId()) {
            throw new IllegalStateException("Field 'sequence_id' is not set");
        }
        return this.sequenceId;
    }

    public SingleMessageMetadata setSequenceId(long sequenceId) {
        this.sequenceId = sequenceId;
        this._bitField0 |= 0x80;
        this._cachedSize = -1;
        return this;
    }

    public SingleMessageMetadata clearSequenceId() {
        this._bitField0 &= 0xFFFFFF7F;
        return this;
    }

    public boolean hasNullValue() {
        return (this._bitField0 & 0x100) != 0;
    }

    public boolean isNullValue() {
        return this.nullValue;
    }

    public SingleMessageMetadata setNullValue(boolean nullValue) {
        this.nullValue = nullValue;
        this._bitField0 |= 0x100;
        this._cachedSize = -1;
        return this;
    }

    public SingleMessageMetadata clearNullValue() {
        this._bitField0 &= 0xFFFFFEFF;
        this.nullValue = false;
        return this;
    }

    public boolean hasNullPartitionKey() {
        return (this._bitField0 & 0x200) != 0;
    }

    public boolean isNullPartitionKey() {
        return this.nullPartitionKey;
    }

    public SingleMessageMetadata setNullPartitionKey(boolean nullPartitionKey) {
        this.nullPartitionKey = nullPartitionKey;
        this._bitField0 |= 0x200;
        this._cachedSize = -1;
        return this;
    }

    public SingleMessageMetadata clearNullPartitionKey() {
        this._bitField0 &= 0xFFFFFDFF;
        this.nullPartitionKey = false;
        return this;
    }

    public int writeTo(ByteBuf _b) {
        this.checkRequiredFields();
        int _writeIdx = _b.writerIndex();
        for (int i = 0; i < this._propertiesCount; ++i) {
            KeyValue _item = this.properties.get(i);
            LightProtoCodec.writeVarInt(_b, 10);
            LightProtoCodec.writeVarInt(_b, _item.getSerializedSize());
            _item.writeTo(_b);
        }
        if (this.hasPartitionKey()) {
            LightProtoCodec.writeVarInt(_b, 18);
            LightProtoCodec.writeVarInt(_b, this._partitionKeyBufferLen);
            if (this._partitionKeyBufferIdx == -1) {
                LightProtoCodec.writeString(_b, this.partitionKey, this._partitionKeyBufferLen);
            } else {
                this._parsedBuffer.getBytes(this._partitionKeyBufferIdx, _b, this._partitionKeyBufferLen);
            }
        }
        LightProtoCodec.writeVarInt(_b, 24);
        LightProtoCodec.writeVarInt(_b, this.payloadSize);
        if (this.hasCompactedOut()) {
            LightProtoCodec.writeVarInt(_b, 32);
            _b.writeBoolean(this.compactedOut);
        }
        if (this.hasEventTime()) {
            LightProtoCodec.writeVarInt(_b, 40);
            LightProtoCodec.writeVarInt64(_b, this.eventTime);
        }
        if (this.hasPartitionKeyB64Encoded()) {
            LightProtoCodec.writeVarInt(_b, 48);
            _b.writeBoolean(this.partitionKeyB64Encoded);
        }
        if (this.hasOrderingKey()) {
            LightProtoCodec.writeVarInt(_b, 58);
            LightProtoCodec.writeVarInt(_b, this._orderingKeyLen);
            if (this._orderingKeyIdx == -1) {
                _b.writeBytes(this.orderingKey);
            } else {
                this._parsedBuffer.getBytes(this._orderingKeyIdx, _b, this._orderingKeyLen);
            }
        }
        if (this.hasSequenceId()) {
            LightProtoCodec.writeVarInt(_b, 64);
            LightProtoCodec.writeVarInt64(_b, this.sequenceId);
        }
        if (this.hasNullValue()) {
            LightProtoCodec.writeVarInt(_b, 72);
            _b.writeBoolean(this.nullValue);
        }
        if (this.hasNullPartitionKey()) {
            LightProtoCodec.writeVarInt(_b, 80);
            _b.writeBoolean(this.nullPartitionKey);
        }
        return _b.writerIndex() - _writeIdx;
    }

    public int getSerializedSize() {
        if (this._cachedSize > -1) {
            return this._cachedSize;
        }
        int _size = 0;
        for (int i = 0; i < this._propertiesCount; ++i) {
            KeyValue _item = this.properties.get(i);
            _size += _PROPERTIES_TAG_SIZE;
            int MsgsizeProperties = _item.getSerializedSize();
            _size += LightProtoCodec.computeVarIntSize(MsgsizeProperties) + MsgsizeProperties;
        }
        if (this.hasPartitionKey()) {
            _size += _PARTITION_KEY_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this._partitionKeyBufferLen);
            _size += this._partitionKeyBufferLen;
        }
        _size += _PAYLOAD_SIZE_TAG_SIZE;
        _size += LightProtoCodec.computeVarIntSize(this.payloadSize);
        if (this.hasCompactedOut()) {
            _size += _COMPACTED_OUT_TAG_SIZE;
            ++_size;
        }
        if (this.hasEventTime()) {
            _size += _EVENT_TIME_TAG_SIZE;
            _size += LightProtoCodec.computeVarInt64Size(this.eventTime);
        }
        if (this.hasPartitionKeyB64Encoded()) {
            _size += _PARTITION_KEY_B64_ENCODED_TAG_SIZE;
            ++_size;
        }
        if (this.hasOrderingKey()) {
            _size += _ORDERING_KEY_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this._orderingKeyLen) + this._orderingKeyLen;
        }
        if (this.hasSequenceId()) {
            _size += _SEQUENCE_ID_TAG_SIZE;
            _size += LightProtoCodec.computeVarInt64Size(this.sequenceId);
        }
        if (this.hasNullValue()) {
            _size += _NULL_VALUE_TAG_SIZE;
            ++_size;
        }
        if (this.hasNullPartitionKey()) {
            _size += _NULL_PARTITION_KEY_TAG_SIZE;
            ++_size;
        }
        this._cachedSize = _size;
        return _size;
    }

    public void parseFrom(ByteBuf _buffer, int _size) {
        this.clear();
        int _endIdx = _buffer.readerIndex() + _size;
        block12: while (_buffer.readerIndex() < _endIdx) {
            int _tag = LightProtoCodec.readVarInt(_buffer);
            switch (_tag) {
                case 10: {
                    int _propertiesSize = LightProtoCodec.readVarInt(_buffer);
                    this.addProperty().parseFrom(_buffer, _propertiesSize);
                    continue block12;
                }
                case 18: {
                    this._bitField0 |= 2;
                    this._partitionKeyBufferLen = LightProtoCodec.readVarInt(_buffer);
                    this._partitionKeyBufferIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._partitionKeyBufferLen);
                    continue block12;
                }
                case 24: {
                    this._bitField0 |= 4;
                    this.payloadSize = LightProtoCodec.readVarInt(_buffer);
                    continue block12;
                }
                case 32: {
                    this._bitField0 |= 8;
                    this.compactedOut = LightProtoCodec.readVarInt(_buffer) == 1;
                    continue block12;
                }
                case 40: {
                    this._bitField0 |= 0x10;
                    this.eventTime = LightProtoCodec.readVarInt64(_buffer);
                    continue block12;
                }
                case 48: {
                    this._bitField0 |= 0x20;
                    this.partitionKeyB64Encoded = LightProtoCodec.readVarInt(_buffer) == 1;
                    continue block12;
                }
                case 58: {
                    this._bitField0 |= 0x40;
                    this._orderingKeyLen = LightProtoCodec.readVarInt(_buffer);
                    this._orderingKeyIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._orderingKeyLen);
                    continue block12;
                }
                case 64: {
                    this._bitField0 |= 0x80;
                    this.sequenceId = LightProtoCodec.readVarInt64(_buffer);
                    continue block12;
                }
                case 72: {
                    this._bitField0 |= 0x100;
                    this.nullValue = LightProtoCodec.readVarInt(_buffer) == 1;
                    continue block12;
                }
                case 80: {
                    this._bitField0 |= 0x200;
                    this.nullPartitionKey = LightProtoCodec.readVarInt(_buffer) == 1;
                    continue block12;
                }
            }
            LightProtoCodec.skipUnknownField(_tag, _buffer);
        }
        this.checkRequiredFields();
        this._parsedBuffer = _buffer;
    }

    private void checkRequiredFields() {
        if ((this._bitField0 & 4) != 4) {
            throw new IllegalStateException("Some required fields are missing");
        }
    }

    public SingleMessageMetadata clear() {
        for (int i = 0; i < this._propertiesCount; ++i) {
            this.properties.get(i).clear();
        }
        this._propertiesCount = 0;
        this.partitionKey = null;
        this._partitionKeyBufferIdx = -1;
        this._partitionKeyBufferLen = -1;
        this.compactedOut = false;
        this.eventTime = 0L;
        this.partitionKeyB64Encoded = false;
        this.orderingKey = null;
        this._orderingKeyIdx = -1;
        this._orderingKeyLen = -1;
        this.nullValue = false;
        this.nullPartitionKey = false;
        this._parsedBuffer = null;
        this._cachedSize = -1;
        this._bitField0 = 0;
        return this;
    }

    public SingleMessageMetadata copyFrom(SingleMessageMetadata _other) {
        this._cachedSize = -1;
        for (int i = 0; i < _other.getPropertiesCount(); ++i) {
            this.addProperty().copyFrom(_other.getPropertyAt(i));
        }
        if (_other.hasPartitionKey()) {
            this.setPartitionKey(_other.getPartitionKey());
        }
        if (_other.hasPayloadSize()) {
            this.setPayloadSize(_other.payloadSize);
        }
        if (_other.hasCompactedOut()) {
            this.setCompactedOut(_other.compactedOut);
        }
        if (_other.hasEventTime()) {
            this.setEventTime(_other.eventTime);
        }
        if (_other.hasPartitionKeyB64Encoded()) {
            this.setPartitionKeyB64Encoded(_other.partitionKeyB64Encoded);
        }
        if (_other.hasOrderingKey()) {
            this.setOrderingKey(_other.getOrderingKey());
        }
        if (_other.hasSequenceId()) {
            this.setSequenceId(_other.sequenceId);
        }
        if (_other.hasNullValue()) {
            this.setNullValue(_other.nullValue);
        }
        if (_other.hasNullPartitionKey()) {
            this.setNullPartitionKey(_other.nullPartitionKey);
        }
        return this;
    }

    public byte[] toByteArray() {
        byte[] a = new byte[this.getSerializedSize()];
        ByteBuf b = Unpooled.wrappedBuffer(a).writerIndex(0);
        this.writeTo(b);
        return a;
    }

    public void parseFrom(byte[] a) {
        ByteBuf b = Unpooled.wrappedBuffer(a);
        this.parseFrom(b, b.readableBytes());
    }
}

