/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.reactive.client.producercache;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.pulsar.reactive.client.adapter.ProducerCacheProvider;
import org.apache.pulsar.reactive.shade.com.github.benmanes.caffeine.cache.AsyncCache;
import org.apache.pulsar.reactive.shade.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.pulsar.reactive.shade.com.github.benmanes.caffeine.cache.RemovalCause;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class CaffeineShadedProducerCacheProvider
implements ProducerCacheProvider {
    private final AsyncCache<Object, Object> cache;

    public CaffeineShadedProducerCacheProvider() {
        this(Duration.ofMinutes(1L), Duration.ofMinutes(10L), 1000L, 50);
    }

    public CaffeineShadedProducerCacheProvider(Duration cacheExpireAfterAccess, Duration cacheExpireAfterWrite, Long cacheMaximumSize, Integer cacheInitialCapacity) {
        this.cache = Caffeine.newBuilder().expireAfterAccess(cacheExpireAfterAccess).expireAfterWrite(cacheExpireAfterWrite).maximumSize(cacheMaximumSize).initialCapacity(cacheInitialCapacity).scheduler(org.apache.pulsar.reactive.shade.com.github.benmanes.caffeine.cache.Scheduler.systemScheduler()).executor(arg_0 -> ((Scheduler)Schedulers.boundedElastic()).schedule(arg_0)).removalListener(this::onRemoval).buildAsync();
    }

    private void onRemoval(Object key, Object entry, RemovalCause cause) {
        if (entry instanceof AutoCloseable) {
            try {
                ((AutoCloseable)entry).close();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public void close() {
        this.cache.synchronous().invalidateAll();
    }

    public <K, V> CompletableFuture<V> getOrCreateCachedEntry(K key, Function<K, CompletableFuture<V>> createEntryFunction) {
        return this.cache.get(key, (__, ___) -> (CompletableFuture)createEntryFunction.apply(key));
    }
}

