/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.commons.configuration.interpol;

import java.util.ArrayList;
import org.apache.pulsar.shade.org.apache.commons.configuration.AbstractConfiguration;
import org.apache.pulsar.shade.org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.pulsar.shade.org.apache.commons.configuration.interpol.ConfigurationInterpolator;
import org.apache.pulsar.shade.org.apache.commons.jexl2.Expression;
import org.apache.pulsar.shade.org.apache.commons.jexl2.JexlContext;
import org.apache.pulsar.shade.org.apache.commons.jexl2.JexlEngine;
import org.apache.pulsar.shade.org.apache.commons.jexl2.MapContext;
import org.apache.pulsar.shade.org.apache.commons.lang.ClassUtils;
import org.apache.pulsar.shade.org.apache.commons.lang.StringUtils;
import org.apache.pulsar.shade.org.apache.commons.lang.text.StrLookup;
import org.apache.pulsar.shade.org.apache.commons.lang.text.StrSubstitutor;

public class ExprLookup
extends StrLookup {
    private static final String CLASS = "Class:";
    private static final String DEFAULT_PREFIX = "$[";
    private static final String DEFAULT_SUFFIX = "]";
    private AbstractConfiguration configuration;
    private final JexlEngine engine = new JexlEngine();
    private Variables variables;
    private String prefixMatcher = "$[";
    private String suffixMatcher = "]";

    public ExprLookup() {
    }

    public ExprLookup(Variables list) {
        this.setVariables(list);
    }

    public ExprLookup(Variables list, String prefix, String suffix) {
        this(list);
        this.setVariablePrefixMatcher(prefix);
        this.setVariableSuffixMatcher(suffix);
    }

    public void setVariablePrefixMatcher(String prefix) {
        this.prefixMatcher = prefix;
    }

    public void setVariableSuffixMatcher(String suffix) {
        this.suffixMatcher = suffix;
    }

    public void setVariables(Variables list) {
        this.variables = new Variables(list);
    }

    public Variables getVariables() {
        return null;
    }

    public void setConfiguration(AbstractConfiguration config) {
        this.configuration = config;
    }

    public String lookup(String var) {
        ConfigurationInterpolator interp = this.configuration.getInterpolator();
        StrSubstitutor subst = new StrSubstitutor((StrLookup)interp, this.prefixMatcher, this.suffixMatcher, '$');
        String result = subst.replace(var);
        try {
            Expression exp = this.engine.createExpression(result);
            result = (String)exp.evaluate(this.createContext());
        }
        catch (Exception e) {
            this.configuration.getLogger().debug("Error encountered evaluating " + result, e);
        }
        return result;
    }

    private JexlContext createContext() {
        MapContext ctx = new MapContext();
        this.initializeContext((JexlContext)ctx);
        return ctx;
    }

    private void initializeContext(JexlContext ctx) {
        for (Variable var : this.variables) {
            ctx.set(var.getName(), var.getValue());
        }
    }

    public static class Variable {
        private String key;
        private Object value;

        public Variable() {
        }

        public Variable(String name, Object value) {
            this.setName(name);
            this.setValue(value);
        }

        public String getName() {
            return this.key;
        }

        public void setName(String name) {
            this.key = name;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) throws ConfigurationRuntimeException {
            try {
                if (!(value instanceof String)) {
                    this.value = value;
                    return;
                }
                String val = (String)value;
                String name = StringUtils.removeStartIgnoreCase(val, ExprLookup.CLASS);
                Class clazz = ClassUtils.getClass(name);
                this.value = name.length() == val.length() ? clazz.newInstance() : clazz;
            }
            catch (Exception e) {
                throw new ConfigurationRuntimeException("Unable to create " + value, e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Variables
    extends ArrayList<Variable> {
        private static final long serialVersionUID = 20111205L;

        public Variables() {
        }

        public Variables(Variables vars) {
            super(vars);
        }

        public Variable getVariable() {
            if (this.size() > 0) {
                return (Variable)this.get(this.size() - 1);
            }
            return null;
        }
    }
}

