/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.api.utils;

import java.util.Map;
import java.util.Optional;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.functions.api.Context;
import org.apache.pulsar.functions.api.Record;

public class FunctionRecord<T>
implements Record<T> {
    private final T value;
    private final String topicName;
    private final String destinationTopic;
    private final Map<String, String> properties;
    private final String key;
    private final Schema<T> schema;
    private final Long eventTime;
    private final String partitionId;
    private final Integer partitionIndex;
    private final Long recordSequence;

    public static <T> FunctionRecordBuilder<T> from(Context context, Schema<T> schema) {
        if (schema == null) {
            throw new IllegalArgumentException("Schema should not be null.");
        }
        Record<?> currentRecord = context.getCurrentRecord();
        FunctionRecordBuilder builder = new FunctionRecordBuilder<T>().schema(schema).destinationTopic(context.getOutputTopic()).properties(currentRecord.getProperties());
        currentRecord.getTopicName().ifPresent(builder::topicName);
        currentRecord.getKey().ifPresent(builder::key);
        currentRecord.getEventTime().ifPresent(builder::eventTime);
        currentRecord.getPartitionId().ifPresent(builder::partitionId);
        currentRecord.getPartitionIndex().ifPresent(builder::partitionIndex);
        currentRecord.getRecordSequence().ifPresent(builder::recordSequence);
        return builder;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public Optional<String> getTopicName() {
        return Optional.ofNullable(this.topicName);
    }

    @Override
    public Optional<String> getDestinationTopic() {
        return Optional.ofNullable(this.destinationTopic);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public Optional<String> getKey() {
        return Optional.ofNullable(this.key);
    }

    @Override
    public Schema<T> getSchema() {
        return this.schema;
    }

    @Override
    public Optional<Long> getEventTime() {
        return Optional.ofNullable(this.eventTime);
    }

    @Override
    public Optional<String> getPartitionId() {
        return Optional.ofNullable(this.partitionId);
    }

    @Override
    public Optional<Integer> getPartitionIndex() {
        return Optional.ofNullable(this.partitionIndex);
    }

    @Override
    public Optional<Long> getRecordSequence() {
        return Optional.ofNullable(this.recordSequence);
    }

    FunctionRecord(T value, String topicName, String destinationTopic, Map<String, String> properties, String key, Schema<T> schema, Long eventTime, String partitionId, Integer partitionIndex, Long recordSequence) {
        this.value = value;
        this.topicName = topicName;
        this.destinationTopic = destinationTopic;
        this.properties = properties;
        this.key = key;
        this.schema = schema;
        this.eventTime = eventTime;
        this.partitionId = partitionId;
        this.partitionIndex = partitionIndex;
        this.recordSequence = recordSequence;
    }

    public static class FunctionRecordBuilder<T> {
        private T value;
        private String topicName;
        private String destinationTopic;
        private Map<String, String> properties;
        private String key;
        private Schema<T> schema;
        private Long eventTime;
        private String partitionId;
        private Integer partitionIndex;
        private Long recordSequence;

        private FunctionRecordBuilder() {
        }

        public FunctionRecordBuilder<T> value(T value) {
            this.value = value;
            return this;
        }

        public FunctionRecordBuilder<T> topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public FunctionRecordBuilder<T> destinationTopic(String destinationTopic) {
            this.destinationTopic = destinationTopic;
            return this;
        }

        public FunctionRecordBuilder<T> properties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public FunctionRecordBuilder<T> key(String key) {
            this.key = key;
            return this;
        }

        public FunctionRecordBuilder<T> schema(Schema<T> schema) {
            this.schema = schema;
            return this;
        }

        public FunctionRecordBuilder<T> eventTime(Long eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public FunctionRecordBuilder<T> partitionId(String partitionId) {
            this.partitionId = partitionId;
            return this;
        }

        public FunctionRecordBuilder<T> partitionIndex(Integer partitionIndex) {
            this.partitionIndex = partitionIndex;
            return this;
        }

        public FunctionRecordBuilder<T> recordSequence(Long recordSequence) {
            this.recordSequence = recordSequence;
            return this;
        }

        public FunctionRecord<T> build() {
            return new FunctionRecord<T>(this.value, this.topicName, this.destinationTopic, this.properties, this.key, this.schema, this.eventTime, this.partitionId, this.partitionIndex, this.recordSequence);
        }

        public String toString() {
            return "FunctionRecord.FunctionRecordBuilder(value=" + this.value + ", topicName=" + this.topicName + ", destinationTopic=" + this.destinationTopic + ", properties=" + this.properties + ", key=" + this.key + ", schema=" + this.schema + ", eventTime=" + this.eventTime + ", partitionId=" + this.partitionId + ", partitionIndex=" + this.partitionIndex + ", recordSequence=" + this.recordSequence + ")";
        }
    }
}

