/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.resolver;

import io.etcd.jetcd.common.exception.ErrorCode;
import io.etcd.jetcd.common.exception.EtcdExceptionFactory;
import io.etcd.jetcd.resolver.AbstractNameResolver;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Strings;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.Attributes;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.EquivalentAddressGroup;

public class HttpsNameResolver
extends AbstractNameResolver {
    public static final String SCHEME = "https";
    private final URI address;

    public HttpsNameResolver(URI targetUri) {
        super(targetUri);
        this.address = targetUri;
    }

    @Override
    protected List<EquivalentAddressGroup> computeAddressGroups() {
        if (this.address == null) {
            throw EtcdExceptionFactory.newEtcdException(ErrorCode.INVALID_ARGUMENT, "Unable to resolve endpoint " + this.getTargetUri());
        }
        return Collections.singletonList(new EquivalentAddressGroup((SocketAddress)new InetSocketAddress(this.address.getHost(), this.address.getPort() != -1 ? this.address.getPort() : 2379), Strings.isNullOrEmpty(this.getServiceAuthority()) ? Attributes.newBuilder().set(EquivalentAddressGroup.ATTR_AUTHORITY_OVERRIDE, (Object)this.address.toString()).build() : Attributes.EMPTY));
    }
}

