/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.functions;

import java.util.Arrays;
import org.apache.pulsar.common.functions.FunctionConfig;
import org.apache.pulsar.common.io.SinkConfig;
import org.apache.pulsar.common.io.SourceConfig;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.packages.management.core.common.PackageType;

public class Utils {
    public static final String HTTP = "http";
    public static final String FILE = "file";
    public static final String BUILTIN = "builtin";

    public static boolean isFunctionPackageUrlSupported(String functionPkgUrl) {
        return StringUtils.isNotBlank(functionPkgUrl) && (functionPkgUrl.startsWith(HTTP) || functionPkgUrl.startsWith(FILE) || Utils.hasPackageTypePrefix(functionPkgUrl));
    }

    public static boolean hasPackageTypePrefix(String destPkgUrl) {
        return Arrays.stream(PackageType.values()).anyMatch(type -> destPkgUrl.startsWith(type.toString()) && destPkgUrl.contains("://"));
    }

    public static void inferMissingFunctionName(FunctionConfig functionConfig) {
        if (!org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang.StringUtils.isEmpty(functionConfig.getClassName())) {
            String[] domains = functionConfig.getClassName().split("\\.");
            if (domains.length == 0) {
                functionConfig.setName(functionConfig.getClassName());
            } else {
                functionConfig.setName(domains[domains.length - 1]);
            }
        }
    }

    public static void inferMissingTenant(FunctionConfig functionConfig) {
        functionConfig.setTenant("public");
    }

    public static void inferMissingNamespace(FunctionConfig functionConfig) {
        functionConfig.setNamespace("default");
    }

    public static void inferMissingArguments(SourceConfig sourceConfig) {
        if (sourceConfig.getTenant() == null) {
            sourceConfig.setTenant("public");
        }
        if (sourceConfig.getNamespace() == null) {
            sourceConfig.setNamespace("default");
        }
        if (sourceConfig.getParallelism() == null) {
            sourceConfig.setParallelism(1);
        }
    }

    public static void inferMissingArguments(SinkConfig sinkConfig) {
        if (sinkConfig.getTenant() == null) {
            sinkConfig.setTenant("public");
        }
        if (sinkConfig.getNamespace() == null) {
            sinkConfig.setNamespace("default");
        }
        if (sinkConfig.getParallelism() == null) {
            sinkConfig.setParallelism(1);
        }
    }
}

