/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data.stats;

import java.util.Objects;
import lombok.Generated;
import org.apache.pulsar.common.policies.data.ReplicatorStats;

public class ReplicatorStatsImpl
implements ReplicatorStats {
    public double msgRateIn;
    public double msgThroughputIn;
    public double msgRateOut;
    public double msgThroughputOut;
    public double msgRateExpired;
    public long replicationBacklog;
    public boolean connected;
    public long replicationDelayInSeconds;
    public String inboundConnection;
    public String inboundConnectedSince;
    public String outboundConnection;
    public String outboundConnectedSince;

    public ReplicatorStatsImpl add(ReplicatorStatsImpl stats) {
        Objects.requireNonNull(stats);
        this.msgRateIn += stats.msgRateIn;
        this.msgThroughputIn += stats.msgThroughputIn;
        this.msgRateOut += stats.msgRateOut;
        this.msgThroughputOut += stats.msgThroughputOut;
        this.msgRateExpired += stats.msgRateExpired;
        this.replicationBacklog += stats.replicationBacklog;
        if (this.connected) {
            this.connected &= stats.connected;
        }
        this.replicationDelayInSeconds = Math.max(this.replicationDelayInSeconds, stats.replicationDelayInSeconds);
        return this;
    }

    @Generated
    public ReplicatorStatsImpl() {
    }

    @Override
    @Generated
    public double getMsgRateIn() {
        return this.msgRateIn;
    }

    @Override
    @Generated
    public double getMsgThroughputIn() {
        return this.msgThroughputIn;
    }

    @Override
    @Generated
    public double getMsgRateOut() {
        return this.msgRateOut;
    }

    @Override
    @Generated
    public double getMsgThroughputOut() {
        return this.msgThroughputOut;
    }

    @Override
    @Generated
    public double getMsgRateExpired() {
        return this.msgRateExpired;
    }

    @Override
    @Generated
    public long getReplicationBacklog() {
        return this.replicationBacklog;
    }

    @Override
    @Generated
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    @Generated
    public long getReplicationDelayInSeconds() {
        return this.replicationDelayInSeconds;
    }

    @Override
    @Generated
    public String getInboundConnection() {
        return this.inboundConnection;
    }

    @Override
    @Generated
    public String getInboundConnectedSince() {
        return this.inboundConnectedSince;
    }

    @Override
    @Generated
    public String getOutboundConnection() {
        return this.outboundConnection;
    }

    @Override
    @Generated
    public String getOutboundConnectedSince() {
        return this.outboundConnectedSince;
    }

    @Generated
    public void setMsgRateIn(double msgRateIn) {
        this.msgRateIn = msgRateIn;
    }

    @Generated
    public void setMsgThroughputIn(double msgThroughputIn) {
        this.msgThroughputIn = msgThroughputIn;
    }

    @Generated
    public void setMsgRateOut(double msgRateOut) {
        this.msgRateOut = msgRateOut;
    }

    @Generated
    public void setMsgThroughputOut(double msgThroughputOut) {
        this.msgThroughputOut = msgThroughputOut;
    }

    @Generated
    public void setMsgRateExpired(double msgRateExpired) {
        this.msgRateExpired = msgRateExpired;
    }

    @Generated
    public void setReplicationBacklog(long replicationBacklog) {
        this.replicationBacklog = replicationBacklog;
    }

    @Generated
    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    @Generated
    public void setReplicationDelayInSeconds(long replicationDelayInSeconds) {
        this.replicationDelayInSeconds = replicationDelayInSeconds;
    }

    @Generated
    public void setInboundConnection(String inboundConnection) {
        this.inboundConnection = inboundConnection;
    }

    @Generated
    public void setInboundConnectedSince(String inboundConnectedSince) {
        this.inboundConnectedSince = inboundConnectedSince;
    }

    @Generated
    public void setOutboundConnection(String outboundConnection) {
        this.outboundConnection = outboundConnection;
    }

    @Generated
    public void setOutboundConnectedSince(String outboundConnectedSince) {
        this.outboundConnectedSince = outboundConnectedSince;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplicatorStatsImpl)) {
            return false;
        }
        ReplicatorStatsImpl other = (ReplicatorStatsImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getMsgRateIn(), other.getMsgRateIn()) != 0) {
            return false;
        }
        if (Double.compare(this.getMsgThroughputIn(), other.getMsgThroughputIn()) != 0) {
            return false;
        }
        if (Double.compare(this.getMsgRateOut(), other.getMsgRateOut()) != 0) {
            return false;
        }
        if (Double.compare(this.getMsgThroughputOut(), other.getMsgThroughputOut()) != 0) {
            return false;
        }
        if (Double.compare(this.getMsgRateExpired(), other.getMsgRateExpired()) != 0) {
            return false;
        }
        if (this.getReplicationBacklog() != other.getReplicationBacklog()) {
            return false;
        }
        if (this.isConnected() != other.isConnected()) {
            return false;
        }
        if (this.getReplicationDelayInSeconds() != other.getReplicationDelayInSeconds()) {
            return false;
        }
        String this$inboundConnection = this.getInboundConnection();
        String other$inboundConnection = other.getInboundConnection();
        if (this$inboundConnection == null ? other$inboundConnection != null : !this$inboundConnection.equals(other$inboundConnection)) {
            return false;
        }
        String this$inboundConnectedSince = this.getInboundConnectedSince();
        String other$inboundConnectedSince = other.getInboundConnectedSince();
        if (this$inboundConnectedSince == null ? other$inboundConnectedSince != null : !this$inboundConnectedSince.equals(other$inboundConnectedSince)) {
            return false;
        }
        String this$outboundConnection = this.getOutboundConnection();
        String other$outboundConnection = other.getOutboundConnection();
        if (this$outboundConnection == null ? other$outboundConnection != null : !this$outboundConnection.equals(other$outboundConnection)) {
            return false;
        }
        String this$outboundConnectedSince = this.getOutboundConnectedSince();
        String other$outboundConnectedSince = other.getOutboundConnectedSince();
        return !(this$outboundConnectedSince == null ? other$outboundConnectedSince != null : !this$outboundConnectedSince.equals(other$outboundConnectedSince));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReplicatorStatsImpl;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $msgRateIn = Double.doubleToLongBits(this.getMsgRateIn());
        result = result * 59 + (int)($msgRateIn >>> 32 ^ $msgRateIn);
        long $msgThroughputIn = Double.doubleToLongBits(this.getMsgThroughputIn());
        result = result * 59 + (int)($msgThroughputIn >>> 32 ^ $msgThroughputIn);
        long $msgRateOut = Double.doubleToLongBits(this.getMsgRateOut());
        result = result * 59 + (int)($msgRateOut >>> 32 ^ $msgRateOut);
        long $msgThroughputOut = Double.doubleToLongBits(this.getMsgThroughputOut());
        result = result * 59 + (int)($msgThroughputOut >>> 32 ^ $msgThroughputOut);
        long $msgRateExpired = Double.doubleToLongBits(this.getMsgRateExpired());
        result = result * 59 + (int)($msgRateExpired >>> 32 ^ $msgRateExpired);
        long $replicationBacklog = this.getReplicationBacklog();
        result = result * 59 + (int)($replicationBacklog >>> 32 ^ $replicationBacklog);
        result = result * 59 + (this.isConnected() ? 79 : 97);
        long $replicationDelayInSeconds = this.getReplicationDelayInSeconds();
        result = result * 59 + (int)($replicationDelayInSeconds >>> 32 ^ $replicationDelayInSeconds);
        String $inboundConnection = this.getInboundConnection();
        result = result * 59 + ($inboundConnection == null ? 43 : $inboundConnection.hashCode());
        String $inboundConnectedSince = this.getInboundConnectedSince();
        result = result * 59 + ($inboundConnectedSince == null ? 43 : $inboundConnectedSince.hashCode());
        String $outboundConnection = this.getOutboundConnection();
        result = result * 59 + ($outboundConnection == null ? 43 : $outboundConnection.hashCode());
        String $outboundConnectedSince = this.getOutboundConnectedSince();
        result = result * 59 + ($outboundConnectedSince == null ? 43 : $outboundConnectedSince.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ReplicatorStatsImpl(msgRateIn=" + this.getMsgRateIn() + ", msgThroughputIn=" + this.getMsgThroughputIn() + ", msgRateOut=" + this.getMsgRateOut() + ", msgThroughputOut=" + this.getMsgThroughputOut() + ", msgRateExpired=" + this.getMsgRateExpired() + ", replicationBacklog=" + this.getReplicationBacklog() + ", connected=" + this.isConnected() + ", replicationDelayInSeconds=" + this.getReplicationDelayInSeconds() + ", inboundConnection=" + this.getInboundConnection() + ", inboundConnectedSince=" + this.getInboundConnectedSince() + ", outboundConnection=" + this.getOutboundConnection() + ", outboundConnectedSince=" + this.getOutboundConnectedSince() + ")";
    }
}

