/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.com.google.re2j;

import java.nio.charset.Charset;

abstract class MatcherInput {
    MatcherInput() {
    }

    static MatcherInput utf16(CharSequence charSequence) {
        return new Utf16MatcherInput(charSequence);
    }

    static MatcherInput utf8(byte[] bytes) {
        return new Utf8MatcherInput(bytes);
    }

    static MatcherInput utf8(String input) {
        return new Utf8MatcherInput(input.getBytes(Charset.forName("UTF-8")));
    }

    abstract Encoding getEncoding();

    abstract CharSequence asCharSequence();

    abstract byte[] asBytes();

    abstract int length();

    static class Utf16MatcherInput
    extends MatcherInput {
        CharSequence charSequence;

        public Utf16MatcherInput(CharSequence charSequence) {
            this.charSequence = charSequence;
        }

        @Override
        public Encoding getEncoding() {
            return Encoding.UTF_16;
        }

        @Override
        public CharSequence asCharSequence() {
            return this.charSequence;
        }

        @Override
        public byte[] asBytes() {
            return this.charSequence.toString().getBytes(Charset.forName("UTF-16"));
        }

        @Override
        public int length() {
            return this.charSequence.length();
        }
    }

    static class Utf8MatcherInput
    extends MatcherInput {
        byte[] bytes;

        public Utf8MatcherInput(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        public Encoding getEncoding() {
            return Encoding.UTF_8;
        }

        @Override
        public CharSequence asCharSequence() {
            return new String(this.bytes, Charset.forName("UTF-8"));
        }

        @Override
        public byte[] asBytes() {
            return this.bytes;
        }

        @Override
        public int length() {
            return this.bytes.length;
        }
    }

    static enum Encoding {
        UTF_16,
        UTF_8;

    }
}

