/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.com.scurrilous.circe.crc;

import org.apache.pulsar.functions.runtime.shaded.com.scurrilous.circe.impl.AbstractIncrementalIntHash;

abstract class AbstractIntCrc
extends AbstractIncrementalIntHash {
    private final String algorithm;
    protected final int bitWidth;
    private final int initial;
    private final int xorOut;

    AbstractIntCrc(String algorithm, int bitWidth, int initial, int xorOut) {
        if (bitWidth < 1 || bitWidth > 32) {
            throw new IllegalArgumentException("invalid CRC width");
        }
        this.algorithm = algorithm;
        this.bitWidth = bitWidth;
        this.initial = initial;
        this.xorOut = xorOut;
    }

    @Override
    public String algorithm() {
        return this.algorithm;
    }

    @Override
    public int length() {
        return (this.bitWidth + 7) / 8;
    }

    @Override
    protected int initial() {
        return this.initial ^ this.xorOut;
    }

    @Override
    protected int resumeUnchecked(int current, byte[] input, int index, int length) {
        return this.resumeRaw(current ^ this.xorOut, input, index, length) ^ this.xorOut;
    }

    protected abstract int resumeRaw(int var1, byte[] var2, int var3, int var4);

    protected final int reflect(int value) {
        return Integer.reverse(value) >>> 32 - this.bitWidth;
    }
}

