/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv;

import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.functions.runtime.shaded.io.netty.util.ReferenceCountUtil;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.PTableBase;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.exceptions.KvApiException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.options.Options;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.options.RangeOption;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.Code;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.KeyValue;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.RangeResult;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.annotation.InterfaceStability;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.concurrent.FutureUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public interface TableReadView<K, V>
extends PTableBase<K, V> {
    public CompletableFuture<RangeResult<K, V>> get(K var1, RangeOption<K> var2);

    default public CompletableFuture<Long> getNumber(K key) {
        RangeOption option = (RangeOption)this.opFactory().optionFactory().newRangeOption().build();
        return ((CompletableFuture)this.get(key, option).thenCompose(result -> {
            try {
                if (result.count() == 0L) {
                    CompletableFuture<Object> completableFuture = FutureUtils.value(null);
                    return completableFuture;
                }
                KeyValue kv = result.kvs().get(0);
                if (kv.isNumber()) {
                    CompletableFuture<Long> completableFuture = FutureUtils.value(kv.numberValue());
                    return completableFuture;
                }
                CompletableFuture completableFuture = FutureUtils.exception(new KvApiException(Code.ILLEGAL_OP, "Key (" + key + ") doesn't have any number value"));
                return completableFuture;
            }
            finally {
                result.close();
            }
        })).whenComplete((value, cause) -> option.close());
    }

    default public CompletableFuture<V> get(K key) {
        RangeOption option = (RangeOption)this.opFactory().optionFactory().newRangeOption().build();
        return ((CompletableFuture)this.get(key, option).thenApply(result -> {
            try {
                if (result.count() == 0L) {
                    Object var1_1 = null;
                    return var1_1;
                }
                Object v = ReferenceCountUtil.retain(result.kvs().get(0).value());
                return v;
            }
            finally {
                result.close();
            }
        })).whenComplete((value, cause) -> option.close());
    }

    default public CompletableFuture<KeyValue<K, V>> getKv(K key) {
        return this.get(key, Options.get()).thenApply(result -> {
            try {
                if (result.count() == 0L) {
                    KeyValue keyValue = null;
                    return keyValue;
                }
                KeyValue keyValue = result.getKvsAndClear().get(0);
                return keyValue;
            }
            finally {
                result.close();
            }
        });
    }
}

