/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.functions.runtime.shaded.io.netty.util.ReferenceCountUtil;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.PTableBase;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.Txn;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.exceptions.KvApiException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.CompareResult;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.options.DeleteOption;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.options.IncrementOption;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.options.Options;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.options.PutOption;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.Code;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.DeleteResult;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.IncrementResult;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.KeyValue;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.PutResult;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.RangeResult;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.annotation.InterfaceStability;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.concurrent.FutureUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public interface TableWriteView<K, V>
extends PTableBase<K, V> {
    public CompletableFuture<PutResult<K, V>> put(K var1, V var2, PutOption<K> var3);

    public CompletableFuture<DeleteResult<K, V>> delete(K var1, DeleteOption<K> var2);

    public CompletableFuture<IncrementResult<K, V>> increment(K var1, long var2, IncrementOption<K> var4);

    public Txn<K, V> txn(K var1);

    default public CompletableFuture<Void> increment(K key, long amount) {
        return this.increment(key, amount, Options.blindIncrement()).thenApply(result -> {
            try {
                Void void_ = null;
                return void_;
            }
            finally {
                result.close();
            }
        });
    }

    default public CompletableFuture<Long> incrementAndGet(K key, long amount) {
        return this.increment(key, amount, Options.incrementAndGet()).thenApply(result -> {
            try {
                Long l = result.totalAmount();
                return l;
            }
            finally {
                result.close();
            }
        });
    }

    default public CompletableFuture<Long> getAndIncrement(K key, long amount) {
        return this.increment(key, amount, Options.incrementAndGet()).thenApply(result -> {
            try {
                Long l = result.totalAmount() - amount;
                return l;
            }
            finally {
                result.close();
            }
        });
    }

    default public CompletableFuture<Void> put(K key, V value) {
        if (value == null) {
            return this.delete(key).thenApply(ignored -> null);
        }
        return this.put(key, value, Options.blindPut()).thenApply(result -> {
            try {
                Void void_ = null;
                return void_;
            }
            finally {
                result.close();
            }
        });
    }

    default public CompletableFuture<V> putIfAbsent(K pKey, K lKey, V value) {
        Txn<K, V> txn = this.txn(pKey);
        txn.If(this.opFactory().compareValue(CompareResult.EQUAL, lKey, null)).Then(this.opFactory().newPut(lKey, value, (PutOption)this.opFactory().optionFactory().newPutOption().build())).Else(this.newGet(lKey));
        return txn.commit().thenCompose(result -> {
            try {
                if (result.isSuccess()) {
                    CompletableFuture<Object> completableFuture = FutureUtils.value(null);
                    return completableFuture;
                }
                RangeResult rangeResult = (RangeResult)result.results().get(0);
                if (rangeResult.kvs().isEmpty()) {
                    CompletableFuture completableFuture = FutureUtils.exception(new KvApiException(Code.UNEXPECTED, "Key " + lKey + " not found when putIfAbsent failed"));
                    return completableFuture;
                }
                CompletableFuture completableFuture = FutureUtils.value(ReferenceCountUtil.retain(rangeResult.kvs().get(0).value()));
                return completableFuture;
            }
            finally {
                result.close();
            }
        });
    }

    default public CompletableFuture<Long> vPut(K pKey, K lKey, V value, long expectedVersion) {
        Txn<K, V> txn = this.txn(pKey);
        txn.If(this.opFactory().compareVersion(CompareResult.EQUAL, lKey, expectedVersion)).Then(this.opFactory().newPut(lKey, value, (PutOption)this.opFactory().optionFactory().newPutOption().build()));
        return txn.commit().thenCompose(result -> {
            try {
                if (result.isSuccess()) {
                    CompletableFuture<Long> completableFuture = FutureUtils.value(expectedVersion + 1L);
                    return completableFuture;
                }
                CompletableFuture completableFuture = FutureUtils.exception(new KvApiException(Code.BAD_REVISION, "Failed to vPut(" + lKey + ", " + value + ")@version=" + expectedVersion));
                return completableFuture;
            }
            finally {
                result.close();
            }
        });
    }

    default public CompletableFuture<V> delete(K key) {
        return this.delete(key, (V)Options.deleteAndGet()).thenApply(result -> {
            try {
                List prevKvs = result.prevKvs();
                if (prevKvs.isEmpty()) {
                    Object var2_2 = null;
                    return var2_2;
                }
                Object v = ReferenceCountUtil.retain(prevKvs.get(0).value());
                return v;
            }
            finally {
                result.close();
            }
        });
    }

    default public CompletableFuture<Boolean> delete(K key, V value) {
        Txn<K, V> txn = this.txn(key);
        txn.If(this.opFactory().compareValue(CompareResult.EQUAL, key, value)).Then(this.opFactory().newDelete(key, Options.deleteAndGet()));
        return txn.commit().thenApply(result -> {
            try {
                Boolean bl = result.isSuccess() && !result.results().isEmpty();
                return bl;
            }
            finally {
                result.close();
            }
        });
    }

    default public CompletableFuture<KeyValue<K, V>> vDelete(K key, long expectedVersion) {
        Txn<K, V> txn = this.txn(key);
        txn.If(this.opFactory().compareVersion(CompareResult.EQUAL, key, expectedVersion)).Then(this.opFactory().newDelete(key, Options.deleteAndGet()));
        return txn.commit().thenCompose(result -> {
            try {
                if (result.isSuccess()) {
                    DeleteResult deleteResult = (DeleteResult)result.results().get(0);
                    if (deleteResult.prevKvs().isEmpty()) {
                        CompletableFuture<Object> completableFuture = FutureUtils.value(null);
                        return completableFuture;
                    }
                    List prevKvs = deleteResult.getPrevKvsAndClear();
                    CompletableFuture completableFuture = FutureUtils.value(prevKvs.get(0));
                    return completableFuture;
                }
                CompletableFuture completableFuture = FutureUtils.exception(new KvApiException(Code.BAD_REVISION, "Failed to vDelete key " + key + " (version = " + expectedVersion + ")"));
                return completableFuture;
            }
            finally {
                result.close();
            }
        });
    }

    default public CompletableFuture<KeyValue<K, V>> rDelete(K key, long expectedRevision) {
        Txn<K, V> txn = this.txn(key);
        txn.If(this.opFactory().compareModRevision(CompareResult.EQUAL, key, expectedRevision)).Then(this.opFactory().newDelete(key, Options.deleteAndGet()));
        return txn.commit().thenCompose(result -> {
            try {
                if (result.isSuccess()) {
                    DeleteResult deleteResult = (DeleteResult)result.results().get(0);
                    if (deleteResult.prevKvs().isEmpty()) {
                        CompletableFuture<Object> completableFuture = FutureUtils.value(null);
                        return completableFuture;
                    }
                    List prevKvs = deleteResult.getPrevKvsAndClear();
                    CompletableFuture completableFuture = FutureUtils.value(prevKvs.get(0));
                    return completableFuture;
                }
                CompletableFuture completableFuture = FutureUtils.exception(new KvApiException(Code.BAD_REVISION, "Failed to rDelete key " + key + " (mod_rev = " + expectedRevision + ")"));
                return completableFuture;
            }
            finally {
                result.close();
            }
        });
    }
}

