/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie;

import java.io.IOException;
import java.util.function.Supplier;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBufAllocator;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.BookieException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.discover.BookieServiceInfo;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.StatsLogger;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.util.DiskChecker;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyBookie
extends BookieImpl {
    private static final Logger LOG = LoggerFactory.getLogger(ReadOnlyBookie.class);

    public ReadOnlyBookie(ServerConfiguration conf, RegistrationManager registrationManager, LedgerStorage storage, DiskChecker diskChecker, LedgerDirsManager ledgerDirsManager, LedgerDirsManager indexDirsManager, StatsLogger statsLogger, ByteBufAllocator allocator, Supplier<BookieServiceInfo> bookieServiceInfoProvider) throws IOException, KeeperException, InterruptedException, BookieException {
        super(conf, registrationManager, storage, diskChecker, ledgerDirsManager, indexDirsManager, statsLogger, allocator, bookieServiceInfoProvider);
        if (!conf.isReadOnlyModeEnabled()) {
            String err = "Try to init ReadOnly Bookie, while ReadOnly mode is not enabled";
            LOG.error(err);
            throw new IOException(err);
        }
        this.stateManager.forceToReadOnly();
        LOG.info("Running bookie in force readonly mode.");
    }
}

