/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.datainteg;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Preconditions;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.collect.ImmutableCollection;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WriteSets {
    private static final Logger log = LoggerFactory.getLogger(WriteSets.class);
    private final int ensembleSize;
    private final ImmutableList<ImmutableList<Integer>> sets;

    WriteSets(List<Integer> preferredOrder, int ensembleSize, int writeQuorumSize) {
        this.ensembleSize = ensembleSize;
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (int i = 0; i < ensembleSize; ++i) {
            builder.add(WriteSets.generateWriteSet(preferredOrder, ensembleSize, writeQuorumSize, i));
        }
        this.sets = builder.build();
    }

    WriteSets(int ensembleSize, int writeQuorumSize) {
        this(IntStream.range(0, ensembleSize).boxed().collect(Collectors.toList()), ensembleSize, writeQuorumSize);
    }

    ImmutableList<Integer> getForEntry(long entryId) {
        return (ImmutableList)this.sets.get((int)(entryId % (long)this.ensembleSize));
    }

    static ImmutableList<Integer> generateWriteSet(List<Integer> preferredOrder, int ensembleSize, int writeQuorumSize, int offset) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        int firstIndex = offset;
        int lastIndex = (offset + writeQuorumSize - 1) % ensembleSize;
        for (Integer i : preferredOrder) {
            if (firstIndex <= lastIndex && i >= firstIndex && i <= lastIndex) {
                builder.add(i);
                continue;
            }
            if (lastIndex >= firstIndex || i > lastIndex && i < firstIndex) continue;
            builder.add(i);
        }
        ImmutableCollection writeSet = builder.build();
        Preconditions.checkState(writeSet.size() == writeQuorumSize || writeSet.size() == writeQuorumSize - 1);
        return writeSet;
    }
}

