/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client;

import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.collect.Lists;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBuf;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.BKException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.ClientContext;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.LedgerHandle;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.LedgerMetadataUtils;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.ReadOpBase;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.impl.LedgerEntriesImpl;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.impl.LedgerEntryImpl;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.net.BookieId;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.util.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PendingReadOp
extends ReadOpBase
implements BookkeeperInternalCallbacks.ReadEntryCallback {
    private static final Logger LOG = LoggerFactory.getLogger(PendingReadOp.class);
    protected boolean parallelRead = false;
    protected final LinkedList<SingleLedgerEntryRequest> seq = new LinkedList();

    PendingReadOp(LedgerHandle lh, ClientContext clientCtx, long startEntryId, long endEntryId, boolean isRecoveryRead) {
        super(lh, clientCtx, startEntryId, endEntryId, isRecoveryRead);
        this.numPendingEntries = endEntryId - startEntryId + 1L;
    }

    PendingReadOp parallelRead(boolean enabled) {
        this.parallelRead = enabled;
        return this;
    }

    @Override
    void initiate() {
        long nextEnsembleChange = this.startEntryId;
        long i = this.startEntryId;
        this.requestTimeNanos = MathUtils.nowInNano();
        List<BookieId> ensemble = null;
        do {
            if (i == nextEnsembleChange) {
                ensemble = this.getLedgerMetadata().getEnsembleAt(i);
                nextEnsembleChange = LedgerMetadataUtils.getNextEnsembleChange(this.getLedgerMetadata(), i);
            }
            SingleLedgerEntryRequest entry = this.parallelRead ? new ParallelReadRequest(ensemble, this.lh.ledgerId, i) : new SequenceReadRequest(ensemble, this.lh.ledgerId, i);
            this.seq.add(entry);
        } while (++i <= this.endEntryId);
        for (ReadOpBase.LedgerEntryRequest ledgerEntryRequest : this.seq) {
            ledgerEntryRequest.read();
            if (this.parallelRead || !this.clientCtx.getConf().readSpeculativeRequestPolicy.isPresent()) continue;
            this.speculativeTask = this.clientCtx.getConf().readSpeculativeRequestPolicy.get().initiateSpeculativeRequest(this.clientCtx.getScheduler(), ledgerEntryRequest);
        }
    }

    @Override
    public void readEntryComplete(int rc, long ledgerId, long entryId, ByteBuf buffer, Object ctx) {
        ReadOpBase.ReadContext rctx = (ReadOpBase.ReadContext)ctx;
        SingleLedgerEntryRequest entry = (SingleLedgerEntryRequest)rctx.entry;
        if (rc != 0) {
            entry.logErrorAndReattemptRead(rctx.bookieIndex, rctx.to, "Error: " + BKException.getMessage(rc), rc);
            return;
        }
        this.heardFromHosts.add(rctx.to);
        this.heardFromHostsBitSet.set(rctx.bookieIndex, true);
        buffer.retain();
        if (entry.complete(rctx.bookieIndex, rctx.to, buffer)) {
            if (!this.isRecoveryRead) {
                this.lh.updateLastConfirmed(rctx.getLastAddConfirmed(), 0L);
            }
            this.submitCallback(0);
        } else {
            buffer.release();
        }
        if (this.numPendingEntries < 0L) {
            LOG.error("Read too many values for ledger {} : [{}, {}].", new Object[]{ledgerId, this.startEntryId, this.endEntryId});
        }
    }

    @Override
    protected void submitCallback(int code) {
        if (0 == code) {
            --this.numPendingEntries;
            if (this.numPendingEntries != 0L) {
                return;
            }
        }
        if (!this.complete.compareAndSet(false, true)) {
            return;
        }
        this.cancelSpeculativeTask(true);
        long latencyNanos = MathUtils.elapsedNanos(this.requestTimeNanos);
        if (code != 0) {
            long firstUnread = -1L;
            Integer firstRc = null;
            for (ReadOpBase.LedgerEntryRequest ledgerEntryRequest : this.seq) {
                if (ledgerEntryRequest.isComplete()) continue;
                firstUnread = ledgerEntryRequest.eId;
                firstRc = ledgerEntryRequest.rc;
                break;
            }
            LOG.error("Read of ledger entry failed: L{} E{}-E{}, Sent to {}, Heard from {} : bitset = {}, Error = '{}'. First unread entry is ({}, rc = {})", new Object[]{this.lh.getId(), this.startEntryId, this.endEntryId, this.sentToHosts, this.heardFromHosts, this.heardFromHostsBitSet, BKException.getMessage(code), firstUnread, firstRc});
            this.clientCtx.getClientStats().getReadOpLogger().registerFailedEvent(latencyNanos, TimeUnit.NANOSECONDS);
            this.seq.forEach(ReadOpBase.LedgerEntryRequest::close);
            this.future.completeExceptionally(BKException.create(code));
        } else {
            this.clientCtx.getClientStats().getReadOpLogger().registerSuccessfulEvent(latencyNanos, TimeUnit.NANOSECONDS);
            this.future.complete(LedgerEntriesImpl.create(Lists.transform(this.seq, input -> input.entryImpl)));
        }
    }

    void sendReadTo(int bookieIndex, BookieId to, SingleLedgerEntryRequest entry) throws InterruptedException {
        if (this.lh.throttler != null) {
            this.lh.throttler.acquire();
        }
        if (this.isRecoveryRead) {
            int flags = 5;
            this.clientCtx.getBookieClient().readEntry(to, this.lh.ledgerId, entry.eId, this, new ReadOpBase.ReadContext(bookieIndex, to, entry), flags, this.lh.ledgerKey);
        } else {
            this.clientCtx.getBookieClient().readEntry(to, this.lh.ledgerId, entry.eId, this, new ReadOpBase.ReadContext(bookieIndex, to, entry), 0);
        }
    }

    class SequenceReadRequest
    extends SingleLedgerEntryRequest {
        static final int NOT_FOUND = -1;
        int nextReplicaIndexToReadFrom;
        final BitSet sentReplicas;
        final BitSet erroredReplicas;

        SequenceReadRequest(List<BookieId> ensemble, long lId, long eId) {
            super(ensemble, lId, eId);
            this.nextReplicaIndexToReadFrom = 0;
            this.sentReplicas = new BitSet(PendingReadOp.this.lh.getLedgerMetadata().getWriteQuorumSize());
            this.erroredReplicas = new BitSet(PendingReadOp.this.lh.getLedgerMetadata().getWriteQuorumSize());
        }

        private synchronized int getNextReplicaIndexToReadFrom() {
            return this.nextReplicaIndexToReadFrom;
        }

        private BitSet getSentToBitSet() {
            BitSet b = new BitSet(this.ensemble.size());
            for (int i = 0; i < this.sentReplicas.length(); ++i) {
                if (!this.sentReplicas.get(i)) continue;
                b.set(this.writeSet.get(i));
            }
            return b;
        }

        private boolean readsOutstanding() {
            return this.sentReplicas.cardinality() - this.erroredReplicas.cardinality() > 0;
        }

        @Override
        synchronized BookieId maybeSendSpeculativeRead(BitSet heardFrom) {
            if (this.nextReplicaIndexToReadFrom >= PendingReadOp.this.getLedgerMetadata().getWriteQuorumSize()) {
                return null;
            }
            BitSet sentTo = this.getSentToBitSet();
            sentTo.and(heardFrom);
            if (sentTo.cardinality() == 0) {
                PendingReadOp.this.clientCtx.getClientStats().getSpeculativeReadCounter().inc();
                return this.sendNextRead();
            }
            return null;
        }

        @Override
        void read() {
            this.sendNextRead();
        }

        synchronized BookieId sendNextRead() {
            if (this.nextReplicaIndexToReadFrom >= PendingReadOp.this.getLedgerMetadata().getWriteQuorumSize()) {
                this.fail(this.firstError);
                return null;
            }
            int replica = this.nextReplicaIndexToReadFrom;
            int bookieIndex = this.writeSet.get(this.nextReplicaIndexToReadFrom);
            ++this.nextReplicaIndexToReadFrom;
            try {
                BookieId to = (BookieId)this.ensemble.get(bookieIndex);
                PendingReadOp.this.sendReadTo(bookieIndex, to, this);
                PendingReadOp.this.sentToHosts.add(to);
                this.sentReplicas.set(replica);
                return to;
            }
            catch (InterruptedException ie) {
                LOG.error("Interrupted reading entry " + this, (Throwable)ie);
                Thread.currentThread().interrupt();
                this.fail(-15);
                return null;
            }
        }

        @Override
        synchronized void logErrorAndReattemptRead(int bookieIndex, BookieId host, String errMsg, int rc) {
            super.logErrorAndReattemptRead(bookieIndex, host, errMsg, rc);
            int replica = this.writeSet.indexOf(bookieIndex);
            if (replica == -1) {
                LOG.error("Received error from a host which is not in the ensemble {} {}.", (Object)host, (Object)this.ensemble);
                return;
            }
            this.erroredReplicas.set(replica);
            if (PendingReadOp.this.isRecoveryRead && this.numBookiesMissingEntry >= PendingReadOp.this.requiredBookiesMissingEntryForRecovery) {
                this.fail(-13);
                return;
            }
            if (!this.readsOutstanding()) {
                this.sendNextRead();
            }
        }

        @Override
        boolean complete(int bookieIndex, BookieId host, ByteBuf buffer) {
            boolean completed = super.complete(bookieIndex, host, buffer);
            if (completed) {
                int numReplicasTried = this.getNextReplicaIndexToReadFrom();
                for (int i = 0; i < numReplicasTried - 1; ++i) {
                    int slowBookieIndex = this.writeSet.get(i);
                    BookieId slowBookieSocketAddress = (BookieId)this.ensemble.get(slowBookieIndex);
                    PendingReadOp.this.clientCtx.getPlacementPolicy().registerSlowBookie(slowBookieSocketAddress, this.eId);
                }
            }
            return completed;
        }
    }

    class ParallelReadRequest
    extends SingleLedgerEntryRequest {
        int numPendings;

        ParallelReadRequest(List<BookieId> ensemble, long lId, long eId) {
            super(ensemble, lId, eId);
            this.numPendings = this.writeSet.size();
        }

        @Override
        void read() {
            for (int i = 0; i < this.writeSet.size(); ++i) {
                BookieId to = (BookieId)this.ensemble.get(this.writeSet.get(i));
                try {
                    PendingReadOp.this.sendReadTo(this.writeSet.get(i), to, this);
                    continue;
                }
                catch (InterruptedException ie) {
                    LOG.error("Interrupted reading entry {} : ", (Object)this, (Object)ie);
                    Thread.currentThread().interrupt();
                    this.fail(-15);
                    return;
                }
            }
        }

        @Override
        synchronized void logErrorAndReattemptRead(int bookieIndex, BookieId host, String errMsg, int rc) {
            super.logErrorAndReattemptRead(bookieIndex, host, errMsg, rc);
            --this.numPendings;
            if (PendingReadOp.this.isRecoveryRead && this.numBookiesMissingEntry >= PendingReadOp.this.requiredBookiesMissingEntryForRecovery) {
                this.fail(-13);
            } else if (this.numPendings == 0) {
                this.fail(this.firstError);
            }
        }

        @Override
        BookieId maybeSendSpeculativeRead(BitSet heardFromHostsBitSet) {
            return null;
        }
    }

    abstract class SingleLedgerEntryRequest
    extends ReadOpBase.LedgerEntryRequest {
        final LedgerEntryImpl entryImpl;

        SingleLedgerEntryRequest(List<BookieId> ensemble, long lId, long eId) {
            super(PendingReadOp.this, ensemble, eId);
            this.entryImpl = LedgerEntryImpl.create(lId, eId);
        }

        @Override
        public void close() {
            super.close();
            this.entryImpl.close();
        }

        boolean complete(int bookieIndex, BookieId host, ByteBuf buffer) {
            ByteBuf content;
            if (this.isComplete()) {
                return false;
            }
            try {
                content = PendingReadOp.this.lh.macManager.verifyDigestAndReturnData(this.eId, buffer);
            }
            catch (BKException.BKDigestMatchException e) {
                PendingReadOp.this.clientCtx.getClientStats().getReadOpDmCounter().inc();
                this.logErrorAndReattemptRead(bookieIndex, host, "Mac mismatch", -5);
                return false;
            }
            if (!this.complete.getAndSet(true)) {
                this.rc = 0;
                this.entryImpl.setLength(buffer.getLong(24));
                this.entryImpl.setEntryBuf(content);
                this.writeSet.recycle();
                return true;
            }
            return false;
        }
    }
}

