/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client;

import java.util.List;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBuf;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.BKException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.LedgerHandle;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.ReadLastConfirmedOp;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.net.BookieId;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.BookieClient;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.checksum.DigestManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TryReadLastConfirmedOp
implements BookkeeperInternalCallbacks.ReadEntryCallback {
    static final Logger LOG = LoggerFactory.getLogger(TryReadLastConfirmedOp.class);
    final LedgerHandle lh;
    final BookieClient bookieClient;
    final ReadLastConfirmedOp.LastConfirmedDataCallback cb;
    int numResponsesPending;
    volatile boolean hasValidResponse = false;
    volatile boolean completed = false;
    DigestManager.RecoveryData maxRecoveredData;
    final List<BookieId> currentEnsemble;

    TryReadLastConfirmedOp(LedgerHandle lh, BookieClient bookieClient, List<BookieId> ensemble, ReadLastConfirmedOp.LastConfirmedDataCallback cb, long lac) {
        this.lh = lh;
        this.bookieClient = bookieClient;
        this.cb = cb;
        this.maxRecoveredData = new DigestManager.RecoveryData(lac, 0L);
        this.numResponsesPending = lh.getLedgerMetadata().getEnsembleSize();
        this.currentEnsemble = ensemble;
    }

    public void initiate() {
        for (int i = 0; i < this.currentEnsemble.size(); ++i) {
            this.bookieClient.readEntry(this.currentEnsemble.get(i), this.lh.ledgerId, -1L, this, i, 0);
        }
    }

    @Override
    public void readEntryComplete(int rc, long ledgerId, long entryId, ByteBuf buffer, Object ctx) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("TryReadLastConfirmed received response for (lid={}, eid={}) : {}", new Object[]{ledgerId, entryId, rc});
        }
        int bookieIndex = (Integer)ctx;
        --this.numResponsesPending;
        if (0 == rc) {
            try {
                DigestManager.RecoveryData recoveryData = this.lh.macManager.verifyDigestAndReturnLastConfirmed(buffer);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Received lastAddConfirmed (lac={}, length={}) from bookie({}) for (lid={}).", new Object[]{recoveryData.getLastAddConfirmed(), recoveryData.getLength(), bookieIndex, ledgerId});
                }
                if (recoveryData.getLastAddConfirmed() > this.maxRecoveredData.getLastAddConfirmed()) {
                    this.maxRecoveredData = recoveryData;
                    this.cb.readLastConfirmedDataComplete(0, this.maxRecoveredData);
                }
                this.hasValidResponse = true;
            }
            catch (BKException.BKDigestMatchException e) {
                LOG.error("Mac mismatch for ledger: " + ledgerId + ", entry: " + entryId + " while reading last entry from bookie: " + this.currentEnsemble.get(bookieIndex));
            }
        } else if (-102 == rc && !this.completed) {
            this.cb.readLastConfirmedDataComplete(rc, this.maxRecoveredData);
            this.completed = true;
        } else if (-7 == rc || -13 == rc) {
            this.hasValidResponse = true;
        }
        if (this.numResponsesPending == 0 && !this.completed) {
            if (!this.hasValidResponse) {
                this.cb.readLastConfirmedDataComplete(-10, this.maxRecoveredData);
            } else {
                this.cb.readLastConfirmedDataComplete(0, this.maxRecoveredData);
            }
            this.completed = true;
        }
    }
}

