/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.api;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBuf;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.Unpooled;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.api.BKException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.api.ForceableHandle;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.api.ReadHandle;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.annotation.InterfaceStability;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.concurrent.FutureUtils;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public interface WriteHandle
extends ReadHandle,
ForceableHandle {
    public CompletableFuture<Long> appendAsync(ByteBuf var1);

    default public long append(ByteBuf data) throws BKException, InterruptedException {
        return FutureUtils.result(this.appendAsync(data), BKException.HANDLER);
    }

    default public CompletableFuture<Long> appendAsync(ByteBuffer data) {
        return this.appendAsync(Unpooled.wrappedBuffer(data));
    }

    default public long append(ByteBuffer data) throws BKException, InterruptedException {
        return this.append(Unpooled.wrappedBuffer(data));
    }

    default public CompletableFuture<Long> appendAsync(byte[] data) {
        return this.appendAsync(Unpooled.wrappedBuffer(data));
    }

    default public long append(byte[] data) throws BKException, InterruptedException {
        return this.append(Unpooled.wrappedBuffer(data));
    }

    default public CompletableFuture<Long> appendAsync(byte[] data, int offset, int length) {
        return this.appendAsync(Unpooled.wrappedBuffer(data, offset, length));
    }

    default public long append(byte[] data, int offset, int length) throws BKException, InterruptedException {
        return this.append(Unpooled.wrappedBuffer(data, offset, length));
    }

    public long getLastAddPushed();

    @Override
    public CompletableFuture<Void> closeAsync();

    @Override
    default public void close() throws BKException, InterruptedException {
        FutureUtils.result(this.closeAsync(), BKException.HANDLER);
    }
}

