/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.clients.utils;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.pulsar.functions.runtime.shaded.io.netty.util.HashedWheelTimer;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.util.SharedResourceManager;

public class ClientResources {
    private static final ClientResources SHARED = ClientResources.create();
    private final SharedResourceManager.Resource<OrderedScheduler> scheduler = new SharedResourceManager.Resource<OrderedScheduler>(){
        private static final String name = "client-scheduler";

        @Override
        public OrderedScheduler create() {
            return (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().numThreads(Runtime.getRuntime().availableProcessors() * 2).name(name).build();
        }

        @Override
        public void close(OrderedScheduler instance) {
            instance.shutdown();
        }

        public String toString() {
            return name;
        }
    };
    private final SharedResourceManager.Resource<HashedWheelTimer> timer = new SharedResourceManager.Resource<HashedWheelTimer>(){
        private static final String name = "client-timer";

        @Override
        public HashedWheelTimer create() {
            HashedWheelTimer timer = new HashedWheelTimer(new ThreadFactoryBuilder().setNameFormat("client-timer-%d").build(), 200L, TimeUnit.MILLISECONDS, 512, true);
            timer.start();
            return timer;
        }

        @Override
        public void close(HashedWheelTimer instance) {
            instance.stop();
        }

        public String toString() {
            return name;
        }
    };
    private final SharedResourceManager.Resource<ExecutorService> executor = new SharedResourceManager.Resource<ExecutorService>(){
        private static final String name = "stream-client-executor";

        @Override
        public ExecutorService create() {
            return Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2);
        }

        @Override
        public void close(ExecutorService instance) {
            instance.shutdown();
        }

        public String toString() {
            return name;
        }
    };

    public static ClientResources shared() {
        return SHARED;
    }

    public static ClientResources create() {
        return new ClientResources();
    }

    private ClientResources() {
    }

    public SharedResourceManager.Resource<OrderedScheduler> scheduler() {
        return this.scheduler;
    }

    public SharedResourceManager.Resource<HashedWheelTimer> timer() {
        return this.timer;
    }

    public SharedResourceManager.Resource<ExecutorService> executor() {
        return this.executor;
    }
}

