/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto;

import java.nio.ByteBuffer;
import org.apache.pulsar.functions.runtime.shaded.com.google.protobuf.ByteString;
import org.apache.pulsar.functions.runtime.shaded.com.google.protobuf.UnsafeByteOperations;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBuf;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.util.ByteBufList;

public class ByteStringUtil {
    public static ByteString byteBufListToByteString(ByteBufList bufList) {
        ByteString aggregated = null;
        for (int i = 0; i < bufList.size(); ++i) {
            ByteBuf buffer = bufList.getBuffer(i);
            if (buffer.readableBytes() <= 0) continue;
            aggregated = ByteStringUtil.byteBufToByteString(aggregated, buffer);
        }
        return aggregated != null ? aggregated : ByteString.EMPTY;
    }

    public static ByteString byteBufToByteString(ByteBuf byteBuf) {
        return ByteStringUtil.byteBufToByteString(null, byteBuf);
    }

    private static ByteString byteBufToByteString(ByteString aggregated, ByteBuf byteBuf) {
        if (byteBuf.readableBytes() == 0) {
            return ByteString.EMPTY;
        }
        if (byteBuf.nioBufferCount() > 1) {
            for (ByteBuffer nioBuffer : byteBuf.nioBuffers()) {
                ByteString piece = UnsafeByteOperations.unsafeWrap(nioBuffer);
                aggregated = aggregated == null ? piece : aggregated.concat(piece);
            }
        } else {
            ByteString piece = byteBuf.hasArray() ? UnsafeByteOperations.unsafeWrap(byteBuf.array(), byteBuf.arrayOffset() + byteBuf.readerIndex(), byteBuf.readableBytes()) : UnsafeByteOperations.unsafeWrap(byteBuf.nioBuffer());
            aggregated = aggregated == null ? piece : aggregated.concat(piece);
        }
        return aggregated;
    }
}

