/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.cli.commands.bookies;

import java.util.Iterator;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.util.concurrent.UncheckedExecutionException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.BKException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.util.JsonUtil;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.UnderreplicatedLedger;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.net.BookieId;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.framework.CliSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterInfoCommand
extends BookieCommand<CliFlags> {
    private static final String NAME = "cluster-info";
    private static final String DESC = "Exposes the current info about the cluster of bookies";
    private static final Logger LOG = LoggerFactory.getLogger(ClusterInfoCommand.class);
    private ClusterInfo info;

    public ClusterInfoCommand() {
        super(CliSpec.newBuilder().withName(NAME).withFlags(new CliFlags()).withDescription(DESC).build());
    }

    @VisibleForTesting
    public static ClusterInfoCommand newClusterInfoCommand() {
        return new ClusterInfoCommand();
    }

    @Override
    public boolean apply(ServerConfiguration conf, CliFlags cmdFlags) {
        ClientConfiguration clientConfiguration = new ClientConfiguration(conf);
        try (BookKeeperAdmin admin = new BookKeeperAdmin(clientConfiguration);){
            LOG.info("Starting fill cluster info.");
            this.info = new ClusterInfo();
            this.fillUReplicatedInfo(this.info, conf);
            this.fillAuditorInfo(this.info, admin);
            this.fillBookiesInfo(this.info, admin);
            LOG.info("--------- Cluster Info ---------");
            LOG.info("{}", (Object)JsonUtil.toJson(this.info));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private void fillBookiesInfo(ClusterInfo info, BookKeeperAdmin bka) throws BKException {
        int totalBookiesCount = bka.getAllBookies().size();
        int writableBookiesCount = bka.getAvailableBookies().size();
        int readonlyBookiesCount = bka.getReadOnlyBookies().size();
        int unavailableBookiesCount = totalBookiesCount - writableBookiesCount - readonlyBookiesCount;
        info.setTotalBookiesCount(totalBookiesCount);
        info.setWritableBookiesCount(writableBookiesCount);
        info.setReadonlyBookiesCount(readonlyBookiesCount);
        info.setUnavailableBookiesCount(unavailableBookiesCount);
    }

    private void fillAuditorInfo(ClusterInfo info, BookKeeperAdmin bka) {
        try {
            BookieId currentAuditor = bka.getCurrentAuditor();
            info.setAuditorElected(currentAuditor != null);
            info.setAuditorId(currentAuditor == null ? "" : currentAuditor.getId());
        }
        catch (Exception e) {
            LOG.error("Could not get Auditor info", (Throwable)e);
            info.setAuditorElected(false);
            info.setAuditorId("");
        }
    }

    private void fillUReplicatedInfo(ClusterInfo info, ServerConfiguration conf) throws Exception {
        MetadataDrivers.runFunctionWithLedgerManagerFactory(conf, mFactory -> {
            try (LedgerUnderreplicationManager underreplicationManager = mFactory.newLedgerUnderreplicationManager();){
                Iterator<UnderreplicatedLedger> iter = underreplicationManager.listLedgersToRereplicate(null);
                info.setClusterUnderReplicated(iter.hasNext());
                info.setLedgerReplicationEnabled(underreplicationManager.isLedgerReplicationEnabled());
            }
            catch (Exception e) {
                throw new UncheckedExecutionException(e);
            }
            return null;
        });
    }

    @VisibleForTesting
    public ClusterInfo info() {
        return this.info;
    }

    public static class ClusterInfo {
        private boolean auditorElected;
        private String auditorId;
        private boolean clusterUnderReplicated;
        private boolean ledgerReplicationEnabled;
        private int totalBookiesCount;
        private int writableBookiesCount;
        private int readonlyBookiesCount;
        private int unavailableBookiesCount;

        public boolean isAuditorElected() {
            return this.auditorElected;
        }

        public String getAuditorId() {
            return this.auditorId;
        }

        public boolean isClusterUnderReplicated() {
            return this.clusterUnderReplicated;
        }

        public boolean isLedgerReplicationEnabled() {
            return this.ledgerReplicationEnabled;
        }

        public int getTotalBookiesCount() {
            return this.totalBookiesCount;
        }

        public int getWritableBookiesCount() {
            return this.writableBookiesCount;
        }

        public int getReadonlyBookiesCount() {
            return this.readonlyBookiesCount;
        }

        public int getUnavailableBookiesCount() {
            return this.unavailableBookiesCount;
        }

        public void setAuditorElected(boolean auditorElected) {
            this.auditorElected = auditorElected;
        }

        public void setAuditorId(String auditorId) {
            this.auditorId = auditorId;
        }

        public void setClusterUnderReplicated(boolean clusterUnderReplicated) {
            this.clusterUnderReplicated = clusterUnderReplicated;
        }

        public void setLedgerReplicationEnabled(boolean ledgerReplicationEnabled) {
            this.ledgerReplicationEnabled = ledgerReplicationEnabled;
        }

        public void setTotalBookiesCount(int totalBookiesCount) {
            this.totalBookiesCount = totalBookiesCount;
        }

        public void setWritableBookiesCount(int writableBookiesCount) {
            this.writableBookiesCount = writableBookiesCount;
        }

        public void setReadonlyBookiesCount(int readonlyBookiesCount) {
            this.readonlyBookiesCount = readonlyBookiesCount;
        }

        public void setUnavailableBookiesCount(int unavailableBookiesCount) {
            this.unavailableBookiesCount = unavailableBookiesCount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClusterInfo)) {
                return false;
            }
            ClusterInfo other = (ClusterInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isAuditorElected() != other.isAuditorElected()) {
                return false;
            }
            if (this.isClusterUnderReplicated() != other.isClusterUnderReplicated()) {
                return false;
            }
            if (this.isLedgerReplicationEnabled() != other.isLedgerReplicationEnabled()) {
                return false;
            }
            if (this.getTotalBookiesCount() != other.getTotalBookiesCount()) {
                return false;
            }
            if (this.getWritableBookiesCount() != other.getWritableBookiesCount()) {
                return false;
            }
            if (this.getReadonlyBookiesCount() != other.getReadonlyBookiesCount()) {
                return false;
            }
            if (this.getUnavailableBookiesCount() != other.getUnavailableBookiesCount()) {
                return false;
            }
            String this$auditorId = this.getAuditorId();
            String other$auditorId = other.getAuditorId();
            return !(this$auditorId == null ? other$auditorId != null : !this$auditorId.equals(other$auditorId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ClusterInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAuditorElected() ? 79 : 97);
            result = result * 59 + (this.isClusterUnderReplicated() ? 79 : 97);
            result = result * 59 + (this.isLedgerReplicationEnabled() ? 79 : 97);
            result = result * 59 + this.getTotalBookiesCount();
            result = result * 59 + this.getWritableBookiesCount();
            result = result * 59 + this.getReadonlyBookiesCount();
            result = result * 59 + this.getUnavailableBookiesCount();
            String $auditorId = this.getAuditorId();
            result = result * 59 + ($auditorId == null ? 43 : $auditorId.hashCode());
            return result;
        }

        public String toString() {
            return "ClusterInfoCommand.ClusterInfo(auditorElected=" + this.isAuditorElected() + ", auditorId=" + this.getAuditorId() + ", clusterUnderReplicated=" + this.isClusterUnderReplicated() + ", ledgerReplicationEnabled=" + this.isLedgerReplicationEnabled() + ", totalBookiesCount=" + this.getTotalBookiesCount() + ", writableBookiesCount=" + this.getWritableBookiesCount() + ", readonlyBookiesCount=" + this.getReadonlyBookiesCount() + ", unavailableBookiesCount=" + this.getUnavailableBookiesCount() + ")";
        }
    }
}

