/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.util.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Consumer;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Preconditions;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.collect.Lists;

public class ConcurrentOpenHashSet<V> {
    private static final Object EmptyValue = null;
    private static final Object DeletedValue = new Object();
    private static final int DefaultExpectedItems = 256;
    private static final int DefaultConcurrencyLevel = 16;
    private static final float DefaultMapFillFactor = 0.66f;
    private static final float DefaultMapIdleFactor = 0.15f;
    private static final float DefaultExpandFactor = 2.0f;
    private static final float DefaultShrinkFactor = 2.0f;
    private static final boolean DefaultAutoShrink = false;
    private final Section<V>[] sections;
    private static final long HashMixer = -4132994306676758123L;
    private static final int R = 47;

    public static <V> Builder<V> newBuilder() {
        return new Builder();
    }

    @Deprecated
    public ConcurrentOpenHashSet() {
        this(256);
    }

    @Deprecated
    public ConcurrentOpenHashSet(int expectedItems) {
        this(expectedItems, 16);
    }

    @Deprecated
    public ConcurrentOpenHashSet(int expectedItems, int concurrencyLevel) {
        this(expectedItems, concurrencyLevel, 0.66f, 0.15f, false, 2.0f, 2.0f);
    }

    public ConcurrentOpenHashSet(int expectedItems, int concurrencyLevel, float mapFillFactor, float mapIdleFactor, boolean autoShrink, float expandFactor, float shrinkFactor) {
        Preconditions.checkArgument(expectedItems > 0);
        Preconditions.checkArgument(concurrencyLevel > 0);
        Preconditions.checkArgument(expectedItems >= concurrencyLevel);
        Preconditions.checkArgument(mapFillFactor > 0.0f && mapFillFactor < 1.0f);
        Preconditions.checkArgument(mapIdleFactor > 0.0f && mapIdleFactor < 1.0f);
        Preconditions.checkArgument(mapFillFactor > mapIdleFactor);
        Preconditions.checkArgument(expandFactor > 1.0f);
        Preconditions.checkArgument(shrinkFactor > 1.0f);
        int numSections = concurrencyLevel;
        int perSectionExpectedItems = expectedItems / numSections;
        int perSectionCapacity = (int)((float)perSectionExpectedItems / mapFillFactor);
        this.sections = new Section[numSections];
        for (int i = 0; i < numSections; ++i) {
            this.sections[i] = new Section(perSectionCapacity, mapFillFactor, mapIdleFactor, autoShrink, expandFactor, shrinkFactor);
        }
    }

    public long size() {
        long size = 0L;
        for (Section<V> s : this.sections) {
            size += (long)((Section)s).size;
        }
        return size;
    }

    public long capacity() {
        long capacity = 0L;
        for (Section<V> s : this.sections) {
            capacity += (long)((Section)s).capacity;
        }
        return capacity;
    }

    long getUsedBucketCount() {
        long usedBucketCount = 0L;
        for (Section<V> s : this.sections) {
            usedBucketCount += (long)((Section)s).usedBuckets;
        }
        return usedBucketCount;
    }

    public boolean isEmpty() {
        for (Section<V> s : this.sections) {
            if (((Section)s).size == 0) continue;
            return false;
        }
        return true;
    }

    public boolean contains(V value) {
        Preconditions.checkNotNull(value);
        long h = ConcurrentOpenHashSet.hash(value);
        return this.getSection(h).contains(value, (int)h);
    }

    public boolean add(V value) {
        Preconditions.checkNotNull(value);
        long h = ConcurrentOpenHashSet.hash(value);
        return this.getSection(h).add(value, (int)h);
    }

    public boolean remove(V value) {
        Preconditions.checkNotNull(value);
        long h = ConcurrentOpenHashSet.hash(value);
        return ((Section)this.getSection(h)).remove(value, (int)h);
    }

    private Section<V> getSection(long hash) {
        int sectionIdx = (int)(hash >>> 32) & this.sections.length - 1;
        return this.sections[sectionIdx];
    }

    public void clear() {
        for (Section<V> s : this.sections) {
            s.clear();
        }
    }

    public void forEach(Consumer<? super V> processor) {
        for (Section<? super V> section : this.sections) {
            section.forEach(processor);
        }
    }

    List<V> values() {
        ArrayList values = Lists.newArrayList();
        this.forEach(value -> values.add(value));
        return values;
    }

    static final <K> long hash(K key) {
        long hash = (long)key.hashCode() * -4132994306676758123L;
        hash ^= hash >>> 47;
        return hash *= -4132994306676758123L;
    }

    static final int signSafeMod(long n, int max) {
        return (int)n & max - 1;
    }

    private static int alignToPowerOfTwo(int n) {
        return (int)Math.pow(2.0, 32 - Integer.numberOfLeadingZeros(n - 1));
    }

    private static final class Section<V>
    extends StampedLock {
        private volatile V[] values;
        private volatile int capacity;
        private final int initCapacity;
        private volatile int size;
        private int usedBuckets;
        private int resizeThresholdUp;
        private int resizeThresholdBelow;
        private final float mapFillFactor;
        private final float mapIdleFactor;
        private final float expandFactor;
        private final float shrinkFactor;
        private final boolean autoShrink;

        Section(int capacity, float mapFillFactor, float mapIdleFactor, boolean autoShrink, float expandFactor, float shrinkFactor) {
            this.initCapacity = this.capacity = ConcurrentOpenHashSet.alignToPowerOfTwo(capacity);
            this.values = new Object[this.capacity];
            this.size = 0;
            this.usedBuckets = 0;
            this.autoShrink = autoShrink;
            this.mapFillFactor = mapFillFactor;
            this.mapIdleFactor = mapIdleFactor;
            this.expandFactor = expandFactor;
            this.shrinkFactor = shrinkFactor;
            this.resizeThresholdUp = (int)((float)this.capacity * mapFillFactor);
            this.resizeThresholdBelow = (int)((float)this.capacity * mapIdleFactor);
        }

        boolean contains(V value, int keyHash) {
            long stamp = this.tryOptimisticRead();
            boolean acquiredLock = false;
            V[] values = this.values;
            int bucket = ConcurrentOpenHashSet.signSafeMod(keyHash, values.length);
            try {
                while (true) {
                    V storedValue = values[bucket];
                    if (!acquiredLock && this.validate(stamp)) {
                        if (value.equals(storedValue)) {
                            boolean bl = true;
                            return bl;
                        }
                        if (storedValue == EmptyValue) {
                            boolean bl = false;
                            return bl;
                        }
                    } else {
                        if (!acquiredLock) {
                            stamp = this.readLock();
                            acquiredLock = true;
                            values = this.values;
                            bucket = ConcurrentOpenHashSet.signSafeMod(keyHash, values.length);
                            storedValue = values[bucket];
                        }
                        if (value.equals(storedValue)) {
                            boolean bl = true;
                            return bl;
                        }
                        if (storedValue == EmptyValue) {
                            boolean bl = false;
                            return bl;
                        }
                    }
                    bucket = bucket + 1 & values.length - 1;
                }
            }
            finally {
                if (acquiredLock) {
                    this.unlockRead(stamp);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean add(V value, int keyHash) {
            int bucket = keyHash;
            long stamp = this.writeLock();
            int capacity = this.capacity;
            int firstDeletedValue = -1;
            try {
                while (true) {
                    V storedValue;
                    if (value.equals(storedValue = this.values[bucket = ConcurrentOpenHashSet.signSafeMod(bucket, capacity)])) {
                        boolean bl = false;
                        return bl;
                    }
                    if (storedValue == EmptyValue) {
                        if (firstDeletedValue != -1) {
                            bucket = firstDeletedValue;
                        } else {
                            ++this.usedBuckets;
                        }
                        this.values[bucket] = value;
                        ++this.size;
                        boolean bl = true;
                        return bl;
                    }
                    if (storedValue == DeletedValue && firstDeletedValue == -1) {
                        firstDeletedValue = bucket;
                    }
                    ++bucket;
                }
            }
            finally {
                if (this.usedBuckets > this.resizeThresholdUp) {
                    try {
                        int newCapacity = ConcurrentOpenHashSet.alignToPowerOfTwo((int)((float)capacity * this.expandFactor));
                        this.rehash(newCapacity);
                    }
                    finally {
                        this.unlockWrite(stamp);
                    }
                } else {
                    this.unlockWrite(stamp);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private boolean remove(V value, int keyHash) {
            bucket = keyHash;
            stamp = this.writeLock();
            try {
                while (true) {
                    if (value.equals(storedValue = this.values[bucket = ConcurrentOpenHashSet.signSafeMod(bucket, capacity = this.capacity)])) {
                        --this.size;
                        nextInArray = ConcurrentOpenHashSet.signSafeMod(bucket + 1, capacity);
                        if (this.values[nextInArray] == ConcurrentOpenHashSet.access$500()) {
                            this.values[bucket] = ConcurrentOpenHashSet.access$500();
                            --this.usedBuckets;
                            lastBucket = ConcurrentOpenHashSet.signSafeMod(bucket - 1, capacity);
                            while (this.values[lastBucket] == ConcurrentOpenHashSet.access$600()) {
                                this.values[lastBucket] = ConcurrentOpenHashSet.access$500();
                                --this.usedBuckets;
                                --lastBucket;
                                lastBucket = ConcurrentOpenHashSet.signSafeMod(lastBucket, capacity);
                            }
                        } else {
                            this.values[bucket] = ConcurrentOpenHashSet.access$600();
                        }
                        lastBucket = 1;
                        return (boolean)lastBucket;
                    }
                    if (storedValue == ConcurrentOpenHashSet.access$500()) {
                        var8_8 = false;
                        return var8_8;
                    }
                    ++bucket;
                }
            }
            finally {
                if (this.autoShrink && this.size < this.resizeThresholdBelow) {
                    try {
                        newCapacity = Math.max(ConcurrentOpenHashSet.access$400((int)((float)this.capacity / this.shrinkFactor)), this.initCapacity);
                        newResizeThresholdUp = (int)((float)newCapacity * this.mapFillFactor);
                        if (newCapacity >= this.capacity || newResizeThresholdUp <= this.size) ** GOTO lbl39
                        this.rehash(newCapacity);
                    }
                    finally {
                        this.unlockWrite(stamp);
                    }
                } else {
                    this.unlockWrite(stamp);
                }
lbl39:
                // 3 sources

            }
        }

        void clear() {
            long stamp = this.writeLock();
            try {
                if (this.autoShrink && this.capacity > this.initCapacity) {
                    this.shrinkToInitCapacity();
                } else {
                    Arrays.fill(this.values, EmptyValue);
                    this.size = 0;
                    this.usedBuckets = 0;
                }
            }
            finally {
                this.unlockWrite(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forEach(Consumer<? super V> processor) {
            long stamp = this.tryOptimisticRead();
            int capacity = this.capacity;
            V[] values = this.values;
            boolean acquiredReadLock = false;
            try {
                if (!this.validate(stamp)) {
                    stamp = this.readLock();
                    acquiredReadLock = true;
                    capacity = this.capacity;
                    values = this.values;
                }
                for (int bucket = 0; bucket < capacity; ++bucket) {
                    V storedValue = values[bucket];
                    if (!acquiredReadLock && !this.validate(stamp)) {
                        stamp = this.readLock();
                        acquiredReadLock = true;
                        storedValue = values[bucket];
                    }
                    if (storedValue == DeletedValue || storedValue == EmptyValue) continue;
                    processor.accept(storedValue);
                }
            }
            finally {
                if (acquiredReadLock) {
                    this.unlockRead(stamp);
                }
            }
        }

        private void rehash(int newCapacity) {
            Object[] newValues = new Object[newCapacity];
            for (int i = 0; i < this.values.length; ++i) {
                V storedValue = this.values[i];
                if (storedValue == EmptyValue || storedValue == DeletedValue) continue;
                Section.insertValueNoLock(newValues, storedValue);
            }
            this.values = newValues;
            this.usedBuckets = this.size;
            this.capacity = newCapacity;
            this.resizeThresholdUp = (int)((float)this.capacity * this.mapFillFactor);
            this.resizeThresholdBelow = (int)((float)this.capacity * this.mapIdleFactor);
        }

        private void shrinkToInitCapacity() {
            Object[] newValues = new Object[this.initCapacity];
            this.values = newValues;
            this.size = 0;
            this.usedBuckets = 0;
            this.capacity = this.initCapacity;
            this.resizeThresholdUp = (int)((float)this.capacity * this.mapFillFactor);
            this.resizeThresholdBelow = (int)((float)this.capacity * this.mapIdleFactor);
        }

        private static <V> void insertValueNoLock(V[] values, V value) {
            int bucket = (int)ConcurrentOpenHashSet.hash(value);
            while (true) {
                V storedValue;
                if ((storedValue = values[bucket = ConcurrentOpenHashSet.signSafeMod(bucket, values.length)]) == EmptyValue) {
                    values[bucket] = value;
                    return;
                }
                ++bucket;
            }
        }
    }

    public static class Builder<V> {
        int expectedItems = 256;
        int concurrencyLevel = 16;
        float mapFillFactor = 0.66f;
        float mapIdleFactor = 0.15f;
        float expandFactor = 2.0f;
        float shrinkFactor = 2.0f;
        boolean autoShrink = false;

        public Builder<V> expectedItems(int expectedItems) {
            this.expectedItems = expectedItems;
            return this;
        }

        public Builder<V> concurrencyLevel(int concurrencyLevel) {
            this.concurrencyLevel = concurrencyLevel;
            return this;
        }

        public Builder<V> mapFillFactor(float mapFillFactor) {
            this.mapFillFactor = mapFillFactor;
            return this;
        }

        public Builder<V> mapIdleFactor(float mapIdleFactor) {
            this.mapIdleFactor = mapIdleFactor;
            return this;
        }

        public Builder<V> expandFactor(float expandFactor) {
            this.expandFactor = expandFactor;
            return this;
        }

        public Builder<V> shrinkFactor(float shrinkFactor) {
            this.shrinkFactor = shrinkFactor;
            return this;
        }

        public Builder<V> autoShrink(boolean autoShrink) {
            this.autoShrink = autoShrink;
            return this;
        }

        public ConcurrentOpenHashSet<V> build() {
            return new ConcurrentOpenHashSet(this.expectedItems, this.concurrencyLevel, this.mapFillFactor, this.mapIdleFactor, this.autoShrink, this.expandFactor, this.shrinkFactor);
        }
    }
}

