/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.zookeeper;

import java.util.Random;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.zookeeper.RetryPolicy;

public class ExponentialBackoffRetryPolicy
implements RetryPolicy {
    private final Random random;
    private final int maxRetries;
    private final long baseBackoffTime;

    public ExponentialBackoffRetryPolicy(long baseBackoffTime, int maxRetries) {
        this.maxRetries = maxRetries;
        this.baseBackoffTime = baseBackoffTime;
        this.random = new Random(System.currentTimeMillis());
    }

    @Override
    public boolean allowRetry(int retryCount, long elapsedRetryTime) {
        return retryCount <= this.maxRetries;
    }

    @Override
    public long nextRetryWaitTime(int retryCount, long elapsedRetryTime) {
        return this.baseBackoffTime * (long)Math.max(1, this.random.nextInt(Math.max(1, 1 << retryCount + 1)));
    }
}

