/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.utils.io;

import java.nio.file.Path;
import java.util.List;
import org.apache.pulsar.common.io.ConfigFieldDefinition;
import org.apache.pulsar.common.io.ConnectorDefinition;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.functions.utils.FunctionFilePackage;
import org.apache.pulsar.functions.utils.ValidatableFunctionPackage;
import org.apache.pulsar.functions.utils.io.ConnectorUtils;

public class Connector
implements AutoCloseable {
    private final Path archivePath;
    private final String narExtractionDirectory;
    private final boolean enableClassloading;
    private ValidatableFunctionPackage connectorFunctionPackage;
    private List<ConfigFieldDefinition> sourceConfigFieldDefinitions;
    private List<ConfigFieldDefinition> sinkConfigFieldDefinitions;
    private ConnectorDefinition connectorDefinition;
    private boolean closed;

    public Connector(Path archivePath, ConnectorDefinition connectorDefinition, String narExtractionDirectory, boolean enableClassloading) {
        this.archivePath = archivePath;
        this.connectorDefinition = connectorDefinition;
        this.narExtractionDirectory = narExtractionDirectory;
        this.enableClassloading = enableClassloading;
    }

    public Path getArchivePath() {
        return this.archivePath;
    }

    public synchronized ValidatableFunctionPackage getConnectorFunctionPackage() {
        this.checkState();
        if (this.connectorFunctionPackage == null) {
            this.connectorFunctionPackage = new FunctionFilePackage(this.archivePath.toFile(), this.narExtractionDirectory, this.enableClassloading, ConnectorDefinition.class);
        }
        return this.connectorFunctionPackage;
    }

    private void checkState() {
        if (this.closed) {
            throw new IllegalStateException("Connector is already closed");
        }
    }

    public synchronized List<ConfigFieldDefinition> getSourceConfigFieldDefinitions() {
        this.checkState();
        if (this.sourceConfigFieldDefinitions == null && !StringUtils.isEmpty(this.connectorDefinition.getSourceClass()) && !StringUtils.isEmpty(this.connectorDefinition.getSourceConfigClass())) {
            this.sourceConfigFieldDefinitions = ConnectorUtils.getConnectorConfigDefinition(this.getConnectorFunctionPackage(), this.connectorDefinition.getSourceConfigClass());
        }
        return this.sourceConfigFieldDefinitions;
    }

    public synchronized List<ConfigFieldDefinition> getSinkConfigFieldDefinitions() {
        this.checkState();
        if (this.sinkConfigFieldDefinitions == null && !StringUtils.isEmpty(this.connectorDefinition.getSinkClass()) && !StringUtils.isEmpty(this.connectorDefinition.getSinkConfigClass())) {
            this.sinkConfigFieldDefinitions = ConnectorUtils.getConnectorConfigDefinition(this.getConnectorFunctionPackage(), this.connectorDefinition.getSinkConfigClass());
        }
        return this.sinkConfigFieldDefinitions;
    }

    public ConnectorDefinition getConnectorDefinition() {
        return this.connectorDefinition;
    }

    @Override
    public synchronized void close() throws Exception {
        this.closed = true;
        if (this.connectorFunctionPackage instanceof AutoCloseable) {
            ((AutoCloseable)((Object)this.connectorFunctionPackage)).close();
        }
    }
}

