/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl;

import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.channel.ChannelPipeline;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.channel.EventLoop;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.DecoderResult;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.compression.Brotli;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.compression.ZlibCodecFactory;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.DefaultHttpContent;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.DefaultHttpHeaders;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.DefaultHttpRequest;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.DefaultLastHttpContent;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.FullHttpRequest;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.HttpContent;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.HttpContentDecompressor;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderValues;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.HttpMessage;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.HttpObject;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.HttpRequest;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.HttpResponse;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.HttpUtil;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.LastHttpContent;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocket07FrameDecoder;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocket08FrameDecoder;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocket13FrameDecoder;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker00;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker07;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker08;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker13;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtensionHandler;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtensionHandshaker;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.extensions.compression.DeflateFrameClientExtensionHandshaker;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateClientExtensionHandshaker;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.timeout.IdleStateEvent;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.util.ReferenceCountUtil;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.util.concurrent.FutureListener;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.AsyncResult;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Future;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Handler;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.MultiMap;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Promise;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.VertxException;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.buffer.Buffer;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.HttpClientOptions;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.HttpClientRequest;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.HttpFrame;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.HttpHeaders;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.HttpMethod;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.HttpVersion;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.StreamPriority;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.WebSocket;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.WebsocketVersion;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.AssembledFullHttpRequest;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.AssembledHttpRequest;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.Http1xConnectionBase;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.HttpClientBase;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.HttpClientConnection;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.HttpClientImpl;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.HttpClientPush;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.HttpClientStream;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.HttpRequestHead;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.HttpResponseHead;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.HttpUtils;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.WebSocketHandshakeInboundHandler;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.WebSocketImpl;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.headers.HeadersAdaptor;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.ContextInternal;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.future.PromiseInternal;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.logging.Logger;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.logging.LoggerFactory;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.SocketAddress;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.impl.NetSocketImpl;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.impl.NetSocketInternal;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.impl.VertxHandler;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.metrics.ClientMetrics;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.metrics.HttpClientMetrics;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.tracing.SpanKind;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.tracing.TagExtractor;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.tracing.VertxTracer;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.streams.WriteStream;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.streams.impl.InboundBuffer;

public class Http1xClientConnection
extends Http1xConnectionBase<WebSocketImpl>
implements HttpClientConnection {
    private static final Logger log = LoggerFactory.getLogger(Http1xClientConnection.class);
    private static final Handler<Object> INVALID_MSG_HANDLER = msg -> {
        ReferenceCountUtil.release((Object)msg);
        throw new IllegalStateException("Invalid object " + msg);
    };
    private final HttpClientBase client;
    private final HttpClientOptions options;
    private final boolean ssl;
    private final SocketAddress server;
    public final ClientMetrics metrics;
    private final HttpVersion version;
    private final long lowWaterMark;
    private final long highWaterMark;
    private Deque<Stream> requests = new ArrayDeque<Stream>();
    private Deque<Stream> responses = new ArrayDeque<Stream>();
    private boolean closed;
    private boolean evicted;
    private Handler<Void> evictionHandler = DEFAULT_EVICTION_HANDLER;
    private Handler<Object> invalidMessageHandler = INVALID_MSG_HANDLER;
    private boolean close;
    private boolean shutdown;
    private long shutdownTimerID = -1L;
    private boolean isConnect;
    private int keepAliveTimeout;
    private long expirationTimestamp;
    private int seq = 1;
    private long readWindow;
    private long writeWindow;
    private boolean writeOverflow;
    private long lastResponseReceivedTimestamp;

    Http1xClientConnection(HttpVersion version, HttpClientBase client, ChannelHandlerContext channel, boolean ssl, SocketAddress server, ContextInternal context, ClientMetrics metrics) {
        super(context, channel);
        this.client = client;
        this.options = client.options();
        this.ssl = ssl;
        this.server = server;
        this.metrics = metrics;
        this.version = version;
        this.readWindow = 0L;
        this.writeWindow = 0L;
        this.highWaterMark = channel.channel().config().getWriteBufferHighWaterMark();
        this.lowWaterMark = channel.channel().config().getWriteBufferLowWaterMark();
        this.keepAliveTimeout = this.options.getKeepAliveTimeout();
        this.expirationTimestamp = Http1xClientConnection.expirationTimestampOf(this.keepAliveTimeout);
    }

    @Override
    public HttpClientConnection evictionHandler(Handler<Void> handler) {
        this.evictionHandler = handler;
        return this;
    }

    @Override
    public HttpClientConnection concurrencyChangeHandler(Handler<Long> handler) {
        return this;
    }

    @Override
    public long concurrency() {
        return this.options.isPipelining() ? (long)this.options.getPipeliningLimit() : 1L;
    }

    @Override
    public synchronized long activeStreams() {
        return this.requests.isEmpty() && this.responses.isEmpty() ? 0L : 1L;
    }

    public NetSocketInternal toNetSocket() {
        this.evictionHandler.handle(null);
        this.chctx.pipeline().replace("handler", "handler", VertxHandler.create(ctx -> {
            NetSocketImpl socket = new NetSocketImpl(this.context, (ChannelHandlerContext)ctx, null, this.metrics(), false);
            socket.metric(this.metric());
            return socket;
        }));
        VertxHandler handler = (VertxHandler)this.chctx.pipeline().get(VertxHandler.class);
        return (NetSocketInternal)handler.getConnection();
    }

    private HttpRequest createRequest(HttpMethod method, String uri, MultiMap headerMap, String authority, boolean chunked, ByteBuf buf, boolean end) {
        Object request = new DefaultHttpRequest(HttpUtils.toNettyHttpVersion(this.version), method.toNetty(), uri, false);
        org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaders headers = request.headers();
        if (headerMap != null) {
            for (Map.Entry header : headerMap) {
                headers.add((String)header.getKey(), header.getValue());
            }
        }
        if (!headers.contains(HttpHeaders.HOST)) {
            request.headers().set(HttpHeaders.HOST, (Object)authority);
        } else {
            headers.remove(HttpHeaders.TRANSFER_ENCODING);
        }
        if (chunked) {
            HttpUtil.setTransferEncodingChunked((HttpMessage)request, (boolean)true);
        }
        if (this.options.isDecompressionSupported() && request.headers().get(HttpHeaders.ACCEPT_ENCODING) == null) {
            CharSequence acceptEncoding = Http1xClientConnection.determineCompressionAcceptEncoding();
            request.headers().set(HttpHeaders.ACCEPT_ENCODING, (Object)acceptEncoding);
        }
        if (!this.options.isKeepAlive() && this.options.getProtocolVersion() == HttpVersion.HTTP_1_1) {
            request.headers().set(HttpHeaders.CONNECTION, (Object)HttpHeaders.CLOSE);
        } else if (this.options.isKeepAlive() && this.options.getProtocolVersion() == HttpVersion.HTTP_1_0) {
            request.headers().set(HttpHeaders.CONNECTION, (Object)HttpHeaders.KEEP_ALIVE);
        }
        if (end) {
            request = buf != null ? new AssembledFullHttpRequest((HttpRequest)request, buf) : new AssembledFullHttpRequest((HttpRequest)request);
        } else if (buf != null) {
            request = new AssembledHttpRequest((HttpRequest)request, buf);
        }
        return request;
    }

    static CharSequence determineCompressionAcceptEncoding() {
        if (Http1xClientConnection.isBrotliAvailable()) {
            return HttpHeaders.DEFLATE_GZIP_BR;
        }
        return HttpHeaders.DEFLATE_GZIP;
    }

    private static boolean isBrotliAvailable() {
        return Brotli.isAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginRequest(Stream stream, HttpRequestHead request, boolean chunked, ByteBuf buf, boolean end, boolean connect, Handler<AsyncResult<Void>> handler) {
        request.id = stream.id;
        request.remoteAddress = this.remoteAddress();
        Stream stream2 = stream;
        stream2.bytesWritten = stream2.bytesWritten + (buf != null ? (long)buf.readableBytes() : 0L);
        HttpRequest nettyRequest = this.createRequest(request.method, request.uri, request.headers, request.authority, chunked, buf, end);
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            VertxTracer tracer;
            this.responses.add(stream);
            this.isConnect = connect;
            if (this.metrics != null) {
                stream.metric = this.metrics.requestBegin(request.uri, request);
            }
            if ((tracer = this.context.tracer()) != null) {
                BiConsumer<String, String> headers = (key, val) -> new HeadersAdaptor(nettyRequest.headers()).add((String)key, (String)val);
                String operation = request.traceOperation;
                if (operation == null) {
                    operation = request.method.name();
                }
                stream.trace = tracer.sendRequest(stream.context, SpanKind.RPC, this.options.getTracingPolicy(), request, operation, headers, HttpUtils.CLIENT_HTTP_REQUEST_TAG_EXTRACTOR);
            }
        }
        this.writeToChannel((Object)nettyRequest, handler == null ? null : this.context.promise(handler));
        if (end) {
            this.endRequest(stream);
        }
    }

    private void writeBuffer(Stream s, ByteBuf buff, boolean end, FutureListener<Void> listener) {
        Object msg;
        Stream stream = s;
        stream.bytesWritten = stream.bytesWritten + (buff != null ? (long)buff.readableBytes() : 0L);
        if (this.isConnect) {
            ByteBuf byteBuf = msg = buff != null ? buff : Unpooled.EMPTY_BUFFER;
            if (end) {
                this.writeToChannel(msg, this.channelFuture().addListener(listener).addListener(v -> this.close()));
            } else {
                this.writeToChannel(msg);
            }
        } else {
            msg = end ? (buff != null && buff.isReadable() ? new DefaultLastHttpContent(buff, false) : LastHttpContent.EMPTY_LAST_CONTENT) : new DefaultHttpContent(buff);
            this.writeToChannel(msg, listener);
            if (end) {
                this.endRequest(s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endRequest(Stream s) {
        boolean responseEnded;
        Stream next;
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            s.requestEnded = true;
            this.requests.pop();
            next = this.requests.peek();
            responseEnded = s.responseEnded;
            if (this.metrics != null) {
                this.metrics.requestEnd(s.metric, s.bytesWritten);
            }
        }
        this.flushBytesWritten();
        if (next != null) {
            next.promise.complete((HttpClientStream)((Object)next));
        }
        if (responseEnded) {
            s.context.execute(null, s::handleClosed);
            this.checkLifecycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reset(Stream stream) {
        boolean inflight;
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            boolean bl = inflight = this.responses.contains(stream) || stream.responseEnded;
            if (!inflight) {
                this.requests.remove(stream);
            }
            this.close = inflight;
        }
        this.checkLifecycle();
        return !inflight;
    }

    private void receiveBytes(int len) {
        boolean gt;
        boolean le = this.readWindow <= this.highWaterMark;
        this.readWindow += (long)len;
        boolean bl = gt = this.readWindow > this.highWaterMark;
        if (le && gt) {
            this.doPause();
        }
    }

    private void ackBytes(int len) {
        EventLoop eventLoop = this.context.nettyEventLoop();
        if (eventLoop.inEventLoop()) {
            boolean le;
            boolean gt = this.readWindow > this.lowWaterMark;
            this.readWindow -= (long)len;
            boolean bl = le = this.readWindow <= this.lowWaterMark;
            if (gt && le) {
                this.doResume();
            }
        } else {
            eventLoop.execute(() -> this.ackBytes(len));
        }
    }

    private void checkLifecycle() {
        if (this.close || this.shutdown && this.requests.isEmpty() && this.responses.isEmpty()) {
            this.close();
        } else if (!this.isConnect) {
            this.expirationTimestamp = Http1xClientConnection.expirationTimestampOf(this.keepAliveTimeout);
        }
    }

    @Override
    public Future<Void> close() {
        if (!this.evicted) {
            this.evicted = true;
            if (this.evictionHandler != null) {
                this.evictionHandler.handle(null);
            }
        }
        return super.close();
    }

    private Throwable validateMessage(Object msg) {
        if (msg instanceof HttpObject) {
            org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.HttpVersion version;
            HttpObject obj = (HttpObject)msg;
            DecoderResult result = obj.decoderResult();
            if (result.isFailure()) {
                return result.cause();
            }
            if (obj instanceof HttpResponse && (version = ((HttpResponse)obj).protocolVersion()) != org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.HttpVersion.HTTP_1_0 && version != org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.HttpVersion.HTTP_1_1) {
                return new IllegalStateException("Unsupported HTTP version: " + version);
            }
        }
        return null;
    }

    @Override
    public void handleMessage(Object msg) {
        Throwable error = this.validateMessage(msg);
        if (error != null) {
            ReferenceCountUtil.release((Object)msg);
            this.fail(error);
        } else if (msg instanceof HttpObject) {
            this.handleHttpMessage((HttpObject)msg);
        } else if (msg instanceof ByteBuf && this.isConnect) {
            this.handleChunk((ByteBuf)msg);
        } else if (msg instanceof WebSocketFrame) {
            this.handleWsFrame((WebSocketFrame)msg);
        } else {
            this.invalidMessageHandler.handle(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHttpMessage(HttpObject obj) {
        Stream stream;
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            stream = this.responses.peekFirst();
        }
        if (stream == null) {
            this.fail(new VertxException("Received HTTP message with no request in progress"));
        } else if (obj instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)obj;
            HttpVersion version = response.protocolVersion() == org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.HttpVersion.HTTP_1_0 ? HttpVersion.HTTP_1_0 : HttpVersion.HTTP_1_1;
            this.handleResponseBegin(stream, new HttpResponseHead(version, response.status().code(), response.status().reasonPhrase(), new HeadersAdaptor(response.headers())));
        } else if (obj instanceof HttpContent) {
            HttpContent chunk = (HttpContent)obj;
            if (chunk.content().isReadable()) {
                this.handleResponseChunk(stream, chunk.content());
            }
            if (!this.isConnect && chunk instanceof LastHttpContent) {
                this.handleResponseEnd(stream, (LastHttpContent)chunk);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleChunk(ByteBuf chunk) {
        Stream stream;
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            stream = this.responses.peekFirst();
            if (stream == null) {
                return;
            }
        }
        if (chunk.isReadable()) {
            this.handleResponseChunk(stream, chunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResponseBegin(Stream stream, HttpResponseHead response) {
        if (response.statusCode == HttpResponseStatus.CONTINUE.code()) {
            stream.context.execute(null, v -> stream.handleContinue());
        } else if (response.statusCode == HttpResponseStatus.EARLY_HINTS.code()) {
            stream.context.execute(null, v -> stream.handleEarlyHints(response.headers));
        } else {
            HttpRequestHead request;
            Http1xClientConnection http1xClientConnection = this;
            synchronized (http1xClientConnection) {
                request = stream.request;
                stream.response = response;
                if (this.metrics != null) {
                    this.metrics.responseBegin(stream.metric, response);
                }
            }
            stream.handleHead(response);
            if (this.isConnect) {
                if (request.method == HttpMethod.CONNECT && response.statusCode == 200 || request.method == HttpMethod.GET && request.headers != null && request.headers.contains(HttpHeaders.CONNECTION, HttpHeaders.UPGRADE, true) && response.statusCode == 101) {
                    this.removeChannelHandlers();
                } else {
                    this.isConnect = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChannelHandlers() {
        ChannelPipeline pipeline = this.chctx.pipeline();
        ChannelHandler inflater = pipeline.get(HttpContentDecompressor.class);
        if (inflater != null) {
            pipeline.remove(inflater);
        }
        Handler<Object> prev = this.invalidMessageHandler;
        this.invalidMessageHandler = msg -> ReferenceCountUtil.release((Object)msg);
        try {
            pipeline.remove("codec");
        }
        finally {
            this.invalidMessageHandler = prev;
        }
    }

    private void handleResponseChunk(Stream stream, ByteBuf chunk) {
        Buffer buff = Buffer.buffer(VertxHandler.safeBuffer(chunk));
        int len = buff.length();
        this.receiveBytes(len);
        Stream stream2 = stream;
        stream2.bytesRead = stream2.bytesRead + (long)len;
        stream.context.execute(buff, stream::handleChunk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResponseEnd(Stream stream, LastHttpContent trailer) {
        boolean check;
        HttpResponseHead response;
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            response = stream.response;
            if (response == null) {
                return;
            }
            this.responses.pop();
            HttpRequestHead request = stream.request;
            if (request.method != HttpMethod.CONNECT && response.statusCode != 101) {
                int timeout;
                boolean close;
                String responseConnectionHeader = response.headers.get((CharSequence)HttpHeaderNames.CONNECTION);
                String requestConnectionHeader = request.headers != null ? request.headers.get((CharSequence)HttpHeaderNames.CONNECTION) : null;
                boolean bl = close = !this.options.isKeepAlive();
                if (HttpHeaderValues.CLOSE.contentEqualsIgnoreCase((CharSequence)responseConnectionHeader) || HttpHeaderValues.CLOSE.contentEqualsIgnoreCase((CharSequence)requestConnectionHeader)) {
                    close = true;
                } else if (response.version == HttpVersion.HTTP_1_0 && !HttpHeaderValues.KEEP_ALIVE.contentEqualsIgnoreCase((CharSequence)responseConnectionHeader)) {
                    close = true;
                }
                this.close = close;
                String keepAliveHeader = response.headers.get((CharSequence)HttpHeaderNames.KEEP_ALIVE);
                if (keepAliveHeader != null && (timeout = HttpUtils.parseKeepAliveHeaderTimeout(keepAliveHeader)) != -1) {
                    this.keepAliveTimeout = timeout;
                }
            }
            stream.responseEnded = true;
            check = this.requests.peek() != stream;
        }
        VertxTracer tracer = this.context.tracer();
        if (tracer != null) {
            tracer.receiveResponse(stream.context, response, stream.trace, null, HttpUtils.CLIENT_RESPONSE_TAG_EXTRACTOR);
        }
        if (this.metrics != null) {
            this.metrics.responseEnd(stream.metric, stream.bytesRead);
        }
        this.flushBytesRead();
        if (check) {
            this.checkLifecycle();
        }
        this.lastResponseReceivedTimestamp = System.currentTimeMillis();
        stream.context.execute(trailer, stream::handleEnd);
        if (stream.requestEnded) {
            stream.context.execute(null, stream::handleClosed);
        }
    }

    @Override
    public HttpClientMetrics metrics() {
        return this.client.metrics();
    }

    synchronized void toWebSocket(ContextInternal context, String requestURI, MultiMap headers, boolean allowOriginHeader, WebsocketVersion vers, List<String> subProtocols, long handshakeTimeout, boolean registerWriteHandlers, int maxWebSocketFrameSize, Promise<WebSocket> promise) {
        try {
            DefaultHttpHeaders nettyHeaders;
            URI wsuri = new URI(requestURI);
            if (!wsuri.isAbsolute()) {
                wsuri = new URI((this.ssl ? "https:" : "http:") + "//" + this.server.host() + ":" + this.server.port() + requestURI);
            }
            WebSocketVersion version = WebSocketVersion.valueOf((String)((Enum)(vers == null ? WebSocketVersion.V13 : vers)).toString());
            if (headers != null) {
                nettyHeaders = new DefaultHttpHeaders();
                for (Map.Entry entry : headers) {
                    nettyHeaders.add((String)entry.getKey(), entry.getValue());
                }
            } else {
                nettyHeaders = null;
            }
            long timer = handshakeTimeout > 0L ? this.vertx.setTimer(handshakeTimeout, id -> this.close()) : -1L;
            ChannelPipeline p = this.chctx.channel().pipeline();
            ArrayList<WebSocketClientExtensionHandshaker> extensionHandshakers = this.initializeWebSocketExtensionHandshakers(this.client.options());
            if (!extensionHandshakers.isEmpty()) {
                p.addBefore("handler", "webSocketsExtensionsHandler", (ChannelHandler)new WebSocketClientExtensionHandler(extensionHandshakers.toArray(new WebSocketClientExtensionHandshaker[0])));
            }
            String subp = null;
            if (subProtocols != null) {
                subp = String.join((CharSequence)",", subProtocols);
            }
            WebSocketClientHandshaker handshaker = Http1xClientConnection.newHandshaker(wsuri, version, subp, !extensionHandshakers.isEmpty(), allowOriginHeader, (org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaders)nettyHeaders, maxWebSocketFrameSize, !this.options.isSendUnmaskedFrames());
            Handler<AsyncResult<HeadersAdaptor>> webSocketHandshakeComplete = ar -> {
                if (timer > 0L) {
                    this.vertx.cancelTimer(timer);
                }
                if (ar.failed()) {
                    this.close();
                    promise.fail(ar.cause());
                } else {
                    WebSocketImpl ws = this.finish(context, version, registerWriteHandlers, handshaker, (MultiMap)ar.result());
                    this.webSocket = ws;
                    ws.pause();
                    this.getContext().emit(ws, w -> {
                        promise.handle((AsyncResult<WebSocket>)Future.succeededFuture(w));
                        ((WebSocketImpl)this.webSocket).headers(null);
                    });
                }
            };
            WebSocketHandshakeInboundHandler handshakeInboundHandler = new WebSocketHandshakeInboundHandler(handshaker, webSocketHandshakeComplete);
            p.addBefore("handler", "handshakeCompleter", (ChannelHandler)handshakeInboundHandler);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private WebSocketImpl finish(ContextInternal context, WebSocketVersion version, boolean registerWriteHandlers, WebSocketClientHandshaker handshaker, MultiMap headers) {
        WebSocketImpl ws = new WebSocketImpl(context, this, version != WebSocketVersion.V00, this.options.getWebSocketClosingTimeout(), this.options.getMaxWebSocketFrameSize(), this.options.getMaxWebSocketMessageSize(), registerWriteHandlers);
        ws.subProtocol(handshaker.actualSubprotocol());
        ws.registerHandler(this.vertx.eventBus());
        log.debug("WebSocket handshake complete");
        HttpClientMetrics metrics = this.client.metrics();
        if (metrics != null) {
            ws.setMetric(metrics.connected(ws));
        }
        ws.headers(headers);
        return ws;
    }

    static WebSocketClientHandshaker newHandshaker(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, final boolean allowOriginHeader, org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaders customHeaders, int maxFramePayloadLength, boolean performMasking) {
        final WebSocketDecoderConfig config = WebSocketDecoderConfig.newBuilder().expectMaskedFrames(false).allowExtensions(allowExtensions).maxFramePayloadLength(maxFramePayloadLength).allowMaskMismatch(false).closeOnProtocolViolation(false).build();
        if (version == WebSocketVersion.V13) {
            return new WebSocketClientHandshaker13(webSocketURL, WebSocketVersion.V13, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, performMasking, false, -1L){

                protected WebSocketFrameDecoder newWebsocketDecoder() {
                    return new WebSocket13FrameDecoder(config);
                }

                protected FullHttpRequest newHandshakeRequest() {
                    FullHttpRequest request = super.newHandshakeRequest();
                    if (!allowOriginHeader) {
                        request.headers().remove(HttpHeaders.ORIGIN);
                    }
                    return request;
                }
            };
        }
        if (version == WebSocketVersion.V08) {
            return new WebSocketClientHandshaker08(webSocketURL, WebSocketVersion.V08, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, performMasking, false, -1L){

                protected WebSocketFrameDecoder newWebsocketDecoder() {
                    return new WebSocket08FrameDecoder(config);
                }

                protected FullHttpRequest newHandshakeRequest() {
                    FullHttpRequest request = super.newHandshakeRequest();
                    if (!allowOriginHeader) {
                        request.headers().remove((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ORIGIN);
                    }
                    return request;
                }
            };
        }
        if (version == WebSocketVersion.V07) {
            return new WebSocketClientHandshaker07(webSocketURL, WebSocketVersion.V07, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, performMasking, false, -1L){

                protected WebSocketFrameDecoder newWebsocketDecoder() {
                    return new WebSocket07FrameDecoder(config);
                }

                protected FullHttpRequest newHandshakeRequest() {
                    FullHttpRequest request = super.newHandshakeRequest();
                    if (!allowOriginHeader) {
                        request.headers().remove((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ORIGIN);
                    }
                    return request;
                }
            };
        }
        if (version == WebSocketVersion.V00) {
            return new WebSocketClientHandshaker00(webSocketURL, WebSocketVersion.V00, subprotocol, customHeaders, maxFramePayloadLength, -1L){

                protected FullHttpRequest newHandshakeRequest() {
                    FullHttpRequest request = super.newHandshakeRequest();
                    if (!allowOriginHeader) {
                        request.headers().remove(HttpHeaders.ORIGIN);
                    }
                    return request;
                }
            };
        }
        throw new WebSocketHandshakeException("Protocol version " + version + " not supported.");
    }

    ArrayList<WebSocketClientExtensionHandshaker> initializeWebSocketExtensionHandshakers(HttpClientOptions options) {
        ArrayList<WebSocketClientExtensionHandshaker> extensionHandshakers = new ArrayList<WebSocketClientExtensionHandshaker>();
        if (options.getTryUsePerFrameWebSocketCompression()) {
            extensionHandshakers.add((WebSocketClientExtensionHandshaker)new DeflateFrameClientExtensionHandshaker(options.getWebSocketCompressionLevel(), false));
        }
        if (options.getTryUsePerMessageWebSocketCompression()) {
            extensionHandshakers.add((WebSocketClientExtensionHandshaker)new PerMessageDeflateClientExtensionHandshaker(options.getWebSocketCompressionLevel(), ZlibCodecFactory.isSupportingWindowSizeAndMemLevel(), 15, options.getWebSocketCompressionAllowClientNoContext(), options.getWebSocketCompressionRequestServerNoContext()));
        }
        return extensionHandshakers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleInterestedOpsChanged() {
        Handler<Boolean> handler;
        ContextInternal context;
        boolean writable = !this.isNotWritable();
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            Stream current = this.requests.peek();
            if (current != null) {
                context = current.context;
                handler = current::handleWritabilityChanged;
            } else if (this.webSocket != null) {
                context = ((WebSocketImpl)this.webSocket).context;
                handler = ((WebSocketImpl)this.webSocket)::handleWritabilityChanged;
            } else {
                return;
            }
        }
        context.execute(writable, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleClosed() {
        ArrayList<Stream> allocatedStreams;
        ArrayList<Stream> sentStreams;
        WebSocketImpl ws;
        super.handleClosed();
        long timerID = this.shutdownTimerID;
        if (timerID != -1L) {
            this.shutdownTimerID = -1L;
            this.vertx.cancelTimer(timerID);
        }
        this.closed = true;
        if (this.metrics != null) {
            HttpClientMetrics met = this.client.metrics();
            met.endpointDisconnected(this.metrics);
        }
        if (!this.evicted) {
            this.evicted = true;
            if (this.evictionHandler != null) {
                this.evictionHandler.handle(null);
            }
        }
        VertxTracer tracer = this.context.tracer();
        Iterator iterator = this;
        synchronized (iterator) {
            ws = (WebSocketImpl)this.webSocket;
            sentStreams = new ArrayList<Stream>(this.responses);
            allocatedStreams = new ArrayList<Stream>(this.requests);
            allocatedStreams.removeAll(this.responses);
        }
        if (ws != null) {
            ws.handleConnectionClosed();
        }
        for (Stream stream : allocatedStreams) {
            stream.context.execute(HttpUtils.CONNECTION_CLOSED_EXCEPTION, stream::handleClosed);
        }
        for (Stream stream : sentStreams) {
            if (this.metrics != null) {
                this.metrics.requestReset(stream.metric);
            }
            Object trace = stream.trace;
            if (tracer != null && trace != null) {
                tracer.receiveResponse(stream.context, null, trace, HttpUtils.CONNECTION_CLOSED_EXCEPTION, TagExtractor.empty());
            }
            stream.context.execute(HttpUtils.CONNECTION_CLOSED_EXCEPTION, stream::handleClosed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleIdle(IdleStateEvent event) {
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            if (this.webSocket == null && this.responses.isEmpty() && this.requests.isEmpty()) {
                return;
            }
        }
        super.handleIdle(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleException(Throwable e) {
        super.handleException(e);
        LinkedHashSet<Stream> allStreams = new LinkedHashSet<Stream>();
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            allStreams.addAll(this.requests);
            allStreams.addAll(this.responses);
        }
        for (Stream stream : allStreams) {
            stream.handleException(e);
        }
    }

    @Override
    public Future<HttpClientRequest> createRequest(ContextInternal context) {
        return ((HttpClientImpl)this.client).createRequest(this, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createStream(ContextInternal context, Handler<AsyncResult<HttpClientStream>> handler) {
        EventLoop eventLoop = context.nettyEventLoop();
        if (eventLoop.inEventLoop()) {
            StreamImpl stream;
            Http1xClientConnection http1xClientConnection = this;
            synchronized (http1xClientConnection) {
                if (this.closed) {
                    stream = null;
                } else {
                    stream = new StreamImpl(context, this, this.seq++);
                    this.requests.add(stream);
                    if (this.requests.size() == 1) {
                        stream.promise.complete(stream);
                    }
                }
            }
            if (stream != null) {
                stream.promise.future().onComplete(handler);
            } else {
                handler.handle(Future.failedFuture(HttpUtils.CONNECTION_CLOSED_EXCEPTION));
            }
        } else {
            eventLoop.execute(() -> this.createStream(context, handler));
        }
    }

    @Override
    public long lastResponseReceivedTimestamp() {
        return this.lastResponseReceivedTimestamp;
    }

    @Override
    public boolean isValid() {
        return this.expirationTimestamp == 0L || System.currentTimeMillis() <= this.expirationTimestamp;
    }

    private synchronized void shutdownNow() {
        this.shutdownTimerID = -1L;
        this.close();
    }

    @Override
    public Future<Void> shutdown(long timeout, TimeUnit unit) {
        PromiseInternal<Void> promise = this.vertx.promise();
        this.shutdown(unit.toMillis(timeout), promise);
        return promise.future();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown(long timeoutMs, PromiseInternal<Void> promise) {
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            if (this.shutdown) {
                promise.fail("Already shutdown");
                return;
            }
            this.shutdown = true;
            this.closeFuture().onComplete(promise);
        }
        http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            if (!this.closed) {
                if (timeoutMs > 0L) {
                    this.shutdownTimerID = this.context.setTimer(timeoutMs, id -> this.shutdownNow());
                } else {
                    this.close = true;
                }
            }
        }
        this.checkLifecycle();
    }

    private static long expirationTimestampOf(long timeout) {
        return timeout == 0L ? 0L : System.currentTimeMillis() + timeout * 1000L;
    }

    private static class StreamImpl
    extends Stream
    implements HttpClientStream {
        private final Http1xClientConnection conn;
        private final InboundBuffer<Object> queue;
        private boolean reset;
        private boolean closed;
        private Handler<HttpResponseHead> headHandler;
        private Handler<Buffer> chunkHandler;
        private Handler<MultiMap> endHandler;
        private Handler<Void> drainHandler;
        private Handler<Void> continueHandler;
        private int writeInProgress = 0;
        private Handler<MultiMap> earlyHintsHandler;
        private Handler<Throwable> exceptionHandler;
        private Handler<Void> closeHandler;

        StreamImpl(ContextInternal context, Http1xClientConnection conn, int id) {
            super(context, id);
            this.conn = conn;
            this.queue = new InboundBuffer<Object>(context, 5L).handler(item -> {
                if (!this.reset) {
                    if (item instanceof MultiMap) {
                        Handler<MultiMap> handler = this.endHandler;
                        if (handler != null) {
                            handler.handle((MultiMap)item);
                        }
                    } else {
                        Buffer buffer = (Buffer)item;
                        int len = buffer.length();
                        conn.ackBytes(len);
                        Handler<Buffer> handler = this.chunkHandler;
                        if (handler != null) {
                            handler.handle(buffer);
                        }
                    }
                }
            }).exceptionHandler(context::reportException);
        }

        @Override
        public void continueHandler(Handler<Void> handler) {
            this.continueHandler = handler;
        }

        @Override
        public void earlyHintsHandler(Handler<MultiMap> handler) {
            this.earlyHintsHandler = handler;
        }

        public StreamImpl drainHandler(Handler<Void> handler) {
            this.drainHandler = handler;
            return this;
        }

        @Override
        public StreamImpl exceptionHandler(Handler<Throwable> handler) {
            this.exceptionHandler = handler;
            return this;
        }

        @Override
        public WriteStream<Buffer> setWriteQueueMaxSize(int maxSize) {
            return null;
        }

        @Override
        public boolean writeQueueFull() {
            return false;
        }

        @Override
        public void headHandler(Handler<HttpResponseHead> handler) {
            this.headHandler = handler;
        }

        @Override
        public void closeHandler(Handler<Void> handler) {
            this.closeHandler = handler;
        }

        @Override
        public void priorityHandler(Handler<StreamPriority> handler) {
        }

        @Override
        public void pushHandler(Handler<HttpClientPush> handler) {
        }

        @Override
        public void unknownFrameHandler(Handler<HttpFrame> handler) {
        }

        @Override
        public int id() {
            return this.id;
        }

        @Override
        public Object metric() {
            return super.metric();
        }

        @Override
        public Object trace() {
            return super.trace();
        }

        @Override
        public HttpVersion version() {
            return this.conn.version;
        }

        @Override
        public HttpClientConnection connection() {
            return this.conn;
        }

        @Override
        public ContextInternal getContext() {
            return this.context;
        }

        @Override
        public void writeHead(HttpRequestHead request, boolean chunked, ByteBuf buf, boolean end, StreamPriority priority, boolean connect, Handler<AsyncResult<Void>> handler) {
            this.writeHead(request, chunked, buf, end, connect, handler == null ? null : this.context.promise(handler));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeHead(HttpRequestHead request, boolean chunked, ByteBuf buf, boolean end, boolean connect, Handler<AsyncResult<Void>> handler) {
            EventLoop eventLoop = this.conn.context.nettyEventLoop();
            StreamImpl streamImpl = this;
            synchronized (streamImpl) {
                if (this.shouldQueue(eventLoop)) {
                    this.queueForWrite(eventLoop, () -> {
                        ((Stream)this).request = request;
                        this.conn.beginRequest(this, request, chunked, buf, end, connect, handler);
                    });
                    return;
                }
            }
            ((Stream)this).request = request;
            this.conn.beginRequest(this, request, chunked, buf, end, connect, handler);
        }

        @Override
        public void writeBuffer(ByteBuf buff, boolean end, Handler<AsyncResult<Void>> handler) {
            if (buff != null || end) {
                PromiseInternal<Void> listener = handler == null ? null : this.context.promise(handler);
                this.writeBuffer(buff, end, (FutureListener<Void>)listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeBuffer(ByteBuf buff, boolean end, FutureListener<Void> listener) {
            Object object;
            FutureListener l;
            if (buff != null) {
                int size = buff.readableBytes();
                l = future -> {
                    Handler<Void> drain;
                    Http1xClientConnection http1xClientConnection = this.conn;
                    synchronized (http1xClientConnection) {
                        Http1xClientConnection http1xClientConnection2 = this.conn;
                        http1xClientConnection2.writeWindow = http1xClientConnection2.writeWindow - (long)size;
                        if (this.conn.writeOverflow && this.conn.writeWindow < this.conn.lowWaterMark) {
                            drain = this.drainHandler;
                            this.conn.writeOverflow = false;
                        } else {
                            drain = null;
                        }
                    }
                    if (drain != null) {
                        this.context.emit(drain);
                    }
                    if (listener != null) {
                        listener.operationComplete(future);
                    }
                };
                object = this.conn;
                synchronized (object) {
                    Http1xClientConnection http1xClientConnection = this.conn;
                    http1xClientConnection.writeWindow = http1xClientConnection.writeWindow + (long)size;
                    if (this.conn.writeWindow > this.conn.highWaterMark) {
                        this.conn.writeOverflow = true;
                    }
                }
            } else {
                l = listener;
            }
            EventLoop eventLoop = this.conn.context.nettyEventLoop();
            object = this;
            synchronized (object) {
                if (this.shouldQueue(eventLoop)) {
                    this.queueForWrite(eventLoop, () -> this.conn.writeBuffer(this, buff, end, (FutureListener<Void>)l));
                    return;
                }
            }
            this.conn.writeBuffer(this, buff, end, (FutureListener<Void>)l);
        }

        private boolean shouldQueue(EventLoop eventLoop) {
            return !eventLoop.inEventLoop() || this.writeInProgress > 0;
        }

        private void queueForWrite(EventLoop eventLoop, Runnable action) {
            ++this.writeInProgress;
            eventLoop.execute(() -> {
                StreamImpl streamImpl = this;
                synchronized (streamImpl) {
                    --this.writeInProgress;
                }
                action.run();
            });
        }

        @Override
        public void writeFrame(int type, int flags, ByteBuf payload) {
            throw new IllegalStateException("Cannot write an HTTP/2 frame over an HTTP/1.x connection");
        }

        @Override
        public void doSetWriteQueueMaxSize(int size) {
            this.conn.doSetWriteQueueMaxSize(size);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isNotWritable() {
            Http1xClientConnection http1xClientConnection = this.conn;
            synchronized (http1xClientConnection) {
                return this.conn.writeWindow > this.conn.highWaterMark;
            }
        }

        @Override
        public void doPause() {
            this.queue.pause();
        }

        @Override
        public void doFetch(long amount) {
            this.queue.fetch(amount);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reset(Throwable cause) {
            Http1xClientConnection http1xClientConnection = this.conn;
            synchronized (http1xClientConnection) {
                if (this.reset) {
                    return;
                }
                this.reset = true;
            }
            EventLoop eventLoop = this.conn.context.nettyEventLoop();
            if (eventLoop.inEventLoop()) {
                this._reset(cause);
            } else {
                eventLoop.execute(() -> this._reset(cause));
            }
        }

        private void _reset(Throwable cause) {
            boolean removed = this.conn.reset(this);
            if (removed) {
                this.context.execute(cause, this::handleClosed);
            } else {
                this.context.execute(cause, this::handleException);
            }
        }

        @Override
        public StreamPriority priority() {
            return null;
        }

        @Override
        public void updatePriority(StreamPriority streamPriority) {
        }

        @Override
        void handleWritabilityChanged(boolean writable) {
        }

        @Override
        void handleContinue() {
            if (this.continueHandler != null) {
                this.continueHandler.handle(null);
            }
        }

        @Override
        void handleEarlyHints(MultiMap headers) {
            if (this.earlyHintsHandler != null) {
                this.earlyHintsHandler.handle(headers);
            }
        }

        @Override
        void handleHead(HttpResponseHead response) {
            Handler<HttpResponseHead> handler = this.headHandler;
            if (handler != null) {
                this.context.emit(response, handler);
            }
        }

        @Override
        public void chunkHandler(Handler<Buffer> handler) {
            this.chunkHandler = handler;
        }

        @Override
        public void endHandler(Handler<MultiMap> handler) {
            this.endHandler = handler;
        }

        @Override
        void handleChunk(Buffer buff) {
            this.queue.write(buff);
        }

        @Override
        void handleEnd(LastHttpContent trailer) {
            this.queue.write((Object)new HeadersAdaptor(trailer.trailingHeaders()));
        }

        @Override
        void handleException(Throwable cause) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.handle(cause);
            }
        }

        @Override
        void handleClosed(Throwable err) {
            if (err != null) {
                this.handleException(err);
                this.promise.tryFail(err);
            }
            if (!this.closed) {
                this.closed = true;
                if (this.closeHandler != null) {
                    this.closeHandler.handle(null);
                }
            }
        }
    }

    private static abstract class Stream {
        protected final Promise<HttpClientStream> promise;
        protected final ContextInternal context;
        protected final int id;
        private Object trace;
        private Object metric;
        private HttpRequestHead request;
        private HttpResponseHead response;
        private boolean requestEnded;
        private boolean responseEnded;
        private long bytesRead;
        private long bytesWritten;

        Stream(ContextInternal context, int id) {
            this.context = context;
            this.id = id;
            this.promise = context.promise();
        }

        Object metric() {
            return this.metric;
        }

        Object trace() {
            return this.trace;
        }

        abstract void handleContinue();

        abstract void handleEarlyHints(MultiMap var1);

        abstract void handleHead(HttpResponseHead var1);

        abstract void handleChunk(Buffer var1);

        abstract void handleEnd(LastHttpContent var1);

        abstract void handleWritabilityChanged(boolean var1);

        abstract void handleException(Throwable var1);

        abstract void handleClosed(Throwable var1);
    }
}

