/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.net.impl;

import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.ssl.SniCompletionEvent;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.ssl.SslHandshakeCompletionEvent;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.util.Attribute;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.util.AttributeKey;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.util.concurrent.Promise;

public class SslHandshakeCompletionHandler
extends ChannelInboundHandlerAdapter {
    static AttributeKey<String> SERVER_NAME_ATTR = AttributeKey.valueOf((String)"sniServerName");
    private final Promise<Void> promise;

    public SslHandshakeCompletionHandler(Promise<Void> promise) {
        this.promise = promise;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof SniCompletionEvent) {
            SniCompletionEvent completion = (SniCompletionEvent)evt;
            if (completion.isSuccess()) {
                Attribute val = ctx.channel().attr(SERVER_NAME_ATTR);
                val.set((Object)completion.hostname());
            } else {
                this.promise.tryFailure(completion.cause());
            }
        } else if (evt instanceof SslHandshakeCompletionEvent) {
            SslHandshakeCompletionEvent completion = (SslHandshakeCompletionEvent)evt;
            if (completion.isSuccess()) {
                ctx.pipeline().remove((ChannelHandler)this);
                this.promise.setSuccess(null);
            } else {
                this.promise.tryFailure(completion.cause());
            }
        } else {
            ctx.fireUserEventTriggered(evt);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
    }
}

