/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.elasticsearch.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.apache.pulsar.functions.api.Record;

public interface BulkProcessor
extends Closeable {
    public void appendIndexRequest(BulkIndexRequest var1) throws IOException;

    public void appendDeleteRequest(BulkDeleteRequest var1) throws IOException;

    public void flush();

    @Override
    public void close();

    public static class BulkDeleteRequest {
        private Record record;
        private long requestId;
        private String index;
        private String documentId;

        @Generated
        BulkDeleteRequest(Record record, long requestId, String index, String documentId) {
            this.record = record;
            this.requestId = requestId;
            this.index = index;
            this.documentId = documentId;
        }

        @Generated
        public static BulkDeleteRequestBuilder builder() {
            return new BulkDeleteRequestBuilder();
        }

        @Generated
        public Record getRecord() {
            return this.record;
        }

        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @Generated
        public String getIndex() {
            return this.index;
        }

        @Generated
        public String getDocumentId() {
            return this.documentId;
        }

        @Generated
        public static class BulkDeleteRequestBuilder {
            @Generated
            private Record record;
            @Generated
            private long requestId;
            @Generated
            private String index;
            @Generated
            private String documentId;

            @Generated
            BulkDeleteRequestBuilder() {
            }

            @Generated
            public BulkDeleteRequestBuilder record(Record record) {
                this.record = record;
                return this;
            }

            @Generated
            public BulkDeleteRequestBuilder requestId(long requestId) {
                this.requestId = requestId;
                return this;
            }

            @Generated
            public BulkDeleteRequestBuilder index(String index) {
                this.index = index;
                return this;
            }

            @Generated
            public BulkDeleteRequestBuilder documentId(String documentId) {
                this.documentId = documentId;
                return this;
            }

            @Generated
            public BulkDeleteRequest build() {
                return new BulkDeleteRequest(this.record, this.requestId, this.index, this.documentId);
            }

            @Generated
            public String toString() {
                return "BulkProcessor.BulkDeleteRequest.BulkDeleteRequestBuilder(record=" + String.valueOf(this.record) + ", requestId=" + this.requestId + ", index=" + this.index + ", documentId=" + this.documentId + ")";
            }
        }
    }

    public static class BulkIndexRequest {
        private Record record;
        private long requestId;
        private String index;
        private String documentId;
        private String documentSource;

        @Generated
        BulkIndexRequest(Record record, long requestId, String index, String documentId, String documentSource) {
            this.record = record;
            this.requestId = requestId;
            this.index = index;
            this.documentId = documentId;
            this.documentSource = documentSource;
        }

        @Generated
        public static BulkIndexRequestBuilder builder() {
            return new BulkIndexRequestBuilder();
        }

        @Generated
        public Record getRecord() {
            return this.record;
        }

        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @Generated
        public String getIndex() {
            return this.index;
        }

        @Generated
        public String getDocumentId() {
            return this.documentId;
        }

        @Generated
        public String getDocumentSource() {
            return this.documentSource;
        }

        @Generated
        public static class BulkIndexRequestBuilder {
            @Generated
            private Record record;
            @Generated
            private long requestId;
            @Generated
            private String index;
            @Generated
            private String documentId;
            @Generated
            private String documentSource;

            @Generated
            BulkIndexRequestBuilder() {
            }

            @Generated
            public BulkIndexRequestBuilder record(Record record) {
                this.record = record;
                return this;
            }

            @Generated
            public BulkIndexRequestBuilder requestId(long requestId) {
                this.requestId = requestId;
                return this;
            }

            @Generated
            public BulkIndexRequestBuilder index(String index) {
                this.index = index;
                return this;
            }

            @Generated
            public BulkIndexRequestBuilder documentId(String documentId) {
                this.documentId = documentId;
                return this;
            }

            @Generated
            public BulkIndexRequestBuilder documentSource(String documentSource) {
                this.documentSource = documentSource;
                return this;
            }

            @Generated
            public BulkIndexRequest build() {
                return new BulkIndexRequest(this.record, this.requestId, this.index, this.documentId, this.documentSource);
            }

            @Generated
            public String toString() {
                return "BulkProcessor.BulkIndexRequest.BulkIndexRequestBuilder(record=" + String.valueOf(this.record) + ", requestId=" + this.requestId + ", index=" + this.index + ", documentId=" + this.documentId + ", documentSource=" + this.documentSource + ")";
            }
        }
    }

    public static interface Listener {
        public void afterBulk(long var1, List<BulkOperationRequest> var3, List<BulkOperationResult> var4);

        public void afterBulk(long var1, List<BulkOperationRequest> var3, Throwable var4);
    }

    public static class BulkOperationResult {
        private String error;
        private String index;
        private String documentId;

        public boolean isError() {
            return this.error != null;
        }

        @Generated
        BulkOperationResult(String error, String index, String documentId) {
            this.error = error;
            this.index = index;
            this.documentId = documentId;
        }

        @Generated
        public static BulkOperationResultBuilder builder() {
            return new BulkOperationResultBuilder();
        }

        @Generated
        public String getError() {
            return this.error;
        }

        @Generated
        public String getIndex() {
            return this.index;
        }

        @Generated
        public String getDocumentId() {
            return this.documentId;
        }

        @Generated
        public static class BulkOperationResultBuilder {
            @Generated
            private String error;
            @Generated
            private String index;
            @Generated
            private String documentId;

            @Generated
            BulkOperationResultBuilder() {
            }

            @Generated
            public BulkOperationResultBuilder error(String error) {
                this.error = error;
                return this;
            }

            @Generated
            public BulkOperationResultBuilder index(String index) {
                this.index = index;
                return this;
            }

            @Generated
            public BulkOperationResultBuilder documentId(String documentId) {
                this.documentId = documentId;
                return this;
            }

            @Generated
            public BulkOperationResult build() {
                return new BulkOperationResult(this.error, this.index, this.documentId);
            }

            @Generated
            public String toString() {
                return "BulkProcessor.BulkOperationResult.BulkOperationResultBuilder(error=" + this.error + ", index=" + this.index + ", documentId=" + this.documentId + ")";
            }
        }
    }

    public static class BulkOperationRequest {
        private Record pulsarRecord;

        @Generated
        BulkOperationRequest(Record pulsarRecord) {
            this.pulsarRecord = pulsarRecord;
        }

        @Generated
        public static BulkOperationRequestBuilder builder() {
            return new BulkOperationRequestBuilder();
        }

        @Generated
        public Record getPulsarRecord() {
            return this.pulsarRecord;
        }

        @Generated
        public static class BulkOperationRequestBuilder {
            @Generated
            private Record pulsarRecord;

            @Generated
            BulkOperationRequestBuilder() {
            }

            @Generated
            public BulkOperationRequestBuilder pulsarRecord(Record pulsarRecord) {
                this.pulsarRecord = pulsarRecord;
                return this;
            }

            @Generated
            public BulkOperationRequest build() {
                return new BulkOperationRequest(this.pulsarRecord);
            }

            @Generated
            public String toString() {
                return "BulkProcessor.BulkOperationRequest.BulkOperationRequestBuilder(pulsarRecord=" + String.valueOf(this.pulsarRecord) + ")";
            }
        }
    }
}

