/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.influxdb.v1;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.pulsar.io.core.SinkContext;
import org.apache.pulsar.io.influxdb.BatchSink;
import org.apache.pulsar.io.influxdb.v1.InfluxDBBuilder;
import org.apache.pulsar.io.influxdb.v1.InfluxDBBuilderImpl;
import org.apache.pulsar.io.influxdb.v1.InfluxDBSinkConfig;
import org.influxdb.InfluxDB;
import org.influxdb.dto.BatchPoints;
import org.influxdb.dto.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InfluxDBAbstractSink<T>
extends BatchSink<Point, T> {
    private static final Logger log = LoggerFactory.getLogger(InfluxDBAbstractSink.class);
    private InfluxDB influxDB;
    private InfluxDB.ConsistencyLevel consistencyLevel;
    private String influxDatabase;
    private String retentionPolicy;
    protected InfluxDBBuilder influxDBBuilder = new InfluxDBBuilderImpl();

    public void open(Map<String, Object> config, SinkContext sinkContext) throws Exception {
        InfluxDBSinkConfig influxDBSinkConfig = InfluxDBSinkConfig.load(config);
        influxDBSinkConfig.validate();
        super.init(influxDBSinkConfig.getBatchTimeMs(), influxDBSinkConfig.getBatchSize());
        try {
            this.consistencyLevel = InfluxDB.ConsistencyLevel.valueOf((String)influxDBSinkConfig.getConsistencyLevel().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Illegal Consistency Level, valid values are: " + Arrays.asList(InfluxDB.ConsistencyLevel.values()));
        }
        this.influxDatabase = influxDBSinkConfig.getDatabase();
        this.retentionPolicy = influxDBSinkConfig.getRetentionPolicy();
        this.influxDB = this.influxDBBuilder.build(influxDBSinkConfig);
        List databases = this.influxDB.describeDatabases();
        if (!databases.contains(this.influxDatabase)) {
            this.influxDB.createDatabase(this.influxDatabase);
        }
    }

    @Override
    public void close() throws Exception {
        super.close();
        if (null != this.influxDB) {
            this.influxDB.close();
        }
    }

    @Override
    protected void writePoints(List<Point> points) throws Exception {
        BatchPoints.Builder batchBuilder = BatchPoints.database((String)this.influxDatabase).retentionPolicy(this.retentionPolicy).consistency(this.consistencyLevel);
        points.forEach(arg_0 -> ((BatchPoints.Builder)batchBuilder).point(arg_0));
        this.influxDB.write(batchBuilder.build());
    }
}

