/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.jdbc;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.pulsar.io.core.annotations.FieldDoc;

public class JdbcSinkConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @FieldDoc(required=false, defaultValue="", sensitive=true, help="Username used to connect to the database specified by `jdbcUrl`")
    private String userName;
    @FieldDoc(required=false, defaultValue="", sensitive=true, help="Password used to connect to the database specified by `jdbcUrl`")
    private String password;
    @FieldDoc(required=true, defaultValue="", help="The JDBC url of the database this connector connects to")
    private String jdbcUrl;
    @FieldDoc(required=true, defaultValue="", help="The name of the table this connector writes messages to")
    private String tableName;
    @FieldDoc(required=false, defaultValue="", help="Fields used in update events. A comma-separated list.")
    private String nonKey;
    @FieldDoc(required=false, defaultValue="", help="Fields used in where condition of update and delete Events. A comma-separated list.")
    private String key;
    @FieldDoc(required=false, defaultValue="false", help="All the table fields are discovered automatically. 'excludeNonDeclaredFields' indicates if the table fields not explicitly listed in `nonKey` and `key` must be included in the query. By default all the table fields are included. To leverage of table fields defaults during insertion, it is suggested to set this value to `true`.")
    private boolean excludeNonDeclaredFields = false;
    @FieldDoc(required=false, defaultValue="500", help="Enable batch mode by time. After timeoutMs milliseconds the operations queue will be flushed.")
    private int timeoutMs = 500;
    @FieldDoc(required=false, defaultValue="200", help="Enable batch mode by number of operations. This value is the max number of operations batched in the same transaction/batch.")
    private int batchSize = 200;
    @FieldDoc(required=false, defaultValue="false", help="Use the JDBC batch API. This option is suggested to improve write performance.")
    private boolean useJdbcBatch = false;
    @FieldDoc(required=false, defaultValue="true", help="Enable transactions of the database.")
    private boolean useTransactions = true;
    @FieldDoc(required=false, defaultValue="INSERT", help="If it is configured as UPSERT, the sink will use upsert semantics rather than plain INSERT/UPDATE statements. Upsert semantics refer to atomically adding a new row or updating the existing row if there is a primary key constraint violation, which provides idempotence.")
    private InsertMode insertMode = InsertMode.INSERT;
    @FieldDoc(required=false, defaultValue="FAIL", help="How to handle records with null values, possible options are DELETE or FAIL.")
    private NullValueAction nullValueAction = NullValueAction.FAIL;

    public static JdbcSinkConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (JdbcSinkConfig)mapper.readValue(new File(yamlFile), JdbcSinkConfig.class);
    }

    public static JdbcSinkConfig load(Map<String, Object> map) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (JdbcSinkConfig)mapper.readValue(mapper.writeValueAsString(map), JdbcSinkConfig.class);
    }

    public void validate() {
        if (this.timeoutMs <= 0 && this.batchSize <= 0) {
            throw new IllegalArgumentException("timeoutMs or batchSize must be set to a positive value.");
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getNonKey() {
        return this.nonKey;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isExcludeNonDeclaredFields() {
        return this.excludeNonDeclaredFields;
    }

    public int getTimeoutMs() {
        return this.timeoutMs;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public boolean isUseJdbcBatch() {
        return this.useJdbcBatch;
    }

    public boolean isUseTransactions() {
        return this.useTransactions;
    }

    public InsertMode getInsertMode() {
        return this.insertMode;
    }

    public NullValueAction getNullValueAction() {
        return this.nullValueAction;
    }

    public JdbcSinkConfig setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public JdbcSinkConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    public JdbcSinkConfig setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
        return this;
    }

    public JdbcSinkConfig setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public JdbcSinkConfig setNonKey(String nonKey) {
        this.nonKey = nonKey;
        return this;
    }

    public JdbcSinkConfig setKey(String key) {
        this.key = key;
        return this;
    }

    public JdbcSinkConfig setExcludeNonDeclaredFields(boolean excludeNonDeclaredFields) {
        this.excludeNonDeclaredFields = excludeNonDeclaredFields;
        return this;
    }

    public JdbcSinkConfig setTimeoutMs(int timeoutMs) {
        this.timeoutMs = timeoutMs;
        return this;
    }

    public JdbcSinkConfig setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public JdbcSinkConfig setUseJdbcBatch(boolean useJdbcBatch) {
        this.useJdbcBatch = useJdbcBatch;
        return this;
    }

    public JdbcSinkConfig setUseTransactions(boolean useTransactions) {
        this.useTransactions = useTransactions;
        return this;
    }

    public JdbcSinkConfig setInsertMode(InsertMode insertMode) {
        this.insertMode = insertMode;
        return this;
    }

    public JdbcSinkConfig setNullValueAction(NullValueAction nullValueAction) {
        this.nullValueAction = nullValueAction;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdbcSinkConfig)) {
            return false;
        }
        JdbcSinkConfig other = (JdbcSinkConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isExcludeNonDeclaredFields() != other.isExcludeNonDeclaredFields()) {
            return false;
        }
        if (this.getTimeoutMs() != other.getTimeoutMs()) {
            return false;
        }
        if (this.getBatchSize() != other.getBatchSize()) {
            return false;
        }
        if (this.isUseJdbcBatch() != other.isUseJdbcBatch()) {
            return false;
        }
        if (this.isUseTransactions() != other.isUseTransactions()) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$jdbcUrl = this.getJdbcUrl();
        String other$jdbcUrl = other.getJdbcUrl();
        if (this$jdbcUrl == null ? other$jdbcUrl != null : !this$jdbcUrl.equals(other$jdbcUrl)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$nonKey = this.getNonKey();
        String other$nonKey = other.getNonKey();
        if (this$nonKey == null ? other$nonKey != null : !this$nonKey.equals(other$nonKey)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        InsertMode this$insertMode = this.getInsertMode();
        InsertMode other$insertMode = other.getInsertMode();
        if (this$insertMode == null ? other$insertMode != null : !((Object)((Object)this$insertMode)).equals((Object)other$insertMode)) {
            return false;
        }
        NullValueAction this$nullValueAction = this.getNullValueAction();
        NullValueAction other$nullValueAction = other.getNullValueAction();
        return !(this$nullValueAction == null ? other$nullValueAction != null : !((Object)((Object)this$nullValueAction)).equals((Object)other$nullValueAction));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JdbcSinkConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isExcludeNonDeclaredFields() ? 79 : 97);
        result = result * 59 + this.getTimeoutMs();
        result = result * 59 + this.getBatchSize();
        result = result * 59 + (this.isUseJdbcBatch() ? 79 : 97);
        result = result * 59 + (this.isUseTransactions() ? 79 : 97);
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $jdbcUrl = this.getJdbcUrl();
        result = result * 59 + ($jdbcUrl == null ? 43 : $jdbcUrl.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $nonKey = this.getNonKey();
        result = result * 59 + ($nonKey == null ? 43 : $nonKey.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        InsertMode $insertMode = this.getInsertMode();
        result = result * 59 + ($insertMode == null ? 43 : ((Object)((Object)$insertMode)).hashCode());
        NullValueAction $nullValueAction = this.getNullValueAction();
        result = result * 59 + ($nullValueAction == null ? 43 : ((Object)((Object)$nullValueAction)).hashCode());
        return result;
    }

    public String toString() {
        return "JdbcSinkConfig(userName=" + this.getUserName() + ", password=" + this.getPassword() + ", jdbcUrl=" + this.getJdbcUrl() + ", tableName=" + this.getTableName() + ", nonKey=" + this.getNonKey() + ", key=" + this.getKey() + ", excludeNonDeclaredFields=" + this.isExcludeNonDeclaredFields() + ", timeoutMs=" + this.getTimeoutMs() + ", batchSize=" + this.getBatchSize() + ", useJdbcBatch=" + this.isUseJdbcBatch() + ", useTransactions=" + this.isUseTransactions() + ", insertMode=" + this.getInsertMode() + ", nullValueAction=" + this.getNullValueAction() + ")";
    }

    public static enum InsertMode {
        INSERT,
        UPSERT,
        UPDATE;

    }

    public static enum NullValueAction {
        FAIL,
        DELETE;

    }
}

