/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.netty;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.pulsar.io.core.annotations.FieldDoc;

public class NettySourceConfig
implements Serializable {
    private static final long serialVersionUID = -7116130435021510496L;
    @FieldDoc(required=true, defaultValue="tcp", help="The network protocol to use, supported values are 'tcp', 'udp', and 'http'")
    private String type = "tcp";
    @FieldDoc(required=true, defaultValue="127.0.0.1", help="The host name or address that the source instance to listen on")
    private String host = "127.0.0.1";
    @FieldDoc(required=true, defaultValue="10999", help="The port that the source instance to listen on")
    private int port = 10999;
    @FieldDoc(required=true, defaultValue="1", help="The number of threads of Netty Tcp Server to accept incoming connections and handle the traffic of the accepted connections")
    private int numberOfThreads = 1;

    public static NettySourceConfig load(Map<String, Object> map) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (NettySourceConfig)mapper.readValue(mapper.writeValueAsString(map), NettySourceConfig.class);
    }

    public static NettySourceConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (NettySourceConfig)mapper.readValue(new File(yamlFile), NettySourceConfig.class);
    }

    public String getType() {
        return this.type;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public NettySourceConfig setType(String type) {
        this.type = type;
        return this;
    }

    public NettySourceConfig setHost(String host) {
        this.host = host;
        return this;
    }

    public NettySourceConfig setPort(int port) {
        this.port = port;
        return this;
    }

    public NettySourceConfig setNumberOfThreads(int numberOfThreads) {
        this.numberOfThreads = numberOfThreads;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NettySourceConfig)) {
            return false;
        }
        NettySourceConfig other = (NettySourceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.getNumberOfThreads() != other.getNumberOfThreads()) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        return !(this$host == null ? other$host != null : !this$host.equals(other$host));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NettySourceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        result = result * 59 + this.getNumberOfThreads();
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        return result;
    }

    public String toString() {
        return "NettySourceConfig(type=" + this.getType() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", numberOfThreads=" + this.getNumberOfThreads() + ")";
    }
}

