/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto;

import com.google.inject.Inject;
import io.trino.decoder.DecoderColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.TypeManager;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.sql.presto.PulsarColumnHandle;
import org.apache.pulsar.sql.presto.PulsarRowDecoder;
import org.apache.pulsar.sql.presto.PulsarRowDecoderFactory;
import org.apache.pulsar.sql.presto.decoder.avro.PulsarAvroRowDecoderFactory;
import org.apache.pulsar.sql.presto.decoder.json.PulsarJsonRowDecoderFactory;
import org.apache.pulsar.sql.presto.decoder.primitive.PulsarPrimitiveRowDecoderFactory;
import org.apache.pulsar.sql.presto.decoder.protobufnative.PulsarProtobufNativeRowDecoderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarDispatchingRowDecoderFactory {
    private static final Logger log = LoggerFactory.getLogger(PulsarDispatchingRowDecoderFactory.class);
    private final Function<SchemaType, PulsarRowDecoderFactory> decoderFactories;
    private final TypeManager typeManager;

    @Inject
    public PulsarDispatchingRowDecoderFactory(TypeManager typeManager) {
        this.typeManager = typeManager;
        PulsarAvroRowDecoderFactory avro = new PulsarAvroRowDecoderFactory(typeManager);
        PulsarJsonRowDecoderFactory json = new PulsarJsonRowDecoderFactory(typeManager);
        PulsarProtobufNativeRowDecoderFactory protobufNative = new PulsarProtobufNativeRowDecoderFactory(typeManager);
        PulsarPrimitiveRowDecoderFactory primitive = new PulsarPrimitiveRowDecoderFactory();
        this.decoderFactories = schema -> {
            if (SchemaType.AVRO.equals(schema)) {
                return avro;
            }
            if (SchemaType.JSON.equals(schema)) {
                return json;
            }
            if (SchemaType.PROTOBUF_NATIVE.equals(schema)) {
                return protobufNative;
            }
            if (schema.isPrimitive()) {
                return primitive;
            }
            return null;
        };
    }

    public PulsarRowDecoder createRowDecoder(TopicName topicName, SchemaInfo schemaInfo, Set<DecoderColumnHandle> columns) {
        PulsarRowDecoderFactory rowDecoderFactory = this.createDecoderFactory(schemaInfo);
        return rowDecoderFactory.createRowDecoder(topicName, schemaInfo, columns);
    }

    public List<ColumnMetadata> extractColumnMetadata(TopicName topicName, SchemaInfo schemaInfo, PulsarColumnHandle.HandleKeyValueType handleKeyValueType) {
        PulsarRowDecoderFactory rowDecoderFactory = this.createDecoderFactory(schemaInfo);
        return rowDecoderFactory.extractColumnMetadata(topicName, schemaInfo, handleKeyValueType);
    }

    private PulsarRowDecoderFactory createDecoderFactory(SchemaInfo schemaInfo) {
        PulsarRowDecoderFactory decoderFactory = this.decoderFactories.apply(schemaInfo.getType());
        if (decoderFactory == null) {
            throw new RuntimeException(String.format("'%s' is unsupported type '%s'", schemaInfo.getName(), schemaInfo.getType()));
        }
        return decoderFactory;
    }

    public TypeManager getTypeManager() {
        return this.typeManager;
    }
}

